% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Change sampling rate}
\usage{
resample(x, p, q, h)
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{p, q}{resampling factors, specified as positive integers. \code{p / q}
is the resampling factor.}

\item{h}{Impulse response of the FIR filter specified as a numeric vector or
matrix. If it is a vector, then it represents one FIR filter to may be
applied to multiple signals in \code{x}; if it is a matrix, then each
column is a separate FIR impulse response. If not specified, a FIR filter
based on a Kaiser window is designed.}
}
\value{
output signal, returned as a vector or matrix. Each column has length
  \code{ceiling(((length(x) - 1) * p + length(h)) / q)}..
}
\description{
Resample using a polyphase algorithm.
}
\details{
If \code{h} is not specified, this function will design an optimal FIR filter
using a Kaiser-Bessel window. The filter length and the parameter \eqn{\beta}
are computed based on ref [2], Chapter 7, Eq. 7.63 (p. 476), and Eq. 7.62 (p.
474), respectively.
}
\examples{
lx <- 60
tx <- seq(0, 360, length.out = lx)
x <- sin(2 * pi * tx / 120)

# upsample
p <- 3; q <- 2
ty <- seq(0, 360, length.out = lx * p / q)
y <- resample(x, p, q)

# downsample
p <- 2; q <- 3
tz <- seq(0, 360, length.out = lx * p / q)
z <- resample(x, p, q)

# plot
plot(tx, x, type = "b", col = 1, pch = 1,
 xlab = "", ylab = "")
points(ty, y, col = 2, pch = 2)
points(tz, z, col = 3, pch = 3)
legend("bottomleft", legend = c("original", "upsampled", "downsampled"),
  lty = 1, pch = 1:3, col = 1:3)

}
\references{
[1] Proakis, J.G., and Manolakis, D.G. (2007).
Digital Signal Processing: Principles, Algorithms, and Applications,
4th ed., Prentice Hall, Chap. 6.\cr
[2] Oppenheim, A.V., Schafer, R.W., and Buck, J.R. (1999).
Discrete-time signal processing, Signal processing series,
Prentice-Hall.
}
\seealso{
\code{\link{kaiser}}
}
\author{
Eric Chassande-Mottin, \email{ecm@apc.univ-paris7.fr}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
