% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{sigma.gsl_nls}
\alias{sigma.gsl_nls}
\title{Residual standard deviation}
\usage{
\method{sigma}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric residual standard deviation value similar to \code{\link[stats]{sigma}}
}
\description{
Returns the estimated (unweighted) residual standard deviation of a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n,
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

sigma(obj)
}
\seealso{
\code{\link[stats]{sigma}}
}
