% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{cdBoundary}
\alias{cdBoundary}
\title{Lower and Upper Bounds Generator}
\usage{
cdBoundary(cvec, dvec, gammaVec, dlt, upper = TRUE)
}
\arguments{
\item{cvec}{primary boundary.}

\item{dvec}{secondary boundary.}

\item{gammaVec}{square root of information vector.}

\item{dlt}{test statistic of the primary endpoint follows a normal distribution with mean \code{dlt} and standard deviation 1.}

\item{upper}{type of bounds, upper bound is \code{TRUE}, lower bound is \code{FALSE}.}
}
\value{
lower and upper bounds for programs calculating the secondary endpoint's type I error when the correlation rho is 1.
}
\description{
Generate lower and upper bounds for programs calculating the secondary endpoint's type I error when the correlation rho between the primary endpoint and the secondary endpoint equals 1.
}
\details{
This function generates upper and lower bounds for further computation. For more details, refer to Tamhane et al. (2017+), section 4.2.
}
\examples{
cvec <- rep(1.992,3)
dvec <- c(1.535*sqrt(3),1.535*sqrt(3/2),1.535)
gammaVec <- c(sqrt(1/3),sqrt(2/3),1)
dlt <- 2
uBoundary <- cdBoundary(cvec, dvec, gammaVec, dlt, upper=TRUE)

}
\references{
Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2017+). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, to appear.
}
\author{
Jiangtao Gou
}
