% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_ice}
\alias{gsw_entropy_ice}
\title{Entropy of ice}
\usage{
gsw_entropy_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
entropy [ J/(kg*degC) ]
}
\description{
Entropy of ice
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
p <- c(      10,       50,      125,      250,      600,      1000)
e <- gsw_entropy_ice(t, p)
expect_equal(e/1e3, c(-1.303663820598987, -1.324090218294577, -1.319426394193644,
                    -1.315402956671801, -1.305426590579231, -1.287021035328113))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_ice.html}
}
\seealso{
Other things related to entropy: \code{\link{gsw_CT_from_entropy}},
  \code{\link{gsw_entropy_first_derivatives}},
  \code{\link{gsw_entropy_from_pt}},
  \code{\link{gsw_entropy_from_t}},
  \code{\link{gsw_pt_from_entropy}}
}
