% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_currencies}
\alias{info_currencies}
\title{View a table with info on supported currencies}
\usage{
info_currencies(type = c("code", "symbol"), begins_with = NULL)
}
\arguments{
\item{type}{\emph{Type of currency}

\verb{singl-kw:[code|symbol]} // \emph{default:} \code{"code"}

The type of currency information provided. Can either be \code{code} where
currency information corresponding to 3-letter currency codes is provided,
or \code{symbol} where currency info for common currency names (e.g., dollar,
pound, yen, etc.) is returned.}

\item{begins_with}{\emph{Show currencies beginning with a specific letter}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Providing a single letter will filter currencies to only those that begin
with that letter in their currency code. The default (\code{NULL}) will produce
a table with all currencies displayed. This option only constrains the
information table where \code{type == "code"}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{\link[=fmt_currency]{fmt_currency()}} function lets us format numeric values as currencies.
The table generated by the \code{\link[=info_currencies]{info_currencies()}} function provides a quick
reference to all the available currencies. The currency identifiers are
provided (name, 3-letter currency code, and 3-digit currency code) along with
the each currency's exponent value (number of digits of the currency
subunits). A formatted example is provided (based on the value of \code{49.95}) to
demonstrate the default formatting of each currency.
}
\details{
There are 172 currencies, which can lead to a verbose display table. To make
this presentation more focused on retrieval, we can provide an initial letter
corresponding to the 3-letter currency code to \code{begins_with}. This will
filter currencies in the info table to just the set beginning with the
supplied letter.
}
\section{Examples}{


Get a table of info on all of the currencies where the three-letter code
begins with an \code{"h"}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_currencies(begins_with = "h")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_currencies_1.png" alt="This image of a table was generated from the first code example in the `info_currencies()` help file." style="width:100\%;">
}}

Get a table of info on all of the common currency name/symbols that can be
used with \code{\link[=fmt_currency]{fmt_currency()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_currencies(type = "symbol")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_currencies_2.png" alt="This image of a table was generated from the second code example in the `info_currencies()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

11-3
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other information functions: 
\code{\link{info_date_style}()},
\code{\link{info_flags}()},
\code{\link{info_google_fonts}()},
\code{\link{info_icons}()},
\code{\link{info_locales}()},
\code{\link{info_paletteer}()},
\code{\link{info_time_style}()}
}
\concept{information functions}
