% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_style_body.R
\name{tab_style_body}
\alias{tab_style_body}
\title{Target cells in the table body and style accordingly}
\usage{
tab_style_body(
  data,
  style,
  columns = everything(),
  rows = everything(),
  values = NULL,
  pattern = NULL,
  fn = NULL,
  targets = "cell",
  extents = "body"
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{style}{\emph{Style declarations}

\verb{<style expressions>} // \strong{required}

The styles to use for the targeted cells. The \code{\link[=cell_text]{cell_text()}}, \code{\link[=cell_fill]{cell_fill()}},
and \code{\link[=cell_borders]{cell_borders()}} helper functions can be used here to more easily
generate valid styles. If using more than one helper function to define
styles, all calls must be enclosed in a \code{\link[=list]{list()}}. Custom CSS declarations
can be used for HTML output by including a \code{\link[=css]{css()}}-based statement as a
list item.}

\item{columns}{\emph{Columns to target}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

The columns to which the targeting operations are constrained.  Can either
be a series of column names provided in \code{\link[=c]{c()}}, a vector of column indices,
or a select helper function. Examples of select helper functions include
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. This argument works in tandem with the
\code{spanners} argument.}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
form a constraint for targeting operations. The default \code{\link[=everything]{everything()}}
results in all rows in \code{columns} being formatted. Alternatively, we can
supply a vector of row IDs within \code{\link[=c]{c()}}, a vector of row indices, or a
select helper function. Examples of select helper functions include
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{values}{\emph{Values for targeting}

\verb{vector<character|numeric|integer>} // \emph{default:} \code{NULL} (\code{optional})

The specific value or values that should be targeted for styling. If
\code{pattern} is also supplied then \code{values} will be ignored.}

\item{pattern}{\emph{Regex pattern for targeting}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A regex pattern that can target solely those values in \code{character}-based
columns. If \code{values} is also supplied, \code{pattern} will take precedence.}

\item{fn}{\emph{Function to return logical values}

\verb{<function>} // \emph{default:} \code{NULL} (\code{optional})

A supplied function that operates on each cell of each column specified
through \code{columns} and \code{rows}. The function should be fashioned such that a
single logical value is returned. If either of \code{values} or \code{pattern} is
also supplied, \code{fn} will take precedence.}

\item{targets}{\emph{Styling targets}

\verb{vector<character>} // \emph{default:} \code{"cell"}

A vector of styling target keywords to contain or expand the target of each
cell. By default, this is a vector just containing \code{"cell"}. However, the
keywords \code{"row"} and \code{"column"} may be used separately or in combination to
style the target cells' associated rows or columns.}

\item{extents}{\emph{Styling extents}

\verb{vector<character>} // \emph{default:} \code{"body"}

A vector of locations to project styling. By default, this is a vector just
containing \code{"body"}, whereby styled rows or columns (facilitated via
inclusion of the \code{"row"} and \code{"column"} keywords in \code{targets}) will not
permeate into the stub. The additional keyword \code{"stub"} may be used alone
or in conjunction with \code{"body"} to project or expand the styling into the
stub.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
With the \code{tab_style_body()} function we can target cells though value, regex,
and custom matching rules and apply styles to them and their surrounding
context (i.e., styling an entire row or column wherein the match is found).
Just as with the general \code{\link[=tab_style]{tab_style()}} function, this function is focused on
the application of styles for HTML output only (as such, other output formats
will ignore all \code{tab_style()} calls).

With the collection of \verb{cell_*()} helper functions available in \strong{gt}, we
can modify:
\itemize{
\item the background color of the cell (\code{\link[=cell_fill]{cell_fill()}}: \code{color})
\item the cell's text color, font, and size (\code{\link[=cell_text]{cell_text()}}: \code{color}, \code{font},
\code{size})
\item the text style (\code{\link[=cell_text]{cell_text()}}: \code{style}), enabling the use of italics or
oblique text.
\item the text weight (\code{\link[=cell_text]{cell_text()}}: \code{weight}), allowing the use of thin to
bold text (the degree of choice is greater with variable fonts)
\item the alignment and indentation of text (\code{\link[=cell_text]{cell_text()}}: \code{align} and
\code{indent})
\item the cell borders (\code{\link[=cell_borders]{cell_borders()}})
}
}
\section{Targeting cells with \code{columns} and \code{rows}}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). The
\code{columns} argument allows us to constrain a subset of cells contained in the
resolved columns. We say resolved because aside from declaring column names
in \code{c()} (with bare column names or names in quotes) we can use
\strong{tidyselect}-style expressions. This can be as basic as supplying a select
helper like \code{starts_with()}, or, providing a more complex incantation like

\code{where(~ is.numeric(.x) && max(.x, na.rm = TRUE) > 1E6)}

which targets numeric columns that have a maximum value greater than
1,000,000 (excluding any \code{NA}s from consideration).

By default all columns and rows are selected (with the \code{everything()}
defaults). Cell values that are incompatible with a given search will be
skipped over. So it's safe to select all columns with a type of search (only
those values that can be formatted will be formatted), but, you may not want
that. One strategy is to format the bulk of cell values with one formatting
function and then constrain the columns for later passes with other types of
formatting (the last formatting done to a cell is what you get in the final
output).

Once the columns are targeted, we may also target the \code{rows} within those
columns. This can be done in a variety of ways. If a stub is present, then we
potentially have row identifiers. Those can be used much like column names in
the \code{columns}-targeting scenario. We can use simpler \strong{tidyselect}-style
expressions (the select helpers should work well here) and we can use quoted
row identifiers in \code{c()}. It's also possible to use row indices (e.g.,
\code{c(3, 5, 6)}) though these index values must correspond to the row numbers of
the input data (the indices won't necessarily match those of rearranged rows
if row groups are present). One more type of expression is possible, an
expression that takes column values (can involve any of the available columns
in the table) and returns a logical vector.
}

\section{Examples}{


Use \code{exibble} to create a \strong{gt} table with a stub and row groups. This
contains an assortment of values that could potentially undergo some styling
via \code{tab_style_body()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl <-
  exibble |>
  gt(
    rowname_col = "row",
    groupname_col = "group"
  )
}\if{html}{\out{</div>}}

Cells in the table body can be styled through specification of literal values
in the \code{values} argument of \code{tab_style_body()}. It's okay to search for
numerical, character, or logical values across all columns. Let's target the
values \code{49.95} and \code{33.33} and style those cells with an orange fill.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    style = cell_fill(color = "orange"),
    values = c(49.95, 33.33)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_1.png" alt="This image of a table was generated from the first code example in the `tab_style_body()` help file." style="width:100\%;">
}}

Multiple styles can be combined in a \code{list}, here's an example of that using
the same cell targets:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    style = list(
      cell_text(font = google_font("Inter"), color = "white"),
      cell_fill(color = "red"),
      cell_borders(
        sides = c("left", "right"),
        color = "steelblue",
        weight = px(4)
      )
    ),
    values = c(49.95, 33.33)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_2.png" alt="This image of a table was generated from the second code example in the `tab_style_body()` help file." style="width:100\%;">
}}

You can opt to color entire rows or columns (or both, should you want to)
with those specific keywords in the \code{targets} argument. For the \code{49.95} value
we will style the entire row and with \code{33.33} the entire column will get the
same styling.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    style = cell_fill(color = "lightblue"),
    values = 49.95,
    targets = "row"
  ) |>
  tab_style_body(
    style = cell_fill(color = "lightblue"),
    values = 33.33,
    targets = "column"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_3.png" alt="This image of a table was generated from the third code example in the `tab_style_body()` help file." style="width:100\%;">
}}

In a minor variation to the prior example, it's possible to extend the
styling to other locations, or, entirely project the styling elsewhere. This
is done with the \code{extents} argument. Valid keywords that can be included in
the vector are: \code{"body"} (the default) and \code{"stub"}. Let's take the previous
example and extend the styling of the row into the stub.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    style = cell_fill(color = "lightblue"),
    values = 49.95,
    targets = "row",
    extents = c("body", "stub")
  ) |>
  tab_style_body(
    style = cell_fill(color = "lightblue"),
    values = 33.33,
    targets = "column"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_4.png" alt="This image of a table was generated from the fourth code example in the `tab_style_body()` help file." style="width:100\%;">
}}

We can also use the \code{pattern} argument to target cell values in
\code{character}-based columns. The \code{"fctr"} column is skipped because it is in
fact a factor-based column.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    style = cell_fill(color = "green"),
    pattern = "ne|na"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_5.png" alt="This image of a table was generated from the fifth code example in the `tab_style_body()` help file." style="width:100\%;">
}}

For the most flexibility in targeting, it's best to use the \code{fn} argument.
The function you give to \code{fn} will be invoked separately on all cells so the
\code{columns} argument of \code{tab_style_body()} might be useful to limit which cells
should be evaluated. For this next example, the supplied function should only
be used on numeric values and we can make sure of this by using \code{columns = where(is.numeric)}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    columns = where(is.numeric),
    style = cell_fill(color = "pink"),
    fn = function(x) x >= 0 && x < 50
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_6.png" alt="This image of a table was generated from the sixth code example in the `tab_style_body()` help file." style="width:100\%;">
}}

Styling every \code{NA} value in a table is also easily accomplished with the \code{fn}
argument by way of the \code{is.na()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl |>
  tab_style_body(
    style = cell_text(color = "red3"),
    fn = function(x) is.na(x)
  ) |>
  sub_missing(missing_text = "Not Available")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_tab_style_body_7.png" alt="This image of a table was generated from the seventh code example in the `tab_style_body()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

2-11
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
Other part creation/modification functions: 
\code{\link{tab_caption}()},
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_info}()},
\code{\link{tab_options}()},
\code{\link{tab_row_group}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stub_indent}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{part creation/modification functions}
