% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{nanoplot_options}
\alias{nanoplot_options}
\title{Supply nanoplot options to \code{cols_nanoplot()}}
\usage{
nanoplot_options(
  data_point_radius = NULL,
  data_point_stroke_color = NULL,
  data_point_stroke_width = NULL,
  data_point_fill_color = NULL,
  data_line_type = NULL,
  data_line_stroke_color = NULL,
  data_line_stroke_width = NULL,
  data_area_fill_color = NULL,
  data_bar_stroke_color = NULL,
  data_bar_stroke_width = NULL,
  data_bar_fill_color = NULL,
  data_bar_negative_stroke_color = NULL,
  data_bar_negative_stroke_width = NULL,
  data_bar_negative_fill_color = NULL,
  reference_line_color = NULL,
  reference_area_fill_color = NULL,
  vertical_guide_stroke_color = NULL,
  vertical_guide_stroke_width = NULL,
  show_data_points = NULL,
  show_data_line = NULL,
  show_data_area = NULL,
  show_reference_line = NULL,
  show_reference_area = NULL,
  show_vertical_guides = NULL,
  show_y_axis_guide = NULL,
  interactive_data_values = NULL,
  y_val_fmt_fn = NULL,
  y_axis_fmt_fn = NULL,
  y_ref_line_fmt_fn = NULL,
  currency = NULL
)
}
\arguments{
\item{data_point_radius}{\emph{Radius of data points}

\verb{scalar<numeric>|vector<numeric>} // \emph{default:} \code{NULL} (\code{optional})

The \code{data_point_radius} option lets you set the radius for each of the data
points. By default this is set to \code{10}. Individual radius values can be
set by using a vector of numeric values; however, the vector provided must
match the number of data points.}

\item{data_point_stroke_color}{\emph{Color of data points}

\verb{scalar<character>|vector<character>} // \emph{default:} \code{NULL} (\code{optional})

The default stroke color of the data points is \code{"#FFFFFF"} (\code{"white"}).
This works well when there is a visible data line combined with data points
with a darker fill color. The stroke color can be modified with
\code{data_point_stroke_color} for all data points by supplying a single color
value. With a vector of colors, each data point's stroke color can be
changed (ensure that the vector length matches the number of data points).}

\item{data_point_stroke_width}{\emph{Width of surrounding line on data points}

\verb{scalar<numeric>|vector<numeric>} // \emph{default:} \code{NULL} (\code{optional})

The width of the outside stroke for the data points can be modified with
the \code{data_point_stroke_width} option. By default, a value of \code{4} (as in
'4px') is used.}

\item{data_point_fill_color}{\emph{Fill color for data points}

\verb{scalar<character>|vector<character>} // \emph{default:} \code{NULL} (\code{optional})

By default, all data points have a fill color of \code{"#FF0000"} (\code{"red"}).
This can be changed for all data points by providing a different color
to \code{data_point_fill_color}. And, a vector of different colors can be
supplied so long as the length is equal to the number of data points; the
fill color values will be applied in order of left to right.}

\item{data_line_type}{\emph{Type of data line: curved or straight}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

This can accept either \code{"curved"} or \code{"straight"}. Curved lines are
recommended when the nanoplot has less than 30 points and data points are
evenly spaced. In most other cases, straight lines might present better.}

\item{data_line_stroke_color}{\emph{Color of the data line}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The color of the data line can be modified from its default \code{"#4682B4"}
(\code{"steelblue"}) color by supplying a color to the \code{data_line_stroke_color}
option.}

\item{data_line_stroke_width}{\emph{Width of the data line}

\verb{scalar<numeric>} // \emph{default:} \code{NULL} (\code{optional})

The width of the connecting data line can be modified with the
\code{data_line_stroke_width} option. By default, a value of \code{4} (as in '4px')
is used.}

\item{data_area_fill_color}{\emph{Fill color for the data-point-bounded area}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The fill color for the area that bounds the data points in line plot. The
default is \code{"#FF0000"} (\code{"red"}) but can be changed by providing a color
value to \code{data_area_fill_color}.}

\item{data_bar_stroke_color}{\emph{Color of a data bar's outside line}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The color of the stroke used for the data bars can be modified from its
default \code{"#3290CC"} color by supplying a color to the
\code{data_bar_stroke_color} option.}

\item{data_bar_stroke_width}{\emph{Width of a data bar's outside line}

\verb{scalar<numeric>} // \emph{default:} \code{NULL} (\code{optional})

The width of the stroke used for the data bars can be modified with the
\code{data_bar_stroke_width} option. By default, a value of \code{4} (as in '4px') is
used.}

\item{data_bar_fill_color}{\emph{Fill color for data bars}

\verb{scalar<character>|vector<character>} // \emph{default:} \code{NULL} (\code{optional})

By default, all data bars have a fill color of \code{"#3FB5FF"}. This can be
changed for all data bars by providing a different color to
\code{data_bar_fill_color}. And, a vector of different colors can be supplied so
long as the length is equal to the number of data bars; the fill color
values will be applied in order of left to right.}

\item{data_bar_negative_stroke_color}{\emph{Stroke color for negative values}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The color of the stroke used for the data bars that have negative values.
The default color is \code{"#CC3243"} but this can be changed by supplying a
color value to the \code{data_bar_negative_stroke_color} option.}

\item{data_bar_negative_stroke_width}{\emph{Stroke width for negative values}

\verb{scalar<numeric>} // \emph{default:} \code{NULL} (\code{optional})

The width of the stroke used for negative value data bars. This has the
same default as \code{data_bar_stroke_width} with a value of \code{4} (as in '4px').
This can be changed by giving a numeric value to the
\code{data_bar_negative_stroke_width} option.}

\item{data_bar_negative_fill_color}{\emph{Fill color for negative values}

\verb{scalar<character>|vector<character>} // \emph{default:} \code{NULL} (\code{optional})

By default, all negative data bars have a fill color of \code{"#D75A68"}. This
can however be changed by providing a color value to the
\code{data_bar_negative_fill_color} option.}

\item{reference_line_color}{\emph{Color for the reference line}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The reference line will have a color of \code{"#75A8B0"} if it is set to appear.
This color can be changed by providing a single color value to
\code{reference_line_color}.}

\item{reference_area_fill_color}{\emph{Fill color for the reference area}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

If a reference area has been defined and is visible it has by default
a fill color of \code{"#A6E6F2"}. This can be modified by declaring a color
value in the \code{reference_area_fill_color} option.}

\item{vertical_guide_stroke_color}{\emph{Color of vertical guides}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Vertical guides appear when hovering in the vicinity of data points. Their
default color is \code{"#911EB4"} (a strong magenta color) and a fill opacity
value of \code{0.4} is automatically applied to this. However, the base color
can be changed with the \code{vertical_guide_stroke_color} option.}

\item{vertical_guide_stroke_width}{\emph{Line widths for vertical guides}

\verb{scalar<numeric>} // \emph{default:} \code{NULL} (\code{optional})

The vertical guide's stroke width, by default, is relatively large at \code{12}
(this is '12px'). This is modifiable by setting a different value with the
\code{vertical_guide_stroke_width} option.}

\item{show_data_points}{\emph{Should the data points be shown?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

By default, all data points in a nanoplot are shown but this layer can be
hidden by setting \code{show_data_points} to \code{FALSE}.}

\item{show_data_line}{\emph{Should a data line be shown?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

The data line connects data points together and it is shown by default.
This data line layer can be hidden by setting \code{show_data_line} to \code{FALSE}.}

\item{show_data_area}{\emph{Should a data-point-bounded area be shown?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

The data area layer is adjacent to the data points and the data line. It is
shown by default but can be hidden with \code{show_data_area = FALSE}.}

\item{show_reference_line}{\emph{Should a reference line be shown?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

The layer with a horizontal reference line appears underneath that of the
data points and the data line. Like vertical guides, hovering over a
reference will show its value. The reference line (if available) is shown
by default but can be hidden by setting \code{show_reference_line} to \code{FALSE}.}

\item{show_reference_area}{\emph{Should a reference area be shown?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

The reference area appears at the very bottom of the layer stack, if it is
available (i.e., defined in \code{\link[=cols_nanoplot]{cols_nanoplot()}}). It will be shown in the
default case but can be hidden by using \code{show_reference_area = FALSE}.}

\item{show_vertical_guides}{\emph{Should there be vertical guides?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

Vertical guides appear when hovering over data points. This hidden layer is
active by default but can be deactivated by using
\code{show_vertical_guides = FALSE}.}

\item{show_y_axis_guide}{\emph{Should there be a y-axis guide?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

The \emph{y}-axis guide will appear when hovering over the far left side of a
nanoplot. This hidden layer is active by default but can be deactivated by
using \code{show_y_axis_guide = FALSE}.}

\item{interactive_data_values}{\emph{Should data values be interactively shown?}

\verb{scalar<logical>} // \emph{default:} \code{NULL} (\code{optional})

By default, numeric data values will be shown only when the user interacts
with certain regions of a nanoplot. This is because the values may be
numerous (i.e., clutter the display when all are visible) and it can be
argued that the values themselves are secondary to the presentation.
However, for some types of plots (like horizontal bar plots), a persistent
display of values alongside the plot marks may be desirable. By setting
\code{interactive_data_values = FALSE} we can opt for always displaying the data
values alongside the plot components.}

\item{y_val_fmt_fn, y_axis_fmt_fn, y_ref_line_fmt_fn}{\emph{Custom formatting for y values}

\code{function} // \emph{default:} \code{NULL} (\code{optional})

If providing a function to \code{y_val_fmt_fn}, \code{y_axis_fmt_fn}, or
\code{y_ref_line_fmt_fn} then customized formatting of the \emph{y} values associated
with the data points/bars, the \emph{y}-axis labels, and the reference line can
be performed.}

\item{currency}{\emph{Define values as currencies of a specific type}

\verb{scalar<character>|obj:<gt_currency>} // \emph{default:} \code{NULL} (\code{optional})

If the values are to be displayed as currency values, supply either: (1) a
3-letter currency code (e.g., \code{"USD"} for U.S. Dollars, \code{"EUR"} for the
Euro currency), (2) a common currency name (e.g., \code{"dollar"}, \code{"pound"},
\code{"yen"}, etc.), or (3) an invocation of the \code{\link[=currency]{currency()}} helper function
for specifying a custom currency (where the string could vary across output
contexts). Use \code{\link[=info_currencies]{info_currencies()}} to get an information table with all of
the valid currency codes, and examples of each, for the first two cases.}
}
\value{
A list object of class \code{nanoplot_options}.
}
\description{
When using \code{\link[=cols_nanoplot]{cols_nanoplot()}}, the defaults for the generated nanoplots
can be modified with \code{nanoplot_options()} within the \code{options} argument.
}
\section{Function ID}{

8-8
}

\section{Function Introduced}{

\code{v0.10.0} (October 7, 2023)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
