% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{countrypops}
\alias{countrypops}
\title{Yearly populations of countries from 1960 to 2023}
\format{
A tibble with 13,760 rows and 5 variables:
\describe{
\item{country_name}{The name of the country.}
\item{country_code_2, country_code_3}{The 2- and 3-letter ISO 3166-1 country
codes.}
\item{year}{The year for the population estimate.}
\item{population}{The population estimate, midway through the year.}
}
}
\source{
\url{https://data.worldbank.org/indicator/SP.POP.TOTL}
}
\usage{
countrypops
}
\description{
A dataset that presents yearly, total populations of countries. Total
population is based on counts of all residents regardless of legal status or
citizenship. Country identifiers include the English-language country names,
and the 2- and 3-letter ISO 3166-1 country codes. Each row contains a
\code{population} value for a given \code{year} (from 1960 to 2023). Any \code{NA} values
within \code{population} indicate the non-existence of the entity during that
year.
}
\section{Dataset ID and Badge}{

DATA-1

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_countrypops.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gibraltar}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
