% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{extract_summary}
\alias{extract_summary}
\title{Extract a summary list from a \strong{gt} object}
\usage{
extract_summary(data)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}
}
\value{
A list of data frames containing summary data.
}
\description{
Get a list of summary row data frames from a \code{gt_tbl} object where summary
rows were added via the \code{\link[=summary_rows]{summary_rows()}} function. The output data frames
contain the \code{group_id} and \code{rowname} columns, whereby \code{rowname} contains
descriptive stub labels for the summary rows.
}
\section{Examples}{


Use \code{\link{sp500}} to create a \strong{gt} table with row groups. Create summary rows
labeled as \code{min}, \code{max}, and \code{avg} for every row group with \code{\link[=summary_rows]{summary_rows()}}.
Then, extract the summary rows as a list object.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{summary_extracted <-
  sp500 |>
  dplyr::filter(date >= "2015-01-05" & date <="2015-01-30") |>
  dplyr::arrange(date) |>
  dplyr::mutate(week = paste0("W", strftime(date, format = "\%V"))) |>
  dplyr::select(-adj_close, -volume) |>
  gt(
    rowname_col = "date",
    groupname_col = "week"
  ) |>
  summary_rows(
    groups = everything(),
    columns = c(open, high, low, close),
    fns = list(
      min = ~min(.),
      max = ~max(.),
      avg = ~mean(.)
    ),
  ) |>
  extract_summary()

summary_extracted
#> $summary_df_data_list
#> $summary_df_data_list$W02
#> # A tibble: 3 x 9
#>   group_id row_id rowname  date  open  high   low close  week
#>   <chr>    <chr>  <chr>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1 W02      min    min        NA 2006. 2030. 1992. 2003.    NA
#> 2 W02      max    max        NA 2063. 2064. 2038. 2062.    NA
#> 3 W02      avg    avg        NA 2035. 2049. 2017. 2031.    NA
#> 
#> $summary_df_data_list$W03
#> # A tibble: 3 x 9
#>   group_id row_id rowname  date  open  high   low close  week
#>   <chr>    <chr>  <chr>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1 W03      min    min        NA 1992. 2018. 1988. 1993.    NA
#> 2 W03      max    max        NA 2046. 2057. 2023. 2028.    NA
#> 3 W03      avg    avg        NA 2020. 2033. 2000. 2015.    NA
#> 
#> $summary_df_data_list$W04
#> # A tibble: 3 x 9
#>   group_id row_id rowname  date  open  high   low close  week
#>   <chr>    <chr>  <chr>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1 W04      min    min        NA 2020. 2029. 2004. 2023.    NA
#> 2 W04      max    max        NA 2063. 2065. 2051. 2063.    NA
#> 3 W04      avg    avg        NA 2035. 2049. 2023. 2042.    NA
#> 
#> $summary_df_data_list$W05
#> # A tibble: 3 x 9
#>   group_id row_id rowname  date  open  high   low close  week
#>   <chr>    <chr>  <chr>   <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>
#> 1 W05      min    min        NA 2002. 2023. 1989. 1995.    NA
#> 2 W05      max    max        NA 2050. 2058. 2041. 2057.    NA
#> 3 W05      avg    avg        NA 2030. 2039. 2009. 2021.    NA
}\if{html}{\out{</div>}}

Use the summary list to make a new \strong{gt} table. The key thing is to use
\code{dplyr::bind_rows()} and then pass the tibble to \code{\link[=gt]{gt()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{summary_extracted |>
  unlist(recursive = FALSE) |>
  dplyr::bind_rows() |>
  gt(groupname_col = "group_id") |>
  cols_hide(columns = row_id)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_extract_summary_1.png" alt="This image of a table was generated from the first code example in the `extract_summary()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

13-6
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other table export functions: 
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{as_word}()},
\code{\link{extract_cells}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
