% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_percentile_dot.R
\name{gt_plt_percentile}
\alias{gt_plt_percentile}
\title{Create a dot plot for percentiles}
\usage{
gt_plt_percentile(
  gt_object,
  column,
  palette = c("#007ad6", "#f0f0f0", "#f72e2e"),
  width = 25,
  scale = 1
)
}
\arguments{
\item{gt_object}{An existing gt table}

\item{column}{The column to transform to the percentile dot plot. Accepts \code{tidyeval}. All values must be end up being between 0 and 100.}

\item{palette}{A vector of strings of length 3. Defaults to \code{c('blue', 'lightgrey', 'red')} as hex so \code{c("#007ad6", "#f0f0f0", "#f72e2e")}}

\item{width}{A numeric, indicating the width of the plot in \code{mm}, defaults to 25}

\item{scale}{A number to multiply/scale the values in the column by. Defaults to 1, but can also be 100 if you have decimals.}
}
\value{
a gt table
}
\description{
Creates a percentile dot plot in each row. Can be used as an
alternative for a 0 to 100\% bar plot. Allows for scaling values as well and
accepts a vector of colors for the range of values.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
dot_plt <- dplyr::tibble(x = c(seq(10, 90, length.out = 5))) \%>\%
  gt() \%>\%
  gt_duplicate_column(x,dupe_name = "dot_plot") \%>\%
  gt_plt_percentile(dot_plot)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_plt_percentile.png}{options: width=30\%}}
}

\section{Function ID}{

3-8
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_point}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
