% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_significant_single_tissue_eqtls.R
\name{get_significant_single_tissue_eqtls}
\alias{get_significant_single_tissue_eqtls}
\title{Get Significant Single Tissue Eqtls}
\usage{
get_significant_single_tissue_eqtls(
  gencodeIds = NULL,
  variantIds = NULL,
  tissueSiteDetailIds = NULL,
  datasetId = "gtex_v8",
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{gencodeIds}{A character vector of Versioned GENCODE IDs, e.g.
c("ENSG00000132693.12", "ENSG00000203782.5").}

\item{variantIds}{Character vector. Gtex variant IDs.}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Find significant single tissue
eQTLs.
\itemize{
\item This service returns precomputed significant single tissue eQTLs.
\item Results may be filtered by tissue, gene, variant or dataset.
\item To search by gene, use the versioned GENCODE ID.
\item To search by variant, use the dbSNP rs ID (snpId).
}

By default, the service queries the latest GTEx release and the retrieved data is split into pages with \code{items_per_page} entries per page

\href{https://gtexportal.org/api/v2/redoc#tag/Static-Association-Endpoints/operation/get_significant_single_tissue_eqtls_api_v2_association_singleTissueEqtl_get}{GTEx Portal API documentation}.
}
\details{
\strong{Note:} although the GTEx Portal API documentation says to use the dbSNP rsID
when searching by variant, this returns no results. Instead use gtex variant
IDs e.g. use "chr1_153209640_C_A_b38" instead of "rs1410858".
}
\examples{
\dontrun{
# search by gene
get_significant_single_tissue_eqtls(gencodeIds = c(
  "ENSG00000132693.12",
  "ENSG00000203782.5"
))

# search by variant - must be variantId (not rsid)
get_significant_single_tissue_eqtls(variantIds = "chr1_153209640_C_A_b38")

# filter by gene/variant and tissue site - either `gencodeIds` or `variantIds`
# should be supplied as a minimum
get_significant_single_tissue_eqtls(
  gencodeIds = c(
    "ENSG00000132693.12",
    "ENSG00000203782.5"
  ),
  variantIds = "chr1_153209640_C_A_b38",
  tissueSiteDetailIds = "Whole_Blood"
)
}
}
\seealso{
Other Static Association Endpoints: 
\code{\link{get_eqtl_genes}()},
\code{\link{get_fine_mapping}()},
\code{\link{get_independent_eqtl}()},
\code{\link{get_multi_tissue_eqtls}()},
\code{\link{get_significant_single_tissue_eqtls_by_location}()},
\code{\link{get_significant_single_tissue_ieqtls}()},
\code{\link{get_significant_single_tissue_isqtls}()},
\code{\link{get_significant_single_tissue_sqtls}()},
\code{\link{get_sqtl_genes}()}
}
\concept{Static Association Endpoints}
