% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_week_days}
\alias{filter_week_days}
\title{Filter GTFS trips operating on week days}
\usage{
filter_week_days(gtfs_data, remove_invalid = TRUE)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{remove_invalid}{Remove all the invalid objects after subsetting the data?
The default value is TRUE.}
}
\value{
A filtered GTFS data.
}
\description{
Filter a GTFS data read using gtfs2gps::read_gtfs(). It removes the
trips operating only saturday or sunday.
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))

subset <- filter_week_days(poa)
}
