% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_speed.R
\name{adjust_speed}
\alias{adjust_speed}
\title{Adjust the speeds of a gps-like table created with \code{\link{gtfs2gps}}}
\usage{
adjust_speed(
  gps_data,
  min_speed = 2,
  max_speed = 80,
  new_speed = NULL,
  clone = TRUE
)
}
\arguments{
\item{gps_data}{A GPS-like data.table created with \code{\link{gtfs2gps}}.}

\item{min_speed}{Minimum speed (in km/h) to be considered as valid. Values 
below minimum speed will be adjusted. Defaults to 2 km/h.}

\item{max_speed}{Maximum speed (in km/h) to be considered as valid. Values
above maximum speed will be adjusted. Defaults to 80 km/h.}

\item{new_speed}{Speed (in km/h) to replace missing values as well as values
outside min_speed and max_speed range. By default, `new_speed = NULL` and the
function considers the average speed of the entire gps data.}

\item{clone}{Use a copy of the gps_data? Defaults to TRUE.}
}
\value{
A GPS-like data with adjusted `speed` values. The columns
`timestamp` and `cumtime` are also updated accordingly.
}
\description{
Some GTFS.zip data sets might have quality issues, for example 
by assuming that a trip speed is unreasonably high (e.g. an urban bus running
over 100 Km/h), or in other cases the `timestamp` information might be
missing for some route segments. This can lead a gps-like table to have `NA`
or unrealistic `speed` and `timestamp` values. This function allows the
user to adjust the speed of trips and updates `timestamp` values 
accordingly. The user can adjust the problematic speeds by either setting a
custom constant value, or by considering the average of all valid trips speed
(Default). The columns `timestamp` and `cumtime` are updated accordingly.
}
\examples{
library(dplyr)
poa <- read_gtfs(system.file("extdata/poa.zip", package="gtfs2gps")) \%>\%
  filter_week_days() \%>\%
  filter_single_trip()

poa_gps <- gtfs2gps(poa)
poa_gps_new <- adjust_speed(poa_gps)
}
