% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_fields_types}
\alias{check_fields_types}
\alias{assert_fields_types}
\title{Check the types of fields in a GTFS object element}
\usage{
check_fields_types(x, file, fields, types)

assert_fields_types(x, file, fields, types)
}
\arguments{
\item{x}{A GTFS object.}

\item{file}{A string. The element, that represents a GTFS text file, whose
fields' types should be checked.}

\item{fields}{A character vector. The fields to have their types checked.}

\item{types}{A character vector, with the same length of \code{fields}. The
types that each field must inherit from.}
}
\value{
\code{check_fields_types} returns \code{TRUE} if the check is successful, and
  \code{FALSE} otherwise. \cr
\code{assert_fields_types} returns \code{x} invisibly if the check is
  successful, and throws an error otherwise.
}
\description{
Checks the types of fields, represented by columns, inside a GTFS object
element.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

check_fields_types(
  gtfs,
  "calendar",
  fields = c("monday", "tuesday"),
  types = rep("integer", 2)
)

check_fields_types(
  gtfs,
  "calendar",
  fields = c("monday", "tuesday"),
  types = c("integer", "character")
)

}
\seealso{
Other checking functions: 
\code{\link{check_fields_exist}()},
\code{\link{check_files_exist}()}
}
\concept{checking functions}
