% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ae_count.R
\name{tbl_ae_count}
\alias{tbl_ae_count}
\title{Tabulate Raw AE Counts}
\usage{
tbl_ae_count(
  data,
  ae,
  soc = NULL,
  by = NULL,
  strata = NULL,
  by_values = NULL,
  digits = NULL,
  sort = NULL,
  zero_symbol = "—",
  missing_location = c("first", "last", "hide")
)
}
\arguments{
\item{data}{Data frame}

\item{ae}{Variable name of the adverse event column}

\item{soc}{Variable name of the system organ class column}

\item{by}{Variable to split results by, e.g. report AEs by grade}

\item{strata}{Variable to stratify results by, e.g. report AEs summaries
by treatment group}

\item{by_values}{Optional vector of complete by values, listed in desired order,
to achieve correct table structure for the situation in which an adverse
event of a certain grade is not observed for a given soc}

\item{digits}{Specifies the number of decimal places to round the summary statistics.
By default integers are shown to zero decimal places, and percentages are
formatted with \code{style_percent()}. If you would like to modify either
of these, pass a vector of integers indicating the number of decimal
places to round the statistics. For example, if the statistic being
calculated is \code{"{n} ({p}\%)"} and you want the percent rounded to
2 decimal places use \code{digits = c(0, 2)}.
User may also pass a styling function: \code{digits = style_sigfig}}

\item{sort}{Controls order of AEs and SOCs in output table.
The default is \code{NULL}, where AEs and SOCs are sorted alphanumerically
(and factors sorted according to their factor level).
Use \code{sort = "ae"} to sort AEs in decreasing frequency order, \code{sort = "soc"}
to sort SOCs in decreasing order, and \code{sort = c("ae", "soc")} to sort both.
AEs are sorted within SOC.}

\item{zero_symbol}{String used to represent cells with zero counts. Default
is the em-dash (\code{"\\U2014"}). Using \code{zero_symbol = NULL} will print the
zero count statistics, e.g. \code{"0 (0)"}}

\item{missing_location}{location where the column summarizing values with
missing levels \verb{by=} will be located in the final table. Must be
one of \verb{c("first", "last", "hide)}. Default is \code{"first"}}
}
\value{
a 'tbl_ae_count' object
}
\description{
Create a table counting all AEs.
}
\details{
\code{tbl_ae_count} counts all AEs (whereas \code{\link{tbl_ae}}
counts by maximum grade). Thus, \code{tbl_ae_count} does
not provide percentages as multiple AEs can be counted per subject.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_ae_count_ex1.png}{options: width=90\%}}
}

\examples{
\donttest{
# Example 1 -----------------------------------------------------------------
tbl_ae_count_ex1 <-
  tbl_ae_count(
    data = df_adverse_events,
    ae = adverse_event,
    soc = system_organ_class,
    strata = trt,
    by = grade
  ) \%>\%
  modify_header(all_ae_cols() ~ "**Grade {by}**")
  }
}
\seealso{
\code{\link{tbl_ae}}
}
