% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_q.R
\name{add_q.tbl_summary}
\alias{add_q.tbl_summary}
\title{Add a column of q-values to account for multiple comparisons}
\usage{
\method{add_q}{tbl_summary}(x, method = "fdr",
  pvalue_fun = x$pvalue_fun, ...)
}
\arguments{
\item{x}{\code{tbl_summary} object}

\item{method}{String indicating method to be used for p-value
adjustment. Methods from
\link[stats:p.adjust]{stats::p.adjust} are accepted.  Default is \code{method = 'fdr'}.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{...}{Additional arguments passed to or from other methods}
}
\value{
A \code{tbl_summary} object
}
\description{
Adjustments to are p-values are performed with \link[stats:p.adjust]{stats::p.adjust}.
}
\section{Example Output}{

\if{html}{\figure{tbl_sum_q_ex.png}{options: width=50\%}}
}

\examples{
tbl_sum_q_ex <-
  trial \%>\%
  dplyr::select(trt, age, grade, response) \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  add_q()
}
\seealso{
Other tbl_summary tools: \code{\link{add_n}},
  \code{\link{add_overall}}, \code{\link{add_p}},
  \code{\link{add_stat_label}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_summary}},
  \code{\link{inline_text.tbl_summary}},
  \code{\link{modify_header}},
  \code{\link{sort_p.tbl_summary}},
  \code{\link{tbl_merge}}, \code{\link{tbl_stack}},
  \code{\link{tbl_summary}}
}
\author{
Esther Drill, Daniel D. Sjoberg
}
\concept{tbl_summary tools}
