% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_p.R
\name{bold_p.tbl_uvregression}
\alias{bold_p.tbl_uvregression}
\title{Bold significant p-values or q-values}
\usage{
\method{bold_p}{tbl_uvregression}(x, t = 0.05, q = FALSE, ...)
}
\arguments{
\item{x}{Object created using \link{tbl_uvregression} function}

\item{t}{Threshold below which values will be bold. Default is 0.05.}

\item{q}{Logical argument. When TRUE will bold the q-value column rather
than the p-values. Default is \code{FALSE}.}

\item{...}{Not used}
}
\value{
A \code{tbl_uvregression} object
}
\description{
Bold values below a chosen threshold (e.g. <0.05)
in \link{tbl_uvregression} tables.
}
\section{Example Output}{

\if{html}{\figure{tbl_uvglm_bold_p_ex.png}{options: width=50\%}}
}

\examples{
tbl_uvglm_bold_p_ex <-
  trial \%>\%
  dplyr::select(age, marker, response, grade) \%>\%
  tbl_uvregression(
    method = glm,
    y = response,
    method.args = list(family = binomial),
    exponentiate = TRUE
  ) \%>\%
  bold_p(t = 0.25)
}
\seealso{
Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q.tbl_uvregression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_stack}()},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_uvregression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\author{
Daniel D. Sjoberg, Esther Drill
}
\concept{tbl_uvregression tools}
