% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_summary.R
\name{tbl_summary_}
\alias{tbl_summary_}
\title{Standard evaluation version of tbl_summary()}
\usage{
tbl_summary_(
  data,
  by = NULL,
  label = NULL,
  statistic = NULL,
  digits = NULL,
  type = NULL,
  value = NULL,
  missing = c("ifany", "always", "no"),
  missing_text = "Unknown",
  sort = NULL,
  percent = c("column", "row", "cell"),
  group = NULL
)
}
\arguments{
\item{data}{A data frame}

\item{by}{A column name in data.
Summary statistics will be calculated separately for each level of the \code{by}
variable (e.g. \code{by = trt}). If \code{NULL}, summary statistics
are calculated using all observations.}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list(vars(age) ~ "Age, yrs", vars(ptstage) ~ "Path T Stage")}.  If a
variable's label is not specified here, the
function will take the label attribute (\code{attr(data$age, "label")}).  If
attribute label is \code{NULL}, the variable name will be used.}

\item{statistic}{List of formulas specifying types of summary statistics to
display for each variable.  The default is
\code{list(all_continuous() ~ "{median} ({p25}, {p75})", all_categorical() ~ "{n} ({p}\%)")}.
See below for details.}

\item{digits}{List of formulas specifying the number of decimal
places to round continuous summary statistics. If not specified,
\code{tbl_summary} guesses an appropriate number of decimals to round statistics.
When multiple statistics are displayed for a single variable, supply a vector
rather than an integer.  For example, if the
statistic being calculated is \code{"{mean} ({sd})"} and you want the mean rounded
to 1 decimal place, and the SD to 2 use \code{digits = list("age" ~ c(1, 2))}.}

\item{type}{List of formulas specifying variable types. Accepted values
are \code{c("continuous", "categorical", "dichotomous")},
e.g. \code{type = list(starts_with(age) ~ "continuous", "female" ~ "dichotomous")}.
If type not specified for a variable, the function
will default to an appropriate summary type.  See below for details.}

\item{value}{List of formulas specifying the value to display for dichotomous
variables.  See below for details.}

\item{missing}{Indicates whether to include counts of \code{NA} values in the table.
Allowed values are \code{"no"} (never display NA values),
\code{"ifany"} (only display if any NA values), and \code{"always"}
(includes NA count row for all variables). Default is \code{"ifany"}.}

\item{missing_text}{String to display for count of missing observations.
Default is \code{"Unknown"}.}

\item{sort}{List of formulas specifying the type of sorting to perform for
categorical data. Options are \code{frequency} where results are sorted in
descending order of frequency and \code{alphanumeric},
e.g. \code{sort = list(everything() ~ "frequency")}}

\item{percent}{Indicates the type of percentage to return. Must be one of
\code{"column"}, \code{"row"}, or \code{"cell"}. Default is \code{"column"}.}

\item{group}{DEPRECATED. Migrated to \link{add_p}}
}
\description{
The \code{'by ='} argument can be passed as a string, rather than with non-standard
evaluation as in \link{tbl_summary}. Review the help file for \link{tbl_summary} fully
documented options and arguments.
}
