% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flex_table.R
\name{as_flex_table}
\alias{as_flex_table}
\title{Convert gtsummary object to a flextable object}
\usage{
as_flex_table(
  x,
  include = everything(),
  return_calls = FALSE,
  strip_md_bold = TRUE
)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{strip_md_bold}{When TRUE, all double asterisk (markdown language for
bold weight) in column labels and spanning headers are removed.
Default is TRUE}
}
\value{
A {flextable} object
}
\description{
Function converts a gtsummary object to a flextable object.
A user can use this function if they wish to add customized formatting
available via the flextable functions. The flextable output is particularly
useful when combined with R markdown with Word output, since the gt package
does not support Word.
}
\section{Details}{

The \code{as_flex_table()} functions converts the gtsummary object to a flextable,
and prints it with the following styling functions.
\enumerate{
\item \code{\link[flextable:flextable]{flextable::flextable()}}
\item \code{\link[flextable:set_header_labels]{flextable::set_header_labels()}} to set column labels
\item \code{\link[flextable:add_header_row]{flextable::add_header_row()}}, if applicable, to set spanning column header
\item \code{\link[flextable:align]{flextable::align()}} to set column alignment
\item \code{\link[flextable:padding]{flextable::padding()}} to indent variable levels
\item \code{\link[flextable:fontsize]{flextable::fontsize()}} to set font size
\item \code{\link[flextable:autofit]{flextable::autofit()}} to estimate the column widths
\item \code{\link[flextable:footnote]{flextable::footnote()}} to add table footnotes and source notes
\item \code{\link[flextable:bold]{flextable::bold()}} to bold cells in data frame
\item \code{\link[flextable:italic]{flextable::italic()}} to italicize cells in data frame
\item \code{\link[flextable:border]{flextable::border()}} to set all border widths to 1
\item \code{\link[flextable:padding]{flextable::padding()}} to set consistent header padding
\item \code{\link[flextable:valign]{flextable::valign()}} to ensure label column is top-left justified
}

Any one of these commands may be omitted using the \verb{include=} argument.

Pro tip: Use the \code{\link[flextable:width]{flextable::width()}} function for exacting control over
column width after calling \code{\link[=as_flex_table]{as_flex_table()}}.
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{as_flex_table_ex1.png}{options: width=60\%}}
}

\examples{
as_flex_table_ex1 <-
  trial \%>\%
  select(trt, age, grade) \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  as_flex_table()
}
\seealso{
Other gtsummary output types: 
\code{\link{as_gt}()},
\code{\link{as_hux_table}()},
\code{\link{as_kable_extra}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{gtsummary output types}
