% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_uvregression.R
\name{tbl_uvregression}
\alias{tbl_uvregression}
\title{Display univariate regression model results in table}
\usage{
tbl_uvregression(
  data,
  method,
  y = NULL,
  x = NULL,
  method.args = NULL,
  exponentiate = FALSE,
  label = NULL,
  include = everything(),
  tidy_fun = NULL,
  hide_n = FALSE,
  show_single_row = NULL,
  conf.level = NULL,
  estimate_fun = NULL,
  pvalue_fun = NULL,
  formula = "{y} ~ {x}",
  show_yesno = NULL,
  exclude = NULL
)
}
\arguments{
\item{data}{Data frame to be used in univariate regression modeling.  Data
frame includes the outcome variable(s) and the independent variables.}

\item{method}{Regression method (e.g. \link{lm}, \link{glm}, \link[survival:coxph]{survival::coxph}, and more).}

\item{y}{Model outcome (e.g. \code{y = recurrence} or \code{y = Surv(time, recur)}).
All other column in \code{data} will be regressed on \code{y}.
Specify one and only one of \code{y} or \code{x}}

\item{x}{Model covariate (e.g. \code{x = trt}).
All other columns in \code{data} will serve as the outcome in a regression model
with \code{x} as a covariate.  Output table is best when \code{x} is a continuous or
dichotomous variable displayed on a single row.
Specify one and only one of \code{y} or \code{x}}

\item{method.args}{List of additional arguments passed on to the regression
function defined by \code{method}.}

\item{exponentiate}{Logical indicating whether to exponentiate the
coefficient estimates. Default is \code{FALSE}.}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list(age ~ "Age", stage ~ "Path T Stage")}}

\item{include}{Variables to include in output. Input may be a vector of
quoted variable names, unquoted variable names, or tidyselect select helper
functions. Default is \code{everything()}.}

\item{tidy_fun}{Option to specify a particular tidier function if the
model is not a \link[=vetted_models]{vetted model} or you need to implement a
custom method. Default is \code{NULL}}

\item{hide_n}{Hide N column. Default is \code{FALSE}}

\item{show_single_row}{By default categorical variables are printed on
multiple rows.  If a variable is dichotomous (e.g. Yes/No) and you wish to print
the regression coefficient on a single row, include the variable name(s)
here--quoted and unquoted variable name accepted.}

\item{conf.level}{Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{estimate_fun}{Function to round and format coefficient estimates.
Default is \link{style_sigfig} when the coefficients are not transformed, and
\link{style_ratio} when the coefficients have been exponentiated.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{formula}{String of the model formula.
Uses \link[glue:glue]{glue::glue} syntax. Default is \code{"{y} ~ {x}"}, where \code{{y}}
is the dependent variable, and \code{{x}} represents a single covariate. For a
random intercept model, the formula may be \code{formula = "{y} ~ {x} + (1 | gear)"}.}

\item{show_yesno}{DEPRECATED}

\item{exclude}{DEPRECATED}
}
\value{
A \code{tbl_uvregression} object
}
\description{
This function estimates univariate regression models and returns them in
a publication-ready table.  It can create univariate regression models holding
either a covariate or outcome constant.

For models holding outcome constant, the function takes as arguments a data frame,
the type of regression model, and the outcome variable \verb{y=}. Each column in the
data frame is regressed on the specified outcome. The \code{tbl_uvregression}
function arguments are similar to the \link{tbl_regression} arguments. Review the
\href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#tbl_uvregression}{tbl_uvregression vignette}
for detailed examples.

You may alternatively hold a single covariate constant. For this, pass a data
frame, the type of regression model, and a single
covariate in the \verb{x=} argument. Each column of the data frame will serve as
the outcome in a univariate regression model. Take care using the \code{x} argument
that each of the columns in the data frame are appropriate for the same type
of model, e.g. they are all continuous variables appropriate for \link{lm}, or
dichotomous variables appropriate for logistic regression with \link{glm}.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_uv_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_uv_ex2.png}{options: width=50\%}}
}

\section{Setting Defaults}{

If you prefer to consistently use a different function to format p-values or
estimates, you can set options in the script or in the user- or
project-level startup file, '.Rprofile'.  The default confidence level can
also be set.
\itemize{
\item \code{options(gtsummary.pvalue_fun = new_function)}
\item \code{options(gtsummary.tbl_regression.estimate_fun = new_function)}
\item \code{options(gtsummary.conf.level = 0.90)}
}
}

\section{Note}{

The N reported in the output is the number of observations
in the data frame \code{model.frame(x)}. Depending on the model input, this N
may represent different quantities. In most cases, it is the number of people or
units in your model.  Here are some common exceptions.
\enumerate{
\item Survival regression models including time dependent covariates.
\item Random- or mixed-effects regression models with clustered data.
\item GEE regression models with clustered data.
}

This list is not exhaustive, and care should be taken for each number reported.
}

\examples{
# Example 1 ----------------------------------
tbl_uv_ex1 <-
  tbl_uvregression(
    trial[c("response", "age", "grade")],
    method = glm,
    y = response,
    method.args = list(family = binomial),
    exponentiate = TRUE
  )

# Example 2 ----------------------------------
# rounding pvalues to 2 decimal places
library(survival)
tbl_uv_ex2 <-
  tbl_uvregression(
    trial[c("ttdeath", "death", "age", "grade", "response")],
    method = coxph,
    y = Surv(ttdeath, death),
    exponentiate = TRUE,
    pvalue_fun = function(x) style_pvalue(x, digits = 2)
  )
}
\seealso{
See tbl_regression \href{http://www.danieldsjoberg.com/gtsummary/articles/tbl_regression.html#tbl_uvregression}{vignette}  for detailed examples

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_uvregression tools}
