% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.R
\name{add_p.tbl_cross}
\alias{add_p.tbl_cross}
\title{Adds p-value to crosstab table}
\usage{
\method{add_p}{tbl_cross}(x, test = NULL, pvalue_fun = NULL, source_note = NULL, ...)
}
\arguments{
\item{x}{Object with class \code{tbl_cross} from the \link{tbl_cross} function}

\item{test}{A string specifying statistical test to perform. Default is
"\code{chisq.test}" when expected cell counts >=5 and "\code{fisher.test}" when
expected cell counts <5.}

\item{pvalue_fun}{Function to round and format p-value.
Default is \link{style_pvalue}, except when \code{source_note = TRUE} when the
default is \code{style_pvalue(x, prepend_p = TRUE)}}

\item{source_note}{Logical value indicating whether to show p-value
in the \{gt\} table source notes rather than a column.}

\item{...}{Not used}
}
\description{
Calculate and add a p-value comparing the two variables in the cross table.
Missing values are included in p-value calculations.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_p_cross_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{add_p_cross_ex2.png}{options: width=45\%}}
}

\examples{
# Example 1 ----------------------------------
add_p_cross_ex1 <-
  trial \%>\%
  tbl_cross(row = stage, col = trt) \%>\%
  add_p()

# Example 2 ----------------------------------
add_p_cross_ex2 <-
  trial \%>\%
  tbl_cross(row = stage, col = trt) \%>\%
  add_p(source_note = TRUE)

}
\seealso{
Other tbl_cross tools: 
\code{\link{inline_text.tbl_cross}()},
\code{\link{tbl_cross}()}
}
\author{
Karissa Whiting
}
\concept{tbl_cross tools}
