% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_overall.R, R/tbl_custom_summary.R
\name{add_overall}
\alias{add_overall}
\alias{add_overall.tbl_summary}
\alias{add_overall.tbl_svysummary}
\alias{add_overall.tbl_custom_summary}
\title{Add column with overall summary statistics}
\usage{
add_overall(x, last, col_label)

\method{add_overall}{tbl_summary}(x, last = FALSE, col_label = NULL)

\method{add_overall}{tbl_svysummary}(x, last = FALSE, col_label = NULL)

\method{add_overall}{tbl_custom_summary}(x, last = FALSE, col_label = NULL)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function or
object with class \code{tbl_svysummary} from the \link{tbl_svysummary} function.}

\item{last}{Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}

\item{col_label}{String indicating the column label. Default is \code{"**Overall**,  N = {N}"}}
}
\value{
A \code{tbl_summary} object or a \code{tbl_svysummary} object
}
\description{
Adds a column with overall summary statistics to tables
created by \code{tbl_summary} or \code{tbl_svysummary}.
}
\section{Example Output}{

\if{html}{\figure{tbl_overall_ex.png}{options: width=50\%}}
}

\examples{
tbl_overall_ex <-
  trial[c("age", "grade", "trt")] \%>\%
  tbl_summary(by = trt) \%>\%
  add_overall()
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_ci}()},
\code{\link{add_n.tbl_summary}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify}},
\code{\link{separate_p_footnotes}()},
\code{\link{tbl_custom_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_summary}()}

Other tbl_svysummary tools: 
\code{\link{add_n.tbl_summary}()},
\code{\link{add_p.tbl_svysummary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{modify}},
\code{\link{separate_p_footnotes}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_svysummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_summary tools}
\concept{tbl_svysummary tools}
