% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_gtsummary.R
\name{theme_gtsummary}
\alias{theme_gtsummary}
\alias{theme_gtsummary_journal}
\alias{theme_gtsummary_compact}
\alias{theme_gtsummary_printer}
\alias{theme_gtsummary_language}
\alias{theme_gtsummary_continuous2}
\alias{theme_gtsummary_mean_sd}
\alias{theme_gtsummary_eda}
\title{Available gtsummary themes}
\usage{
theme_gtsummary_journal(
  journal = c("jama", "lancet", "nejm", "qjecon"),
  set_theme = TRUE
)

theme_gtsummary_compact(set_theme = TRUE, font_size = NULL)

theme_gtsummary_printer(
  print_engine = c("gt", "kable", "kable_extra", "flextable", "huxtable", "tibble"),
  set_theme = TRUE
)

theme_gtsummary_language(
  language = c("de", "en", "es", "fr", "gu", "hi", "is", "ja", "kr", "mr", "nl", "no",
    "pt", "se", "zh-cn", "zh-tw"),
  decimal.mark = NULL,
  big.mark = NULL,
  iqr.sep = NULL,
  ci.sep = NULL,
  set_theme = TRUE
)

theme_gtsummary_continuous2(
  statistic = "{median} ({p25, {p75})",
  set_theme = TRUE
)

theme_gtsummary_mean_sd(set_theme = TRUE)

theme_gtsummary_eda(set_theme = TRUE)
}
\arguments{
\item{journal}{String indicating the journal theme to follow. One of
\code{c("jama", "lancet", "nejm", "qjecon")}. Details below.}

\item{set_theme}{Logical indicating whether to set the theme. Default is \code{TRUE}.
When \code{FALSE} the named list of theme elements is returned invisibly}

\item{font_size}{Numeric font size for compact theme.
Default is 13 for gt tables, and 8 for all other output types}

\item{print_engine}{String indicating the print method. Must be one of
\code{"gt"}, \code{"kable"}, \code{"kable_extra"}, \code{"flextable"}, \code{"tibble"}}

\item{language}{String indicating language. Must be one of \code{"de"} (German),
\code{"en"} (English), \code{"es"} (Spanish), \code{"fr"} (French), \code{"gu"} (Gujarati),
\code{"hi"} (Hindi), \code{"is"} (Icelandic),\code{"ja"} (Japanese), \code{"kr"} (Korean),
\code{"nl"} (Dutch), \code{"mr"} (Marathi), \code{"no"} (Norwegian), \code{"pt"} (Portuguese),
\code{"se"} (Swedish), \code{"zh-c,n"} (Chinese Simplified), \code{"zh-tw"} (Chinese Traditional)

If a language is missing a translation for a word or phrase, please feel free
to reach out on \href{https://github.com/ddsjoberg/gtsummary/issues}{GitHub}
with the translated text!}

\item{decimal.mark}{The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{big.mark}{Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{iqr.sep}{string indicating separator for the default IQR in \code{tbl_summary()}.
If \verb{decimal.mark=} is NULL, \verb{iqr.sep=} is \code{", "}. The comma
separator, however, can look odd when \code{decimal.mark = ","}. In this case the argument
will default to an en dash}

\item{ci.sep}{string indicating separator for confidence intervals.
If \verb{decimal.mark=} is NULL, \verb{ci.sep=} is \code{", "}. The comma
separator, however, can look odd when \code{decimal.mark = ","}. In this case the argument
will default to an en dash}

\item{statistic}{Default statistic continuous variables}
}
\description{
\lifecycle{maturing}
The following themes are available to use within the gtsummary package.
Print theme elements with \code{theme_gtsummary_journal(set_theme = FALSE) \%>\% print()}.
Review the \href{https://www.danieldsjoberg.com/gtsummary/articles/themes.html}{themes vignette}
for details.
}
\section{Themes}{

\itemize{
\item \code{theme_gtsummary_journal(journal=)}
\itemize{
\item \code{"jama"} \emph{The Journal of the American Medical Association}
\itemize{
\item Round large p-values to 2 decimal places; separate confidence intervals with \code{"ll to ul"}.
\item \code{tbl_summary()} Doesn't show percent symbol; use em-dash to separate IQR; run \code{add_stat_label()}
\item \code{tbl_regression()}/\code{tbl_uvregression()} show coefficient and CI in same column
}
\item \code{"lancet"} \emph{The Lancet}
\itemize{
\item Use mid-point as decimal separator; round large p-values to 2 decimal places; separate confidence intervals with \code{"ll to ul"}.
\item \code{tbl_summary()} Doesn't show percent symbol; use em-dash to separate IQR
}
\item \code{"nejm"} \emph{The New England Journal of Medicine}
\itemize{
\item Round large p-values to 2 decimal places; separate confidence intervals with \code{"ll to ul"}.
\item \code{tbl_summary()} Doesn't show percent symbol; use em-dash to separate IQR
}
\item \code{"qjecon"} \emph{The Quarterly Journal of Economics} \emph{\strong{Under Development}}
\itemize{
\item \code{tbl_summary()} all percentages rounded to one decimal place
\item \code{tbl_regression()}/\code{tbl_uvregression()} add significance stars with \code{add_significance_stars()}; hides CI and p-value from output
}
}
\item \code{theme_gtsummary_compact()}
\itemize{
\item tables printed with gt, flextable, kableExtra, or huxtable will be compact with smaller font size and reduced cell padding
}
\item \code{theme_gtsummary_printer(print_engine=)}
\itemize{
\item Use this theme to permanently change the default printer.
}
\item \code{theme_gtsummary_continuous2()}
\itemize{
\item Set all continuous variables to summary type \code{"continuous2"} by default
}
\item \code{theme_gtsummary_mean_sd()}
\itemize{
\item Set default summary statistics to mean and standard deviation in \code{tbl_summary()}
\item Set default continuous tests in \code{add_p()} to t-test and ANOVA
}
\item \code{theme_gtsummary_eda()}
\itemize{
\item Set all continuous variables to summary type \code{"continuous2"} by default
\item In \code{tbl_summary()} show the median, mean, IQR, SD, and Range by default
}
}

Use \code{reset_gtsummary_theme()} to restore the default settings

Review the \href{https://www.danieldsjoberg.com/gtsummary/articles/themes.html}{themes vignette}
to create your own themes.
}

\section{Example Output}{

\if{html}{Example}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/set_gtsummary_theme_ex1.png" alt="image of rendered example table" style="width:60\%;">
}}
}

\examples{
\donttest{
# Setting JAMA theme for gtsummary
theme_gtsummary_journal("jama")
# Themes can be combined by including more than one
theme_gtsummary_compact()

set_gtsummary_theme_ex1 <-
  trial \%>\%
  select(age, grade, trt) \%>\%
  tbl_summary(by = trt) \%>\%
  as_gt()

# reset gtsummary themes
reset_gtsummary_theme()
}
}
\seealso{
\href{https://www.danieldsjoberg.com/gtsummary/articles/themes.html}{Themes vignette}

\code{\link[=set_gtsummary_theme]{set_gtsummary_theme()}}, \code{\link[=reset_gtsummary_theme]{reset_gtsummary_theme()}}
}
