# tbl_cross- works if no `col` or `row` specified

    Code
      tbl_cross(trial, col = trt, row = response) %>% as.data.frame()
    Output
                       Drug A Drug B Total
      1 Tumor Response   <NA>   <NA>  <NA>
      2              0     67     65   132
      3              1     28     33    61
      4        Unknown      3      4     7
      5          Total     98    102   200

# tbl_cross- works in character inputs for `col` and `row

    Code
      tbl_cross(trial, col = all_of(col_variable), row = all_of(row_variable)) %>%
        as.data.frame()
    Output
                       Drug A Drug B Total
      1 Tumor Response   <NA>   <NA>  <NA>
      2              0     67     65   132
      3              1     28     33    61
      4        Unknown      3      4     7
      5          Total     98    102   200

# tbl_cross- creates output without error with continuous args

    Code
      tbl_cross(mtcars, row = gear, col = am) %>% as.data.frame()
    Output
                 0    1 Total
      1  gear <NA> <NA>  <NA>
      2     3   15    0    15
      3     4    4    8    12
      4     5    0    5     5
      5 Total   19   13    32

# tbl_cross- labels work

    Code
      tbl_cross(mtcars, row = am, col = cyl, label = list(am = "AM LABEL", cyl = "New cyl")) %>%
        as.data.frame()
    Output
                    4    6    8 Total
      1 AM LABEL <NA> <NA> <NA>  <NA>
      2        0    3    4   12    19
      3        1    8    3    2    13
      4    Total   11    7   14    32

---

    Code
      tbl_cross(mtcars, row = am, col = cyl, label = vars(am) ~ "AM LABEL") %>%
        as.data.frame()
    Message
      ! Use of `vars()` is now deprecated and support will soon be removed. Please replace calls to `vars()` with `c()`.
    Output
                    4    6    8 Total
      1 AM LABEL <NA> <NA> <NA>  <NA>
      2        0    3    4   12    19
      3        1    8    3    2    13
      4    Total   11    7   14    32

# tbl_cross- statistics argument works

    Code
      tbl_cross(trial, statistic = "{p}") %>% as.data.frame()
    Output
                                  6    9   10   17   19   20   21   23   25   26   27
      1 Chemotherapy Treatment <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA>
      2                 Drug A  0.5    0    0  0.5  0.5  0.5  0.5  0.5    0    0  0.5
      3                 Drug B    0  0.5  0.5    0  0.5    0  0.5    0  1.0  1.0    0
      4                  Total  0.5  0.5  0.5  0.5  1.0  0.5  1.0  0.5  1.0  1.0  0.5
          28   30   31   32   33   34   35   36   37   38   39   40   41   42   43
      1 <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA>
      2    0  0.5  2.5  0.5  0.5  1.5  0.5  1.5  1.5  2.0  1.0  0.5  1.0  1.0  1.0
      3  1.0    0  1.0  0.5  0.5  1.5  0.5  1.0  0.5  1.5  1.5  0.5  0.5  1.0  2.5
      4  1.0  0.5  3.5  1.0  1.0  3.0  1.0  2.5  2.0  3.5  2.5  1.0  1.5  2.0  3.5
          44   45   46   47   48   49   50   51   52   53   54   55   56   57   58
      1 <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA>
      2  1.0  1.5  1.5  1.5  1.5    0  1.0  2.0  1.0  0.5  1.0  0.5  0.5  0.5  1.0
      3  2.0  1.5    0  2.0  2.0  3.0  1.0  1.0  1.0  2.5  1.5  0.5  1.0  2.0  0.5
      4  3.0  3.0  1.5  3.5  3.5  3.0  2.0  3.0  2.0  3.0  2.5  1.0  1.5  2.5  1.5
          59   60   61   62   63   64   65   66   67   68   69   70   71   74   75
      1 <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA> <NA>
      2    0  1.5  2.0  0.5  1.0  0.5  0.5  1.0  1.0  0.5  0.5    0  0.5  0.5  0.5
      3  0.5  0.5  0.5    0  1.0    0  1.0  1.0  1.0  1.0  0.5  0.5  1.0    0    0
      4  0.5  2.0  2.5  0.5  2.0  0.5  1.5  2.0  2.0  1.5  1.0  0.5  1.5  0.5  0.5
          76   78   83 Unknown Total
      1 <NA> <NA> <NA>    <NA>  <NA>
      2  0.5  0.5    0     3.5    49
      3  0.5    0  0.5     2.0    51
      4  1.0  0.5  0.5     5.5   100

---

    Code
      tbl_cross(trial, percent = "cell") %>% as.data.frame()
    Output
                                      6        9       10       17       19       20
      1 Chemotherapy Treatment     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2                 Drug A 1 (0.5%)   0 (0%)   0 (0%) 1 (0.5%) 1 (0.5%) 1 (0.5%)
      3                 Drug B   0 (0%) 1 (0.5%) 1 (0.5%)   0 (0%) 1 (0.5%)   0 (0%)
      4                  Total 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%)
              21       23       25       26       27       28       30       31
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%)   0 (0%)   0 (0%) 1 (0.5%)   0 (0%) 1 (0.5%) 5 (2.5%)
      3 1 (0.5%)   0 (0%) 2 (1.0%) 2 (1.0%)   0 (0%) 2 (1.0%)   0 (0%) 2 (1.0%)
      4 2 (1.0%) 1 (0.5%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 7 (3.5%)
              32       33       34       35       36       37       38       39
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 3 (1.5%) 1 (0.5%) 3 (1.5%) 3 (1.5%) 4 (2.0%) 2 (1.0%)
      3 1 (0.5%) 1 (0.5%) 3 (1.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 3 (1.5%) 3 (1.5%)
      4 2 (1.0%) 2 (1.0%) 6 (3.0%) 2 (1.0%) 5 (2.5%) 4 (2.0%) 7 (3.5%) 5 (2.5%)
              40       41       42       43       44       45       46       47
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 3 (1.5%) 3 (1.5%) 3 (1.5%)
      3 1 (0.5%) 1 (0.5%) 2 (1.0%) 5 (2.5%) 4 (2.0%) 3 (1.5%)   0 (0%) 4 (2.0%)
      4 2 (1.0%) 3 (1.5%) 4 (2.0%) 7 (3.5%) 6 (3.0%) 6 (3.0%) 3 (1.5%) 7 (3.5%)
              48       49       50       51       52       53       54       55
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 3 (1.5%)   0 (0%) 2 (1.0%) 4 (2.0%) 2 (1.0%) 1 (0.5%) 2 (1.0%) 1 (0.5%)
      3 4 (2.0%) 6 (3.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 5 (2.5%) 3 (1.5%) 1 (0.5%)
      4 7 (3.5%) 6 (3.0%) 4 (2.0%) 6 (3.0%) 4 (2.0%) 6 (3.0%) 5 (2.5%) 2 (1.0%)
              56       57       58       59       60       61       62       63
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 2 (1.0%)   0 (0%) 3 (1.5%) 4 (2.0%) 1 (0.5%) 2 (1.0%)
      3 2 (1.0%) 4 (2.0%) 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%)   0 (0%) 2 (1.0%)
      4 3 (1.5%) 5 (2.5%) 3 (1.5%) 1 (0.5%) 4 (2.0%) 5 (2.5%) 1 (0.5%) 4 (2.0%)
              64       65       66       67       68       69       70       71
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 1 (0.5%)   0 (0%) 1 (0.5%)
      3   0 (0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 1 (0.5%) 2 (1.0%)
      4 1 (0.5%) 3 (1.5%) 4 (2.0%) 4 (2.0%) 3 (1.5%) 2 (1.0%) 1 (0.5%) 3 (1.5%)
              74       75       76       78       83   Unknown      Total
      1     <NA>     <NA>     <NA>     <NA>     <NA>      <NA>       <NA>
      2 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%)   0 (0%)  7 (3.5%)   98 (49%)
      3   0 (0%)   0 (0%) 1 (0.5%)   0 (0%) 1 (0.5%)  4 (2.0%)  102 (51%)
      4 1 (0.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 1 (0.5%) 11 (5.5%) 200 (100%)

# tbl_cross- passing percent without stat works and produces %

    Code
      tbl_cross(trial, percent = "cell") %>% as.data.frame()
    Output
                                      6        9       10       17       19       20
      1 Chemotherapy Treatment     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2                 Drug A 1 (0.5%)   0 (0%)   0 (0%) 1 (0.5%) 1 (0.5%) 1 (0.5%)
      3                 Drug B   0 (0%) 1 (0.5%) 1 (0.5%)   0 (0%) 1 (0.5%)   0 (0%)
      4                  Total 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%)
              21       23       25       26       27       28       30       31
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%)   0 (0%)   0 (0%) 1 (0.5%)   0 (0%) 1 (0.5%) 5 (2.5%)
      3 1 (0.5%)   0 (0%) 2 (1.0%) 2 (1.0%)   0 (0%) 2 (1.0%)   0 (0%) 2 (1.0%)
      4 2 (1.0%) 1 (0.5%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 7 (3.5%)
              32       33       34       35       36       37       38       39
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 3 (1.5%) 1 (0.5%) 3 (1.5%) 3 (1.5%) 4 (2.0%) 2 (1.0%)
      3 1 (0.5%) 1 (0.5%) 3 (1.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 3 (1.5%) 3 (1.5%)
      4 2 (1.0%) 2 (1.0%) 6 (3.0%) 2 (1.0%) 5 (2.5%) 4 (2.0%) 7 (3.5%) 5 (2.5%)
              40       41       42       43       44       45       46       47
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 3 (1.5%) 3 (1.5%) 3 (1.5%)
      3 1 (0.5%) 1 (0.5%) 2 (1.0%) 5 (2.5%) 4 (2.0%) 3 (1.5%)   0 (0%) 4 (2.0%)
      4 2 (1.0%) 3 (1.5%) 4 (2.0%) 7 (3.5%) 6 (3.0%) 6 (3.0%) 3 (1.5%) 7 (3.5%)
              48       49       50       51       52       53       54       55
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 3 (1.5%)   0 (0%) 2 (1.0%) 4 (2.0%) 2 (1.0%) 1 (0.5%) 2 (1.0%) 1 (0.5%)
      3 4 (2.0%) 6 (3.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 5 (2.5%) 3 (1.5%) 1 (0.5%)
      4 7 (3.5%) 6 (3.0%) 4 (2.0%) 6 (3.0%) 4 (2.0%) 6 (3.0%) 5 (2.5%) 2 (1.0%)
              56       57       58       59       60       61       62       63
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 2 (1.0%)   0 (0%) 3 (1.5%) 4 (2.0%) 1 (0.5%) 2 (1.0%)
      3 2 (1.0%) 4 (2.0%) 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%)   0 (0%) 2 (1.0%)
      4 3 (1.5%) 5 (2.5%) 3 (1.5%) 1 (0.5%) 4 (2.0%) 5 (2.5%) 1 (0.5%) 4 (2.0%)
              64       65       66       67       68       69       70       71
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 1 (0.5%)   0 (0%) 1 (0.5%)
      3   0 (0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 1 (0.5%) 2 (1.0%)
      4 1 (0.5%) 3 (1.5%) 4 (2.0%) 4 (2.0%) 3 (1.5%) 2 (1.0%) 1 (0.5%) 3 (1.5%)
              74       75       76       78       83   Unknown      Total
      1     <NA>     <NA>     <NA>     <NA>     <NA>      <NA>       <NA>
      2 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%)   0 (0%)  7 (3.5%)   98 (49%)
      3   0 (0%)   0 (0%) 1 (0.5%)   0 (0%) 1 (0.5%)  4 (2.0%)  102 (51%)
      4 1 (0.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 1 (0.5%) 11 (5.5%) 200 (100%)

---

    Code
      x %>% as.data.frame()
    Output
                                      6        9       10       17       19       20
      1 Chemotherapy Treatment     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2                 Drug A 1 (0.5%)   0 (0%)   0 (0%) 1 (0.5%) 1 (0.5%) 1 (0.5%)
      3                 Drug B   0 (0%) 1 (0.5%) 1 (0.5%)   0 (0%) 1 (0.5%)   0 (0%)
      4                  Total 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%)
              21       23       25       26       27       28       30       31
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%)   0 (0%)   0 (0%) 1 (0.5%)   0 (0%) 1 (0.5%) 5 (2.5%)
      3 1 (0.5%)   0 (0%) 2 (1.0%) 2 (1.0%)   0 (0%) 2 (1.0%)   0 (0%) 2 (1.0%)
      4 2 (1.0%) 1 (0.5%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 7 (3.5%)
              32       33       34       35       36       37       38       39
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 3 (1.5%) 1 (0.5%) 3 (1.5%) 3 (1.5%) 4 (2.0%) 2 (1.0%)
      3 1 (0.5%) 1 (0.5%) 3 (1.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 3 (1.5%) 3 (1.5%)
      4 2 (1.0%) 2 (1.0%) 6 (3.0%) 2 (1.0%) 5 (2.5%) 4 (2.0%) 7 (3.5%) 5 (2.5%)
              40       41       42       43       44       45       46       47
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 3 (1.5%) 3 (1.5%) 3 (1.5%)
      3 1 (0.5%) 1 (0.5%) 2 (1.0%) 5 (2.5%) 4 (2.0%) 3 (1.5%)   0 (0%) 4 (2.0%)
      4 2 (1.0%) 3 (1.5%) 4 (2.0%) 7 (3.5%) 6 (3.0%) 6 (3.0%) 3 (1.5%) 7 (3.5%)
              48       49       50       51       52       53       54       55
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 3 (1.5%)   0 (0%) 2 (1.0%) 4 (2.0%) 2 (1.0%) 1 (0.5%) 2 (1.0%) 1 (0.5%)
      3 4 (2.0%) 6 (3.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 5 (2.5%) 3 (1.5%) 1 (0.5%)
      4 7 (3.5%) 6 (3.0%) 4 (2.0%) 6 (3.0%) 4 (2.0%) 6 (3.0%) 5 (2.5%) 2 (1.0%)
              56       57       58       59       60       61       62       63
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 2 (1.0%)   0 (0%) 3 (1.5%) 4 (2.0%) 1 (0.5%) 2 (1.0%)
      3 2 (1.0%) 4 (2.0%) 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%)   0 (0%) 2 (1.0%)
      4 3 (1.5%) 5 (2.5%) 3 (1.5%) 1 (0.5%) 4 (2.0%) 5 (2.5%) 1 (0.5%) 4 (2.0%)
              64       65       66       67       68       69       70       71
      1     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>     <NA>
      2 1 (0.5%) 1 (0.5%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 1 (0.5%)   0 (0%) 1 (0.5%)
      3   0 (0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 2 (1.0%) 1 (0.5%) 1 (0.5%) 2 (1.0%)
      4 1 (0.5%) 3 (1.5%) 4 (2.0%) 4 (2.0%) 3 (1.5%) 2 (1.0%) 1 (0.5%) 3 (1.5%)
              74       75       76       78       83   Unknown      Total
      1     <NA>     <NA>     <NA>     <NA>     <NA>      <NA>       <NA>
      2 1 (0.5%) 1 (0.5%) 1 (0.5%) 1 (0.5%)   0 (0%)  7 (3.5%)   98 (49%)
      3   0 (0%)   0 (0%) 1 (0.5%)   0 (0%) 1 (0.5%)  4 (2.0%)  102 (51%)
      4 1 (0.5%) 1 (0.5%) 2 (1.0%) 1 (0.5%) 1 (0.5%) 11 (5.5%) 200 (100%)

# tbl_cross- test no missing omits all NAs

    Code
      x %>% as.data.frame()
    Output
                                  0    1 Total
      1 Chemotherapy Treatment <NA> <NA>  <NA>
      2                 Drug A   67   28    95
      3                 Drug B   65   33    98
      4                  Total  132   61   193

# tbl_cross- test ifany missing returns Unknown when missing

    Code
      x %>% as.data.frame()
    Output
                       Drug A Drug B Total
      1 Tumor Response   <NA>   <NA>  <NA>
      2              0     67     65   132
      3              1     28     33    61
      4        Unknown      3      4     7
      5          Total     98    102   200

# tbl_cross- test 'always' missing returns Unknown even when none

    Code
      x %>% as.data.frame()
    Output
                                  I   II  III Unknown Total
      1 Chemotherapy Treatment <NA> <NA> <NA>    <NA>  <NA>
      2                 Drug A   35   32   31       0    98
      3                 Drug B   33   36   33       0   102
      4                Unknown    0    0    0       0     0
      5                  Total   68   68   64       0   200

# tbl_cross- works with grouped data (it ungroups it first)

    Code
      trial %>% dplyr::group_by(response) %>% tbl_cross(death, trt) %>% as.data.frame()
    Output
                     Drug A Drug B Total
      1 Patient Died   <NA>   <NA>  <NA>
      2            0     46     42    88
      3            1     52     60   112
      4        Total     98    102   200

# tbl_cross- test 'no' missing throws message

    Code
      table %>% as.data.frame()
    Output
                No  Yes Total
      1     X <NA> <NA>  <NA>
      2    No    2    1     3
      3   Yes    1    2     3
      4 Total    3    3     6

# tbl_cross- test NULL margin argument

    Code
      margins %>% as.data.frame()
    Output
                                  0    1 Unknown Total
      1 Chemotherapy Treatment <NA> <NA>    <NA>  <NA>
      2                 Drug A   67   28       3    98
      3                 Drug B   65   33       4   102
      4                  Total  132   61       7   200

---

    Code
      no_margins %>% as.data.frame()
    Output
                                  0    1 Unknown
      1 Chemotherapy Treatment <NA> <NA>    <NA>
      2                 Drug A   67   28       3
      3                 Drug B   65   33       4

