% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.tbl_svysummary.R
\name{add_p.tbl_svysummary}
\alias{add_p.tbl_svysummary}
\title{Add p-values}
\usage{
\method{add_p}{tbl_svysummary}(
  x,
  test = list(all_continuous() ~ "svy.wilcox.test", all_categorical() ~ "svy.chisq.test"),
  pvalue_fun = label_style_pvalue(digits = 1),
  include = everything(),
  test.args = NULL,
  ...
)
}
\arguments{
\item{x}{(\code{tbl_svysummary})\cr
table created with \code{tbl_svysummary()}}

\item{test}{(\code{\link[=syntax]{formula-list-selector}})\cr
List of formulas specifying statistical tests to perform.
Default is \code{list(all_continuous() ~ "svy.wilcox.test", all_categorical() ~ "svy.chisq.test")}.

See below for details on default tests and \link[=tests]{?tests} for details on available
tests and creating custom tests.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in output. Default is \code{everything()}.}

\item{test.args}{(\code{\link[=syntax]{formula-list-selector}})\cr
Containing additional arguments to pass to tests that accept arguments.
For example, add an argument for all t-tests, use
\code{test.args = all_tests("t.test") ~ list(var.equal = TRUE)}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table of class \code{"tbl_svysummary"}
}
\description{
Adds p-values to tables created by \code{\link[=tbl_svysummary]{tbl_svysummary()}} by comparing values across groups.
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed(c("cardx", "survey"), reference_pkg = "gtsummary") && gtsummary:::is_pkg_installed("broom", reference_pkg = "cardx")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# A simple weighted dataset
survey::svydesign(~1, data = as.data.frame(Titanic), weights = ~Freq) |>
  tbl_svysummary(by = Survived, include = c(Sex, Age)) |>
  add_p()

# A dataset with a complex design
data(api, package = "survey")
d_clust <- survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)

# Example 2 ----------------------------------
tbl_svysummary(d_clust, by = both, include = c(api00, api99)) |>
  add_p()

# Example 3 ----------------------------------
# change tests to svy t-test and Wald test
tbl_svysummary(d_clust, by = both, include = c(api00, api99, stype)) |>
  add_p(
    test = list(
      all_continuous() ~ "svy.t.test",
      all_categorical() ~ "svy.wald.test"
    )
  )
\dontshow{\}) # examplesIf}
}
