% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-variants.R
\name{variants_tbl}
\alias{variants_tbl}
\title{Creates a variants table.}
\usage{
variants_tbl(
  variant_id = character(),
  merged = integer(),
  functional_class = character(),
  chromosome_name = character(),
  chromosome_position = integer(),
  chromosome_region = character(),
  last_update_date = lubridate::ymd_hms()
)
}
\arguments{
\item{variant_id}{A character vector of variant identifiers.}

\item{merged}{A logical vector indicating if a SNP has been merged with
another SNP in a newer genome build.}

\item{functional_class}{A character vector of functional classes, see
\code{functional_class} in slot \code{variants} of \linkS4class{variants}.}

\item{chromosome_name}{A character vector of chromosome names.}

\item{chromosome_position}{An integer vector of chromosome positions.}

\item{chromosome_region}{A character vector of cytogenetic regions.}

\item{last_update_date}{A \code{\link[base:DateTimeClasses]{POSIXct}} object
indicating the last time the variants have been updated.}
}
\value{
A \code{\link[tibble]{tibble}} whose columns are the named arguments
to the function.
}
\description{
Creates a variants table.
}
\keyword{internal}
