% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{envelope}
\alias{envelope}
\title{Simulated Envelope of Residuals}
\usage{
envelope(object, B = 100, arg = arg, ...)
}
\arguments{
\item{object}{fit object for elliptical regression model.}

\item{B}{number of monte carlo simulations.}

\item{arg}{a numerical or vector representing the distribution parameters used.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\description{
This function produces quantile-quantile plots with simulated envelope for response distribution in elliptical regression models.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
envelope(elliptical.fitt, B=100, arg=5)
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{glm}}, \code{\link{elliptical}}, \code{\link{elliptical.diag}}
}
\keyword{elliptical}
\keyword{plots}
\keyword{quantile-quantile}
