% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gwer.R
\name{summary.gwer}
\alias{summary.gwer}
\alias{summary.gwer.print}
\title{Summarizing Geographically Weighted Elliptical Regression Model Fits.}
\usage{
\method{summary}{gwer}(object, ...)
}
\arguments{
\item{object}{an object with the result of the fitted geographically weighted elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \dQuote{summary.gwer}, a list with follow components: 
\item{coefficients}{the matrix of summarizing coefficients, standard errors and significance values for parameters hypothesis test.}
\item{dispersion}{either the supplied argument or the estimated dispersion with standard error.}
\item{residuals}{the residuals from \code{object}.}
\item{family}{family from \code{object}.}
\item{results}{a list of results values for fitted geographically weighted elliptical model.}  
\item{spdisp}{a logical value indicating whether the dispersion varies geographically from \code{object}.}
\item{df}{degrees of freedom from \code{object}.}
\item{terms}{the \code{terms} object used.}
\item{inter}{number of iterations of optimization process.}
\item{nas}{a logical vector indicating if there is \code{na} in estimation of coefficients.}
\item{type}{a character string indicating the type of residuals was obtained from \code{object}}
\item{hatmatrix}{a logical value indicating if hat matrix was obtained from \code{object}}
\item{call}{the matched call from \code{object}.}
\item{scale}{values of the \code{4d_g} for the specified distribution from \code{object}.}
\item{scaledispersion}{values of the \code{4f_g} for the specified distribution from \code{object}.}
\item{scalevariance}{values of the scale variance for the specified distribution from \code{object}.}
}
\description{
This function produce summary for the result of the fitted geographically weighted elliptical regression model.
}
\examples{
\donttest{
data(georgia, package = "spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.t <- bw.gwer(fit.formula, data = gSRDF, family = Student(3), adapt = TRUE)
gwer.fit.t <- gwer(fit.formula, data = gSRDF, family = Student(3), bandwidth = gwer.bw.t, 
                   adapt = TRUE, parplot = FALSE, hatmatrix = TRUE, spdisp = TRUE, 
                   method = "gwer.fit")
summary(gwer.fit.t) 
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \doi{10.1111/j.1538-4632.1996.tb00936.x}

Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\doi{10.1016/j.spl.2007.01.012}
}
\seealso{
\code{\link{summary}}, \code{\link{gwer}}, \code{\link{family.elliptical}}
}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{model}
\keyword{regression}
\keyword{weighted}
