% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildOneFac}
\alias{buildOneFac}
\title{Build a model suitable for a single factor genome-wide association study}
\usage{
buildOneFac(
  phenoData,
  itemNames,
  covariates = NULL,
  ...,
  fitfun = c("WLS", "ML"),
  minMAF = 0.01,
  gxe = NULL,
  exogenous = NA
)
}
\arguments{
\item{phenoData}{A matrix or data.frame which provides all of the phenotype data to the model (both the items and the covariates). Data should be constructed so that variables are on the columns and individuals are on the rows.}

\item{itemNames}{A vector of phenotypic item names (from \code{phenoData}) that load on the latent factor.}

\item{covariates}{A vector of data column names (from \code{phenoData}) to use as covariates (e.g. age, sex, and ancestry principle components).}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{A character string naming the fit function used to optimize the model. Must be either \sQuote{WLS} or \sQuote{ML}.}

\item{minMAF}{A numerical value that specifies the minimum valid minor allele frequency for a SNP. SNPs with minimum minor allele frequencies that are smaller than the minMAF value will not be analyzed. Only used when \code{fitfun=WLS}}

\item{gxe}{a vector of data column names. Creates additional data
columns named paste0('snp_',columnName) that are the
product of the SNP and the data in columnName}

\item{exogenous}{logical value. Whether the covariates should be treated as exogenous (TRUE) or endogenous (FALSE).}
}
\value{
\code{buildOneFac} returns an \link[OpenMx:MxModel-class]{MxModel} object that can serve as input for the \link{GWAS} function.
}
\description{
The \code{buildOneFac} function is used to specify a single factor latent variable model where the latent variable is predicted by a genomic variant such as a single nucleotide polymorphism, as well as range of covariates. \figure{singleFactor.jpg}{Single Factor Model}
}
\details{
This function is designed to be passed to the \link{GWAS} function. The model that is returned, however, is a valid OpenMx model and can be fitted using \link[OpenMx]{mxRun} or \link[OpenMx]{mxTryHard}. Models should be tested to ensure that they are identified and fit the data as expected to avoid unnecessary computation of an invalid model.

There is no limit on the number of items that can be included, but more items will exponentially increase computation time.  To address this, we suggest that users use the \sQuote{WLS} fit function. The \sQuote{WLS} fit function is dramatically faster than the \sQuote{ML} fit function, especially for ordinal items.

Ordinal indicator thresholds are setup by
\link{setupThresholds}. Exogenous covariates adjustments are setup by
\link{setupExogenousCovariates}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\examples{
pheno <- list()
for (i in 1:5) pheno[[paste0('i',i)]] <- rnorm(500)
pheno <- as.data.frame(pheno)
buildOneFac(pheno, colnames(pheno))
}
\seealso{
Other model builder: 
\code{\link{buildItem}()},
\code{\link{buildOneFacRes}()},
\code{\link{buildTwoFac}()}
}
\concept{model builder}
