% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gyro.R
\encoding{UTF-8}
\name{gyromidpoint}
\alias{gyromidpoint}
\title{Gyromidpoint}
\usage{
gyromidpoint(A, B, s = 1, model = "U")
}
\arguments{
\item{A, B}{two distinct points (of the same dimension)}

\item{s}{positive number, the radius of the Poincaré ball if
\code{model="M"}, otherwise, if \code{model="U"}, this number
defines the hyperbolic curvature}

\item{model}{the hyperbolic model, either \code{"M"} (Möbius model, i.e.
Poincaré model) or \code{"U"} (Ungar model, i.e. hyperboloid model)}
}
\value{
A point, the gyromidpoint of a the \code{\link{gyrosegment}}
  joining \code{A} and \code{B}.
}
\description{
The gyromidpoint of a \code{\link{gyrosegment}}.
}
\note{
This is the same as \code{gyroABt(A, B, 1/2, s)} but the
  calculation is more efficient.
}
