% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.dim}
\alias{dim,H2OFrame-method}
\alias{h2o.dim}
\title{Returns the Dimensions of a Parsed H2O Data Object.}
\usage{
h2o.dim(x)

\S4method{dim}{H2OFrame}(x)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}
}
\description{
Returns the number of rows and columns for an \linkS4class{H2OFrame} object.
}
\examples{
\dontrun{
localH2O <- h2o.init()
irisPath <- system.file("extdata", "iris.csv", package="h2o")
iris.hex <- h2o.uploadFile(localH2O, path = irisPath)
dim(iris.hex)
}
}
\seealso{
\code{\link[base]{dim}} for the base R method.
}

