% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.ddply}
\alias{h2o.ddply}
\title{Split H2O Dataset, Apply Function, and Return Results}
\usage{
h2o.ddply(X, .variables, FUN, ..., .progress = "none")
}
\arguments{
\item{X}{An H2OFrame object to be processed.}

\item{.variables}{Variables to split \code{X} by, either the indices or names of a set of columns.}

\item{FUN}{Function to apply to each subset grouping.}

\item{...}{Additional arguments passed on to \code{FUN}.}

\item{.progress}{Name of the progress bar to use. #TODO: (Currently unimplemented)}
}
\value{
Returns an H2OFrame object containing the results from the split/apply operation, arranged
}
\description{
For each subset of an H2O data set, apply a user-specified function, then combine the results.  This is an experimental feature.
}
\examples{
\donttest{
library(h2o)
h2o.init()

# Import iris dataset to H2O
irisPath <- system.file("extdata", "iris_wheader.csv", package = "h2o")
iris.hex <- h2o.uploadFile(path = irisPath, destination_frame = "iris.hex")
# Add function taking mean of sepal_len column
fun <- function(df) { sum(df[,1], na.rm = TRUE)/nrow(df) }
# Apply function to groups by class of flower
# uses h2o's ddply, since iris.hex is an H2OFrame object
res <- h2o.ddply(iris.hex, "class", fun)
head(res)
}
}
\seealso{
\code{\link[plyr]{ddply}} for the plyr library implementation.
}

