% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.getModelTree}
\alias{h2o.getModelTree}
\title{Fetchces a single tree of a H2O model. This function is intended to be used on Gradient Boosting Machine models or Distributed Random Forest models.}
\usage{
h2o.getModelTree(model, tree_number, tree_class = NA)
}
\arguments{
\item{model}{Model with trees}

\item{tree_number}{Number of the tree in the model to fetch, starting with 1}

\item{tree_class}{Name of the class of the tree (if applicable). This value is ignored for regression and binomial response column, as there is only one tree built.
As there is exactly one class per categorical level, name of tree's class equals to the corresponding categorical level of response column.}
}
\value{
Returns an H2OTree object with detailed information about a tree.
}
\description{
Usage example:
airlines.data <- h2o.importFile(path = '/path/to/airlines_train.csv')
gbm.model = h2o.gbm(x=c("Origin", "Dest", "Distance"),y="IsDepDelayed",training_frame=airlines.data ,model_id="gbm_trees_model")
tree <-h2o.getModelTree(gbm.model, 1, 1);
}

