% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.giniCoef}
\alias{h2o.giniCoef}
\title{Retrieve the GINI Coefficcient}
\usage{
h2o.giniCoef(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{an \linkS4class{H2OBinomialMetrics} object.}

\item{train}{Retrieve the training GINI Coefficcient}

\item{valid}{Retrieve the validation GINI Coefficcient}

\item{xval}{Retrieve the cross-validation GINI Coefficcient}
}
\description{
Retrieves the GINI coefficient from an \linkS4class{H2OBinomialMetrics}.
If "train", "valid", and "xval" parameters are FALSE (default), then the training GINIvalue is returned. If more
than one parameter is set to TRUE, then a named vector of GINIs are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\donttest{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(prostate_path)

prostate[,2] <- as.factor(prostate[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = prostate, distribution = "bernoulli")
perf <- h2o.performance(model, prostate)
h2o.giniCoef(perf)
}
}
\seealso{
\code{\link{h2o.auc}} for AUC,  \code{\link{h2o.giniCoef}} for the
         GINI coefficient, and \code{\link{h2o.metric}} for the various. See
         \code{\link{h2o.performance}} for creating H2OModelMetrics objects.
         threshold metrics.
}
