% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.distance}
\alias{h2o.distance}
\title{Compute a pairwise distance measure between all rows of two numeric H2OFrames.}
\usage{
h2o.distance(x, y, measure)
}
\arguments{
\item{x}{An H2OFrame object (large, references).}

\item{y}{An H2OFrame object (small, queries).}

\item{measure}{An optional string indicating what distance measure to use. Must be one of:
"l1"                   - Absolute distance (L1-norm, >=0)
"l2"                   - Euclidean distance (L2-norm, >=0)
"cosine"               - Cosine similarity (-1...1)
"cosine_sq"            - Squared Cosine similarity (0...1)}
}
\description{
Compute a pairwise distance measure between all rows of two numeric H2OFrames.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
h2o.distance(prostate[11:30,], prostate[1:10,], "cosine")
}
}
