% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_utilities.R
\name{cell_area}
\alias{cell_area}
\title{Get exact cell area}
\usage{
cell_area(h3_address = NULL, units = c("m2", "km2", "rads2"), simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{units}{Length unit to report in. Options are square meters, square
kilometers, or steradians.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a numeric vector of length(h3_address).
}
\description{
This function calculates the exact area of an H3 cell.
}
\examples{
cell_area(h3_address = '8abe8d12acaffff', 'm2')
}
