% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{uncompactCells}
\alias{uncompactCells}
\title{Uncompacts a set of compacted H3 cell indexes to a given resolution.}
\usage{
uncompactCells(compactedSet, resolution)
}
\arguments{
\item{compactedSet}{list of character vectors containing compacted H3 cell
indexes}

\item{resolution}{integer specifying the resolution for the uncompacted cells}
}
\value{
a list of character vectors containing the uncompacted H3 cell
indexes at the specified resolution
}
\description{
This function uncompacts the provided set of compacted H3 cell indexes to
the specified resolution.
}
\examples{

uncompactCells(
  compactCells(
    gridDisk(
      cell = c("85283477fffffff", "85283423fffffff")
      , k = c(1L, 2L)
     )
   )
   , res = c(5L, 5L)
 )

}
