% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Dataset-Extend.R
\docType{methods}
\name{DataSet-Extend}
\alias{DataSet-Extend}
\alias{c,DataSet-method}
\alias{extendDataSet}
\alias{extendDataSet,DataSet,numeric-method}
\title{Functions to Extend a DataSet}
\usage{
extendDataSet(.Object, dims)

\S4method{extendDataSet}{DataSet,numeric}(.Object, dims)

\S4method{c}{DataSet}(x, ..., recursive = FALSE)
}
\arguments{
\item{.Object,x}{DataSet; S4 object of class \code{DataSet};}

\item{dims}{numeric; Dimensions of DataSet.}

\item{...}{additional arguments passed to \code{\link{c}}.}

\item{recursive}{logical; Argument passed to \code{\link{c}}.}
}
\description{
\code{\link{DataSet}}s can be extended with R--objects (e.g. vectors,
matrices, arrays) if the following conditions are met:
\enumerate{
  \item{Datatype of \link{DataSet} and R-object are compatible.}
	 \item{Dimensions of \link{DataSet} and R-object match (no recycling).}
  \item{\link{DataSet} does not exceed maximum dimensions as specified at creation.}
}
}
\details{
Known base functions have been overloaded to extend vectors (\code{c}) and
matrices (\code{rbind}, \code{cbind}). Also the lower--level S4--method
\code{extendDataSet} can be used to extend existing \code{\link{DataSet}}
objects.
}

