/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_choiceRT_lba_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_choiceRT_lba");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_choiceRT_lba");
    reader.add_event(292, 277, "end", "model_choiceRT_lba");
    return reader;
}

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
lba_pdf(const T0__& t,
            const T1__& b,
            const T2__& A,
            const T3__& v_pdf,
            const T4__& s, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 21;
        local_scalar_t__ b_A_tv_ts;
        (void) b_A_tv_ts;  // dummy to suppress unused var warning

        stan::math::initialize(b_A_tv_ts, DUMMY_VAR__);
        stan::math::fill(b_A_tv_ts,DUMMY_VAR__);
        current_statement_begin__ = 22;
        local_scalar_t__ b_tv_ts;
        (void) b_tv_ts;  // dummy to suppress unused var warning

        stan::math::initialize(b_tv_ts, DUMMY_VAR__);
        stan::math::fill(b_tv_ts,DUMMY_VAR__);
        current_statement_begin__ = 23;
        local_scalar_t__ term_1b;
        (void) term_1b;  // dummy to suppress unused var warning

        stan::math::initialize(term_1b, DUMMY_VAR__);
        stan::math::fill(term_1b,DUMMY_VAR__);
        current_statement_begin__ = 24;
        local_scalar_t__ term_2b;
        (void) term_2b;  // dummy to suppress unused var warning

        stan::math::initialize(term_2b, DUMMY_VAR__);
        stan::math::fill(term_2b,DUMMY_VAR__);
        current_statement_begin__ = 25;
        local_scalar_t__ term_3b;
        (void) term_3b;  // dummy to suppress unused var warning

        stan::math::initialize(term_3b, DUMMY_VAR__);
        stan::math::fill(term_3b,DUMMY_VAR__);
        current_statement_begin__ = 26;
        local_scalar_t__ term_4b;
        (void) term_4b;  // dummy to suppress unused var warning

        stan::math::initialize(term_4b, DUMMY_VAR__);
        stan::math::fill(term_4b,DUMMY_VAR__);
        current_statement_begin__ = 27;
        local_scalar_t__ pdf;
        (void) pdf;  // dummy to suppress unused var warning

        stan::math::initialize(pdf, DUMMY_VAR__);
        stan::math::fill(pdf,DUMMY_VAR__);


        current_statement_begin__ = 29;
        stan::math::assign(b_A_tv_ts, (((b - A) - (t * v_pdf)) / (t * s)));
        current_statement_begin__ = 30;
        stan::math::assign(b_tv_ts, ((b - (t * v_pdf)) / (t * s)));
        current_statement_begin__ = 32;
        stan::math::assign(term_1b, (v_pdf * Phi(b_A_tv_ts)));
        current_statement_begin__ = 33;
        stan::math::assign(term_2b, (s * stan::math::exp(normal_log(stan::math::fabs(b_A_tv_ts),0,1))));
        current_statement_begin__ = 34;
        stan::math::assign(term_3b, (v_pdf * Phi(b_tv_ts)));
        current_statement_begin__ = 35;
        stan::math::assign(term_4b, (s * stan::math::exp(normal_log(stan::math::fabs(b_tv_ts),0,1))));
        current_statement_begin__ = 37;
        stan::math::assign(pdf, ((1 / A) * (((-(term_1b) + term_2b) + term_3b) - term_4b)));
        current_statement_begin__ = 39;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pdf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct lba_pdf_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& t,
            const T1__& b,
            const T2__& A,
            const T3__& v_pdf,
            const T4__& s, std::ostream* pstream__) const {
        return lba_pdf(t, b, A, v_pdf, s, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
lba_cdf(const T0__& t,
            const T1__& b,
            const T2__& A,
            const T3__& v_cdf,
            const T4__& s, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 44;
        local_scalar_t__ b_A_tv;
        (void) b_A_tv;  // dummy to suppress unused var warning

        stan::math::initialize(b_A_tv, DUMMY_VAR__);
        stan::math::fill(b_A_tv,DUMMY_VAR__);
        current_statement_begin__ = 45;
        local_scalar_t__ b_tv;
        (void) b_tv;  // dummy to suppress unused var warning

        stan::math::initialize(b_tv, DUMMY_VAR__);
        stan::math::fill(b_tv,DUMMY_VAR__);
        current_statement_begin__ = 46;
        local_scalar_t__ ts;
        (void) ts;  // dummy to suppress unused var warning

        stan::math::initialize(ts, DUMMY_VAR__);
        stan::math::fill(ts,DUMMY_VAR__);
        current_statement_begin__ = 47;
        local_scalar_t__ term_1a;
        (void) term_1a;  // dummy to suppress unused var warning

        stan::math::initialize(term_1a, DUMMY_VAR__);
        stan::math::fill(term_1a,DUMMY_VAR__);
        current_statement_begin__ = 48;
        local_scalar_t__ term_2a;
        (void) term_2a;  // dummy to suppress unused var warning

        stan::math::initialize(term_2a, DUMMY_VAR__);
        stan::math::fill(term_2a,DUMMY_VAR__);
        current_statement_begin__ = 49;
        local_scalar_t__ term_3a;
        (void) term_3a;  // dummy to suppress unused var warning

        stan::math::initialize(term_3a, DUMMY_VAR__);
        stan::math::fill(term_3a,DUMMY_VAR__);
        current_statement_begin__ = 50;
        local_scalar_t__ term_4a;
        (void) term_4a;  // dummy to suppress unused var warning

        stan::math::initialize(term_4a, DUMMY_VAR__);
        stan::math::fill(term_4a,DUMMY_VAR__);
        current_statement_begin__ = 51;
        local_scalar_t__ cdf;
        (void) cdf;  // dummy to suppress unused var warning

        stan::math::initialize(cdf, DUMMY_VAR__);
        stan::math::fill(cdf,DUMMY_VAR__);


        current_statement_begin__ = 53;
        stan::math::assign(b_A_tv, ((b - A) - (t * v_cdf)));
        current_statement_begin__ = 54;
        stan::math::assign(b_tv, (b - (t * v_cdf)));
        current_statement_begin__ = 55;
        stan::math::assign(ts, (t * s));
        current_statement_begin__ = 57;
        stan::math::assign(term_1a, ((b_A_tv / A) * Phi((b_A_tv / ts))));
        current_statement_begin__ = 58;
        stan::math::assign(term_2a, ((b_tv / A) * Phi((b_tv / ts))));
        current_statement_begin__ = 59;
        stan::math::assign(term_3a, ((ts / A) * stan::math::exp(normal_log(stan::math::fabs((b_A_tv / ts)),0,1))));
        current_statement_begin__ = 60;
        stan::math::assign(term_4a, ((ts / A) * stan::math::exp(normal_log(stan::math::fabs((b_tv / ts)),0,1))));
        current_statement_begin__ = 62;
        stan::math::assign(cdf, ((((1 + term_1a) - term_2a) + term_3a) - term_4a));
        current_statement_begin__ = 64;
        return stan::math::promote_scalar<fun_return_scalar_t__>(cdf);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct lba_cdf_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type
    operator()(const T0__& t,
            const T1__& b,
            const T2__& A,
            const T3__& v_cdf,
            const T4__& s, std::ostream* pstream__) const {
        return lba_cdf(t, b, A, v_cdf, s, pstream__);
    }
};

template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
lba_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,Eigen::Dynamic>& RT,
             const T1__& d,
             const T2__& A,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& v,
             const T4__& s,
             const T5__& tau, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 69;
        local_scalar_t__ t;
        (void) t;  // dummy to suppress unused var warning

        stan::math::initialize(t, DUMMY_VAR__);
        stan::math::fill(t,DUMMY_VAR__);
        current_statement_begin__ = 70;
        local_scalar_t__ b;
        (void) b;  // dummy to suppress unused var warning

        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);
        current_statement_begin__ = 71;
        local_scalar_t__ cdf;
        (void) cdf;  // dummy to suppress unused var warning

        stan::math::initialize(cdf, DUMMY_VAR__);
        stan::math::fill(cdf,DUMMY_VAR__);
        current_statement_begin__ = 72;
        local_scalar_t__ pdf;
        (void) pdf;  // dummy to suppress unused var warning

        stan::math::initialize(pdf, DUMMY_VAR__);
        stan::math::fill(pdf,DUMMY_VAR__);
        current_statement_begin__ = 73;
        validate_non_negative_index("prob", "cols(RT)", cols(RT));
        Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  prob(static_cast<Eigen::VectorXd::Index>(cols(RT)));
        (void) prob;  // dummy to suppress unused var warning

        stan::math::initialize(prob, DUMMY_VAR__);
        stan::math::fill(prob,DUMMY_VAR__);
        current_statement_begin__ = 74;
        local_scalar_t__ out;
        (void) out;  // dummy to suppress unused var warning

        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out,DUMMY_VAR__);
        current_statement_begin__ = 75;
        local_scalar_t__ prob_neg;
        (void) prob_neg;  // dummy to suppress unused var warning

        stan::math::initialize(prob_neg, DUMMY_VAR__);
        stan::math::fill(prob_neg,DUMMY_VAR__);


        current_statement_begin__ = 77;
        stan::math::assign(b, (A + d));
        current_statement_begin__ = 78;
        for (int i = 1; i <= cols(RT); ++i) {

            current_statement_begin__ = 79;
            stan::math::assign(t, (get_base1(RT,1,i,"RT",1) - tau));
            current_statement_begin__ = 80;
            if (as_bool(logical_gt(t,0))) {

                current_statement_begin__ = 81;
                stan::math::assign(cdf, 1);
                current_statement_begin__ = 82;
                for (int j = 1; j <= num_elements(v); ++j) {

                    current_statement_begin__ = 83;
                    if (as_bool(logical_eq(get_base1(RT,2,i,"RT",1),j))) {

                        current_statement_begin__ = 84;
                        stan::math::assign(pdf, lba_pdf(t,b,A,get_base1(v,j,"v",1),s, pstream__));
                    } else {

                        current_statement_begin__ = 86;
                        stan::math::assign(cdf, (cdf * lba_cdf(t,b,A,get_base1(v,j,"v",1),s, pstream__)));
                    }
                }
                current_statement_begin__ = 89;
                stan::math::assign(prob_neg, 1);
                current_statement_begin__ = 90;
                for (int j = 1; j <= num_elements(v); ++j) {

                    current_statement_begin__ = 91;
                    stan::math::assign(prob_neg, (prob_neg * Phi((-(get_base1(v,j,"v",1)) / s))));
                }
                current_statement_begin__ = 93;
                stan::model::assign(prob, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (pdf * (1 - cdf)), 
                            "assigning variable prob");
                current_statement_begin__ = 94;
                stan::model::assign(prob, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(prob, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "prob") / (1 - prob_neg)), 
                            "assigning variable prob");
                current_statement_begin__ = 95;
                if (as_bool(logical_lt(get_base1(prob,i,"prob",1),1e-10))) {

                    current_statement_begin__ = 96;
                    stan::model::assign(prob, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                1e-10, 
                                "assigning variable prob");
                }
            } else {

                current_statement_begin__ = 100;
                stan::model::assign(prob, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            1e-10, 
                            "assigning variable prob");
            }
        }
        current_statement_begin__ = 103;
        stan::math::assign(out, sum(stan::math::log(prob)));
        current_statement_begin__ = 104;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
lba_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,Eigen::Dynamic>& RT,
             const T1__& d,
             const T2__& A,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& v,
             const T4__& s,
             const T5__& tau, std::ostream* pstream__) {
    return lba_lpdf<false>(RT,d,A,v,s,tau, pstream__);
}


struct lba_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,Eigen::Dynamic>& RT,
             const T1__& d,
             const T2__& A,
             const Eigen::Matrix<T3__, Eigen::Dynamic,1>& v,
             const T4__& s,
             const T5__& tau, std::ostream* pstream__) const {
        return lba_lpdf(RT, d, A, v, s, tau, pstream__);
    }
};

template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, class RNG>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
lba_rng(const T0__& d,
            const T1__& A,
            const Eigen::Matrix<T2__, Eigen::Dynamic,1>& v,
            const T3__& s,
            const T4__& tau, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 109;
        int get_pos_drift(0);
        (void) get_pos_drift;  // dummy to suppress unused var warning

        stan::math::fill(get_pos_drift, std::numeric_limits<int>::min());
        current_statement_begin__ = 110;
        int no_pos_drift(0);
        (void) no_pos_drift;  // dummy to suppress unused var warning

        stan::math::fill(no_pos_drift, std::numeric_limits<int>::min());
        current_statement_begin__ = 111;
        int get_first_pos(0);
        (void) get_first_pos;  // dummy to suppress unused var warning

        stan::math::fill(get_first_pos, std::numeric_limits<int>::min());
        current_statement_begin__ = 112;
        validate_non_negative_index("drift", "num_elements(v)", num_elements(v));
        Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  drift(static_cast<Eigen::VectorXd::Index>(num_elements(v)));
        (void) drift;  // dummy to suppress unused var warning

        stan::math::initialize(drift, DUMMY_VAR__);
        stan::math::fill(drift,DUMMY_VAR__);
        current_statement_begin__ = 113;
        int max_iter(0);
        (void) max_iter;  // dummy to suppress unused var warning

        stan::math::fill(max_iter, std::numeric_limits<int>::min());
        current_statement_begin__ = 114;
        int iter(0);
        (void) iter;  // dummy to suppress unused var warning

        stan::math::fill(iter, std::numeric_limits<int>::min());
        current_statement_begin__ = 115;
        validate_non_negative_index("start", "num_elements(v)", num_elements(v));
        vector<local_scalar_t__> start(num_elements(v));
        stan::math::initialize(start, DUMMY_VAR__);
        stan::math::fill(start,DUMMY_VAR__);
        current_statement_begin__ = 116;
        validate_non_negative_index("ttf", "num_elements(v)", num_elements(v));
        vector<local_scalar_t__> ttf(num_elements(v));
        stan::math::initialize(ttf, DUMMY_VAR__);
        stan::math::fill(ttf,DUMMY_VAR__);
        current_statement_begin__ = 117;
        validate_non_negative_index("resp", "num_elements(v)", num_elements(v));
        vector<int> resp(num_elements(v), 0);
        stan::math::fill(resp, std::numeric_limits<int>::min());
        current_statement_begin__ = 118;
        local_scalar_t__ rt;
        (void) rt;  // dummy to suppress unused var warning

        stan::math::initialize(rt, DUMMY_VAR__);
        stan::math::fill(rt,DUMMY_VAR__);
        current_statement_begin__ = 119;
        validate_non_negative_index("pred", "2", 2);
        Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  pred(static_cast<Eigen::VectorXd::Index>(2));
        (void) pred;  // dummy to suppress unused var warning

        stan::math::initialize(pred, DUMMY_VAR__);
        stan::math::fill(pred,DUMMY_VAR__);
        current_statement_begin__ = 120;
        local_scalar_t__ b;
        (void) b;  // dummy to suppress unused var warning

        stan::math::initialize(b, DUMMY_VAR__);
        stan::math::fill(b,DUMMY_VAR__);


        current_statement_begin__ = 123;
        stan::math::assign(get_pos_drift, 1);
        current_statement_begin__ = 124;
        stan::math::assign(no_pos_drift, 0);
        current_statement_begin__ = 125;
        stan::math::assign(max_iter, 1000);
        current_statement_begin__ = 126;
        stan::math::assign(iter, 0);
        current_statement_begin__ = 127;
        while (as_bool(get_pos_drift)) {

            current_statement_begin__ = 128;
            for (int j = 1; j <= num_elements(v); ++j) {

                current_statement_begin__ = 129;
                stan::model::assign(drift, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                            normal_rng(get_base1(v,j,"v",1),s, base_rng__), 
                            "assigning variable drift");
                current_statement_begin__ = 130;
                if (as_bool(logical_gt(get_base1(drift,j,"drift",1),0))) {

                    current_statement_begin__ = 131;
                    stan::math::assign(get_pos_drift, 0);
                }
            }
            current_statement_begin__ = 134;
            stan::math::assign(iter, (iter + 1));
            current_statement_begin__ = 135;
            if (as_bool(logical_gt(iter,max_iter))) {

                current_statement_begin__ = 136;
                stan::math::assign(get_pos_drift, 0);
                current_statement_begin__ = 137;
                stan::math::assign(no_pos_drift, 1);
            }
        }
        current_statement_begin__ = 142;
        if (as_bool(no_pos_drift)) {

            current_statement_begin__ = 143;
            stan::model::assign(pred, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        -(1), 
                        "assigning variable pred");
            current_statement_begin__ = 144;
            stan::model::assign(pred, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        -(1), 
                        "assigning variable pred");
        } else {

            current_statement_begin__ = 146;
            stan::math::assign(b, (A + d));
            current_statement_begin__ = 147;
            for (int i = 1; i <= num_elements(v); ++i) {

                current_statement_begin__ = 149;
                stan::model::assign(start, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            uniform_rng(0,A, base_rng__), 
                            "assigning variable start");
                current_statement_begin__ = 151;
                stan::model::assign(ttf, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((b - get_base1(start,i,"start",1)) / get_base1(drift,i,"drift",1)), 
                            "assigning variable ttf");
            }
            current_statement_begin__ = 155;
            stan::math::assign(resp, sort_indices_asc(ttf));
            {
            current_statement_begin__ = 157;
            validate_non_negative_index("temp_ttf", "num_elements(v)", num_elements(v));
            vector<local_scalar_t__> temp_ttf(num_elements(v));
            stan::math::initialize(temp_ttf, DUMMY_VAR__);
            stan::math::fill(temp_ttf,DUMMY_VAR__);


            current_statement_begin__ = 158;
            stan::math::assign(temp_ttf, sort_asc(ttf));
            current_statement_begin__ = 159;
            stan::math::assign(ttf, temp_ttf);
            }
            current_statement_begin__ = 161;
            stan::math::assign(get_first_pos, 1);
            current_statement_begin__ = 162;
            stan::math::assign(iter, 1);
            current_statement_begin__ = 163;
            while (as_bool(get_first_pos)) {

                current_statement_begin__ = 164;
                if (as_bool(logical_gt(get_base1(ttf,iter,"ttf",1),0))) {

                    current_statement_begin__ = 165;
                    stan::model::assign(pred, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                get_base1(ttf,iter,"ttf",1), 
                                "assigning variable pred");
                    current_statement_begin__ = 166;
                    stan::model::assign(pred, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                get_base1(resp,iter,"resp",1), 
                                "assigning variable pred");
                    current_statement_begin__ = 167;
                    stan::math::assign(get_first_pos, 0);
                }
                current_statement_begin__ = 169;
                stan::math::assign(iter, (iter + 1));
            }
        }
        current_statement_begin__ = 172;
        return stan::math::promote_scalar<fun_return_scalar_t__>(pred);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct lba_rng_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, class RNG>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic,1>
    operator()(const T0__& d,
            const T1__& A,
            const Eigen::Matrix<T2__, Eigen::Dynamic,1>& v,
            const T3__& s,
            const T4__& tau, RNG& base_rng__, std::ostream* pstream__) const {
        return lba_rng(d, A, v, s, tau, base_rng__, pstream__);
    }
};

#include <meta_header.hpp>
 class model_choiceRT_lba : public prob_grad {
private:
    int N;
    int Max_tr;
    int N_choices;
    int N_cond;
    vector<vector<int> > N_tr_cond;
    vector<vector<matrix_d> > RT;
public:
    model_choiceRT_lba(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_choiceRT_lba(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_choiceRT_lba_namespace::model_choiceRT_lba";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 176;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 177;
            context__.validate_dims("data initialization", "Max_tr", "int", context__.to_vec());
            Max_tr = int(0);
            vals_i__ = context__.vals_i("Max_tr");
            pos__ = 0;
            Max_tr = vals_i__[pos__++];
            current_statement_begin__ = 178;
            context__.validate_dims("data initialization", "N_choices", "int", context__.to_vec());
            N_choices = int(0);
            vals_i__ = context__.vals_i("N_choices");
            pos__ = 0;
            N_choices = vals_i__[pos__++];
            current_statement_begin__ = 179;
            context__.validate_dims("data initialization", "N_cond", "int", context__.to_vec());
            N_cond = int(0);
            vals_i__ = context__.vals_i("N_cond");
            pos__ = 0;
            N_cond = vals_i__[pos__++];
            current_statement_begin__ = 180;
            validate_non_negative_index("N_tr_cond", "N", N);
            validate_non_negative_index("N_tr_cond", "N_cond", N_cond);
            context__.validate_dims("data initialization", "N_tr_cond", "int", context__.to_vec(N,N_cond));
            validate_non_negative_index("N_tr_cond", "N", N);
            validate_non_negative_index("N_tr_cond", "N_cond", N_cond);
            N_tr_cond = std::vector<std::vector<int> >(N,std::vector<int>(N_cond,int(0)));
            vals_i__ = context__.vals_i("N_tr_cond");
            pos__ = 0;
            size_t N_tr_cond_limit_1__ = N_cond;
            for (size_t i_1__ = 0; i_1__ < N_tr_cond_limit_1__; ++i_1__) {
                size_t N_tr_cond_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < N_tr_cond_limit_0__; ++i_0__) {
                    N_tr_cond[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 181;
            validate_non_negative_index("RT", "N", N);
            validate_non_negative_index("RT", "N_cond", N_cond);
            validate_non_negative_index("RT", "2", 2);
            validate_non_negative_index("RT", "Max_tr", Max_tr);
            context__.validate_dims("data initialization", "RT", "matrix_d", context__.to_vec(N,N_cond,2,Max_tr));
            validate_non_negative_index("RT", "N", N);
            validate_non_negative_index("RT", "N_cond", N_cond);
            validate_non_negative_index("RT", "2", 2);
            validate_non_negative_index("RT", "Max_tr", Max_tr);
            RT = std::vector<std::vector<matrix_d> >(N,std::vector<matrix_d>(N_cond,matrix_d(static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(Max_tr))));
            vals_r__ = context__.vals_r("RT");
            pos__ = 0;
            size_t RT_m_mat_lim__ = 2;
            size_t RT_n_mat_lim__ = Max_tr;
            for (size_t n_mat__ = 0; n_mat__ < RT_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < RT_m_mat_lim__; ++m_mat__) {
                    size_t RT_limit_1__ = N_cond;
                    for (size_t i_1__ = 0; i_1__ < RT_limit_1__; ++i_1__) {
                        size_t RT_limit_0__ = N;
                        for (size_t i_0__ = 0; i_0__ < RT_limit_0__; ++i_0__) {
                            RT[i_0__][i_1__](m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
                }
            }

            // validate, data variables
            current_statement_begin__ = 176;
            current_statement_begin__ = 177;
            current_statement_begin__ = 178;
            current_statement_begin__ = 179;
            current_statement_begin__ = 180;
            current_statement_begin__ = 181;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 187;
            ++num_params_r__;
            current_statement_begin__ = 188;
            ++num_params_r__;
            current_statement_begin__ = 189;
            ++num_params_r__;
            current_statement_begin__ = 190;
            validate_non_negative_index("mu_v", "N_choices", N_choices);
            validate_non_negative_index("mu_v", "N_cond", N_cond);
            num_params_r__ += N_choices * N_cond;
            current_statement_begin__ = 193;
            ++num_params_r__;
            current_statement_begin__ = 194;
            ++num_params_r__;
            current_statement_begin__ = 195;
            ++num_params_r__;
            current_statement_begin__ = 196;
            validate_non_negative_index("sigma_v", "N_choices", N_choices);
            validate_non_negative_index("sigma_v", "N_cond", N_cond);
            num_params_r__ += N_choices * N_cond;
            current_statement_begin__ = 199;
            validate_non_negative_index("d", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 200;
            validate_non_negative_index("A", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 201;
            validate_non_negative_index("tau", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 202;
            validate_non_negative_index("v", "N_choices", N_choices);
            validate_non_negative_index("v", "N", N);
            validate_non_negative_index("v", "N_cond", N_cond);
            num_params_r__ += N_choices * N * N_cond;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_choiceRT_lba() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_d")))
            throw std::runtime_error("variable mu_d missing");
        vals_r__ = context__.vals_r("mu_d");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_d", "double", context__.to_vec());
        double mu_d(0);
        mu_d = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_d);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_d: ") + e.what());
        }

        if (!(context__.contains_r("mu_A")))
            throw std::runtime_error("variable mu_A missing");
        vals_r__ = context__.vals_r("mu_A");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_A", "double", context__.to_vec());
        double mu_A(0);
        mu_A = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_A);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_A: ") + e.what());
        }

        if (!(context__.contains_r("mu_tau")))
            throw std::runtime_error("variable mu_tau missing");
        vals_r__ = context__.vals_r("mu_tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu_tau", "double", context__.to_vec());
        double mu_tau(0);
        mu_tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu_tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_tau: ") + e.what());
        }

        if (!(context__.contains_r("mu_v")))
            throw std::runtime_error("variable mu_v missing");
        vals_r__ = context__.vals_r("mu_v");
        pos__ = 0U;
        validate_non_negative_index("mu_v", "N_cond", N_cond);
        validate_non_negative_index("mu_v", "N_choices", N_choices);
        context__.validate_dims("initialization", "mu_v", "vector_d", context__.to_vec(N_cond,N_choices));
        std::vector<vector_d> mu_v(N_cond,vector_d(static_cast<Eigen::VectorXd::Index>(N_choices)));
        for (int j1__ = 0U; j1__ < N_choices; ++j1__)
            for (int i0__ = 0U; i0__ < N_cond; ++i0__)
                mu_v[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < N_cond; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,mu_v[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_v: ") + e.what());
        }

        if (!(context__.contains_r("sigma_d")))
            throw std::runtime_error("variable sigma_d missing");
        vals_r__ = context__.vals_r("sigma_d");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_d", "double", context__.to_vec());
        double sigma_d(0);
        sigma_d = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_d);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_d: ") + e.what());
        }

        if (!(context__.contains_r("sigma_A")))
            throw std::runtime_error("variable sigma_A missing");
        vals_r__ = context__.vals_r("sigma_A");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_A", "double", context__.to_vec());
        double sigma_A(0);
        sigma_A = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_A);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_A: ") + e.what());
        }

        if (!(context__.contains_r("sigma_tau")))
            throw std::runtime_error("variable sigma_tau missing");
        vals_r__ = context__.vals_r("sigma_tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_tau", "double", context__.to_vec());
        double sigma_tau(0);
        sigma_tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_tau: ") + e.what());
        }

        if (!(context__.contains_r("sigma_v")))
            throw std::runtime_error("variable sigma_v missing");
        vals_r__ = context__.vals_r("sigma_v");
        pos__ = 0U;
        validate_non_negative_index("sigma_v", "N_cond", N_cond);
        validate_non_negative_index("sigma_v", "N_choices", N_choices);
        context__.validate_dims("initialization", "sigma_v", "vector_d", context__.to_vec(N_cond,N_choices));
        std::vector<vector_d> sigma_v(N_cond,vector_d(static_cast<Eigen::VectorXd::Index>(N_choices)));
        for (int j1__ = 0U; j1__ < N_choices; ++j1__)
            for (int i0__ = 0U; i0__ < N_cond; ++i0__)
                sigma_v[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < N_cond; ++i0__)
            try {
            writer__.vector_lb_unconstrain(0,sigma_v[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_v: ") + e.what());
        }

        if (!(context__.contains_r("d")))
            throw std::runtime_error("variable d missing");
        vals_r__ = context__.vals_r("d");
        pos__ = 0U;
        validate_non_negative_index("d", "N", N);
        context__.validate_dims("initialization", "d", "double", context__.to_vec(N));
        std::vector<double> d(N,double(0));
        for (int i0__ = 0U; i0__ < N; ++i0__)
            d[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < N; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,d[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable d: ") + e.what());
        }

        if (!(context__.contains_r("A")))
            throw std::runtime_error("variable A missing");
        vals_r__ = context__.vals_r("A");
        pos__ = 0U;
        validate_non_negative_index("A", "N", N);
        context__.validate_dims("initialization", "A", "double", context__.to_vec(N));
        std::vector<double> A(N,double(0));
        for (int i0__ = 0U; i0__ < N; ++i0__)
            A[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < N; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,A[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable A: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "N", N);
        context__.validate_dims("initialization", "tau", "double", context__.to_vec(N));
        std::vector<double> tau(N,double(0));
        for (int i0__ = 0U; i0__ < N; ++i0__)
            tau[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < N; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,tau[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("v")))
            throw std::runtime_error("variable v missing");
        vals_r__ = context__.vals_r("v");
        pos__ = 0U;
        validate_non_negative_index("v", "N", N);
        validate_non_negative_index("v", "N_cond", N_cond);
        validate_non_negative_index("v", "N_choices", N_choices);
        context__.validate_dims("initialization", "v", "vector_d", context__.to_vec(N,N_cond,N_choices));
        std::vector<std::vector<vector_d> > v(N,std::vector<vector_d>(N_cond,vector_d(static_cast<Eigen::VectorXd::Index>(N_choices))));
        for (int j1__ = 0U; j1__ < N_choices; ++j1__)
            for (int i1__ = 0U; i1__ < N_cond; ++i1__)
                for (int i0__ = 0U; i0__ < N; ++i0__)
                    v[i0__][i1__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < N; ++i0__)
            for (int i1__ = 0U; i1__ < N_cond; ++i1__)
                try {
            writer__.vector_lb_unconstrain(0,v[i0__][i1__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable v: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            local_scalar_t__ mu_d;
            (void) mu_d;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_d = in__.scalar_lb_constrain(0,lp__);
            else
                mu_d = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu_A;
            (void) mu_A;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_A = in__.scalar_lb_constrain(0,lp__);
            else
                mu_A = in__.scalar_lb_constrain(0);

            local_scalar_t__ mu_tau;
            (void) mu_tau;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_tau = in__.scalar_lb_constrain(0,lp__);
            else
                mu_tau = in__.scalar_lb_constrain(0);

            vector<Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1> > mu_v;
            size_t dim_mu_v_0__ = N_cond;
            mu_v.reserve(dim_mu_v_0__);
            for (size_t k_0__ = 0; k_0__ < dim_mu_v_0__; ++k_0__) {
                if (jacobian__)
                    mu_v.push_back(in__.vector_lb_constrain(0,N_choices,lp__));
                else
                    mu_v.push_back(in__.vector_lb_constrain(0,N_choices));
            }

            local_scalar_t__ sigma_d;
            (void) sigma_d;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_d = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_d = in__.scalar_lb_constrain(0);

            local_scalar_t__ sigma_A;
            (void) sigma_A;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_A = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_A = in__.scalar_lb_constrain(0);

            local_scalar_t__ sigma_tau;
            (void) sigma_tau;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_tau = in__.scalar_lb_constrain(0,lp__);
            else
                sigma_tau = in__.scalar_lb_constrain(0);

            vector<Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1> > sigma_v;
            size_t dim_sigma_v_0__ = N_cond;
            sigma_v.reserve(dim_sigma_v_0__);
            for (size_t k_0__ = 0; k_0__ < dim_sigma_v_0__; ++k_0__) {
                if (jacobian__)
                    sigma_v.push_back(in__.vector_lb_constrain(0,N_choices,lp__));
                else
                    sigma_v.push_back(in__.vector_lb_constrain(0,N_choices));
            }

            vector<local_scalar_t__> d;
            size_t dim_d_0__ = N;
            d.reserve(dim_d_0__);
            for (size_t k_0__ = 0; k_0__ < dim_d_0__; ++k_0__) {
                if (jacobian__)
                    d.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    d.push_back(in__.scalar_lb_constrain(0));
            }

            vector<local_scalar_t__> A;
            size_t dim_A_0__ = N;
            A.reserve(dim_A_0__);
            for (size_t k_0__ = 0; k_0__ < dim_A_0__; ++k_0__) {
                if (jacobian__)
                    A.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    A.push_back(in__.scalar_lb_constrain(0));
            }

            vector<local_scalar_t__> tau;
            size_t dim_tau_0__ = N;
            tau.reserve(dim_tau_0__);
            for (size_t k_0__ = 0; k_0__ < dim_tau_0__; ++k_0__) {
                if (jacobian__)
                    tau.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    tau.push_back(in__.scalar_lb_constrain(0));
            }

            vector<vector<Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1> > > v;
            size_t dim_v_0__ = N;
            v.resize(dim_v_0__);
            for (size_t k_0__ = 0; k_0__ < dim_v_0__; ++k_0__) {
                size_t dim_v_1__ = N_cond;
                v[k_0__].reserve(dim_v_1__);
                for (size_t k_1__ = 0; k_1__ < dim_v_1__; ++k_1__) {
                    if (jacobian__)
                        v[k_0__].push_back(in__.vector_lb_constrain(0,N_choices,lp__));
                    else
                        v[k_0__].push_back(in__.vector_lb_constrain(0,N_choices));
                }
            }


            // transformed parameters
            current_statement_begin__ = 206;
            local_scalar_t__ s;
            (void) s;  // dummy to suppress unused var warning

            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s,DUMMY_VAR__);


            current_statement_begin__ = 207;
            stan::math::assign(s, 1);

            // validate transformed parameters
            if (stan::math::is_uninitialized(s)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: s";
                throw std::runtime_error(msg__.str());
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 206;

            // model body

            current_statement_begin__ = 211;
            lp_accum__.add(normal_log<propto__>(mu_d, 0.5, 1));
            if (mu_d < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0.5, 1));
            current_statement_begin__ = 212;
            lp_accum__.add(normal_log<propto__>(mu_A, 0.5, 1));
            if (mu_A < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0.5, 1));
            current_statement_begin__ = 213;
            lp_accum__.add(normal_log<propto__>(mu_tau, 0.5, 0.5));
            if (mu_tau < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 0.5, 0.5));
            current_statement_begin__ = 216;
            lp_accum__.add(gamma_log<propto__>(sigma_d, 1, 1));
            current_statement_begin__ = 217;
            lp_accum__.add(gamma_log<propto__>(sigma_A, 1, 1));
            current_statement_begin__ = 218;
            lp_accum__.add(gamma_log<propto__>(sigma_tau, 1, 1));
            current_statement_begin__ = 221;
            for (int j = 1; j <= N_cond; ++j) {

                current_statement_begin__ = 222;
                for (int n = 1; n <= N_choices; ++n) {

                    current_statement_begin__ = 223;
                    lp_accum__.add(normal_log<propto__>(get_base1(get_base1(mu_v,j,"mu_v",1),n,"mu_v",2), 2, 1));
                    if (get_base1(get_base1(mu_v,j,"mu_v",1),n,"mu_v",2) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                    else lp_accum__.add(-normal_ccdf_log(0, 2, 1));
                    current_statement_begin__ = 224;
                    lp_accum__.add(gamma_log<propto__>(get_base1(get_base1(sigma_v,j,"sigma_v",1),n,"sigma_v",2), 1, 1));
                }
            }
            current_statement_begin__ = 228;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 230;
                int n_trials(0);
                (void) n_trials;  // dummy to suppress unused var warning

                stan::math::fill(n_trials, std::numeric_limits<int>::min());


                current_statement_begin__ = 233;
                lp_accum__.add(normal_log<propto__>(get_base1(d,i,"d",1), mu_d, sigma_d));
                if (get_base1(d,i,"d",1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, mu_d, sigma_d));
                current_statement_begin__ = 234;
                lp_accum__.add(normal_log<propto__>(get_base1(A,i,"A",1), mu_A, sigma_A));
                if (get_base1(A,i,"A",1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, mu_A, sigma_A));
                current_statement_begin__ = 235;
                lp_accum__.add(normal_log<propto__>(get_base1(tau,i,"tau",1), mu_tau, sigma_tau));
                if (get_base1(tau,i,"tau",1) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                else lp_accum__.add(-normal_ccdf_log(0, mu_tau, sigma_tau));
                current_statement_begin__ = 237;
                for (int j = 1; j <= N_cond; ++j) {

                    current_statement_begin__ = 239;
                    stan::math::assign(n_trials, get_base1(get_base1(N_tr_cond,i,"N_tr_cond",1),j,"N_tr_cond",2));
                    current_statement_begin__ = 241;
                    for (int n = 1; n <= N_choices; ++n) {

                        current_statement_begin__ = 243;
                        lp_accum__.add(normal_log<propto__>(get_base1(get_base1(get_base1(v,i,"v",1),j,"v",2),n,"v",3), get_base1(get_base1(mu_v,j,"mu_v",1),n,"mu_v",2), get_base1(get_base1(sigma_v,j,"sigma_v",1),n,"sigma_v",2)));
                        if (get_base1(get_base1(get_base1(v,i,"v",1),j,"v",2),n,"v",3) < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
                        else lp_accum__.add(-normal_ccdf_log(0, get_base1(get_base1(mu_v,j,"mu_v",1),n,"mu_v",2), get_base1(get_base1(sigma_v,j,"sigma_v",1),n,"sigma_v",2)));
                    }
                    current_statement_begin__ = 246;
                    lp_accum__.add(lba_lpdf<propto__>(stan::model::rvalue(RT, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, n_trials), stan::model::nil_index_list())))), "RT"), get_base1(d,i,"d",1), get_base1(A,i,"A",1), stan::model::rvalue(v, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "v"), s, get_base1(tau,i,"tau",1), pstream__));
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_d");
        names__.push_back("mu_A");
        names__.push_back("mu_tau");
        names__.push_back("mu_v");
        names__.push_back("sigma_d");
        names__.push_back("sigma_A");
        names__.push_back("sigma_tau");
        names__.push_back("sigma_v");
        names__.push_back("d");
        names__.push_back("A");
        names__.push_back("tau");
        names__.push_back("v");
        names__.push_back("s");
        names__.push_back("n_trials");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_cond);
        dims__.push_back(N_choices);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_cond);
        dims__.push_back(N_choices);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N_cond);
        dims__.push_back(N_choices);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(N_cond);
        dims__.push_back(2);
        dims__.push_back(Max_tr);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_choiceRT_lba_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double mu_d = in__.scalar_lb_constrain(0);
        double mu_A = in__.scalar_lb_constrain(0);
        double mu_tau = in__.scalar_lb_constrain(0);
        vector<vector_d> mu_v;
        size_t dim_mu_v_0__ = N_cond;
        for (size_t k_0__ = 0; k_0__ < dim_mu_v_0__; ++k_0__) {
            mu_v.push_back(in__.vector_lb_constrain(0,N_choices));
        }
        double sigma_d = in__.scalar_lb_constrain(0);
        double sigma_A = in__.scalar_lb_constrain(0);
        double sigma_tau = in__.scalar_lb_constrain(0);
        vector<vector_d> sigma_v;
        size_t dim_sigma_v_0__ = N_cond;
        for (size_t k_0__ = 0; k_0__ < dim_sigma_v_0__; ++k_0__) {
            sigma_v.push_back(in__.vector_lb_constrain(0,N_choices));
        }
        vector<double> d;
        size_t dim_d_0__ = N;
        for (size_t k_0__ = 0; k_0__ < dim_d_0__; ++k_0__) {
            d.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> A;
        size_t dim_A_0__ = N;
        for (size_t k_0__ = 0; k_0__ < dim_A_0__; ++k_0__) {
            A.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> tau;
        size_t dim_tau_0__ = N;
        for (size_t k_0__ = 0; k_0__ < dim_tau_0__; ++k_0__) {
            tau.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector<vector_d> > v;
        size_t dim_v_0__ = N;
        v.resize(dim_v_0__);
        for (size_t k_0__ = 0; k_0__ < dim_v_0__; ++k_0__) {
            size_t dim_v_1__ = N_cond;
            for (size_t k_1__ = 0; k_1__ < dim_v_1__; ++k_1__) {
                v[k_0__].push_back(in__.vector_lb_constrain(0,N_choices));
            }
        }
        vars__.push_back(mu_d);
        vars__.push_back(mu_A);
        vars__.push_back(mu_tau);
            for (int k_1__ = 0; k_1__ < N_choices; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N_cond; ++k_0__) {
                vars__.push_back(mu_v[k_0__][k_1__]);
                }
            }
        vars__.push_back(sigma_d);
        vars__.push_back(sigma_A);
        vars__.push_back(sigma_tau);
            for (int k_1__ = 0; k_1__ < N_choices; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N_cond; ++k_0__) {
                vars__.push_back(sigma_v[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(d[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(A[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
            }
            for (int k_2__ = 0; k_2__ < N_choices; ++k_2__) {
                for (int k_1__ = 0; k_1__ < N_cond; ++k_1__) {
                    for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                    vars__.push_back(v[k_0__][k_1__][k_2__]);
                    }
                }
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 206;
            local_scalar_t__ s;
            (void) s;  // dummy to suppress unused var warning

            stan::math::initialize(s, DUMMY_VAR__);
            stan::math::fill(s,DUMMY_VAR__);


            current_statement_begin__ = 207;
            stan::math::assign(s, 1);

            // validate transformed parameters
            current_statement_begin__ = 206;

            // write transformed parameters
            if (include_tparams__) {
        vars__.push_back(s);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 253;
            int n_trials(0);
            (void) n_trials;  // dummy to suppress unused var warning

            stan::math::fill(n_trials, std::numeric_limits<int>::min());
            current_statement_begin__ = 256;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 259;
            validate_non_negative_index("y_pred", "2", 2);
            validate_non_negative_index("y_pred", "Max_tr", Max_tr);
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "N_cond", N_cond);
            vector<vector<Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic> > > y_pred(N, (vector<Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic> >(N_cond, (Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,Eigen::Dynamic> (static_cast<Eigen::VectorXd::Index>(2),static_cast<Eigen::VectorXd::Index>(Max_tr))))));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 262;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 263;
                for (int j = 1; j <= N_cond; ++j) {

                    current_statement_begin__ = 264;
                    for (int t = 1; t <= Max_tr; ++t) {

                        current_statement_begin__ = 265;
                        stan::model::assign(y_pred, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())))), 
                                    rep_vector(-(1),2), 
                                    "assigning variable y_pred");
                    }
                }
            }

            current_statement_begin__ = 271;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 273;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 275;
                for (int j = 1; j <= N_cond; ++j) {

                    current_statement_begin__ = 277;
                    stan::math::assign(n_trials, get_base1(get_base1(N_tr_cond,i,"N_tr_cond",1),j,"N_tr_cond",2));
                    current_statement_begin__ = 280;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + lba_lpdf(stan::model::rvalue(RT, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, n_trials), stan::model::nil_index_list())))), "RT"),get_base1(d,i,"d",1),get_base1(A,i,"A",1),stan::model::rvalue(v, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "v"),s,get_base1(tau,i,"tau",1), pstream__)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 282;
                    for (int t = 1; t <= n_trials; ++t) {

                        current_statement_begin__ = 284;
                        stan::model::assign(y_pred, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())))), 
                                    lba_rng(get_base1(d,i,"d",1),get_base1(A,i,"A",1),stan::model::rvalue(v, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list()))), "v"),s,get_base1(tau,i,"tau",1), base_rng__, pstream__), 
                                    "assigning variable y_pred");
                    }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 253;
            current_statement_begin__ = 256;
            current_statement_begin__ = 259;

            // write generated quantities
        vars__.push_back(n_trials);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_3__ = 0; k_3__ < Max_tr; ++k_3__) {
                for (int k_2__ = 0; k_2__ < 2; ++k_2__) {
                    for (int k_1__ = 0; k_1__ < N_cond; ++k_1__) {
                        for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                        vars__.push_back(y_pred[k_0__][k_1__](k_2__, k_3__));
                        }
                    }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_choiceRT_lba";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_d";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= N_choices; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N_cond; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_v" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_d";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= N_choices; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N_cond; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_v" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_2__ = 1; k_2__ <= N_choices; ++k_2__) {
            for (int k_1__ = 1; k_1__ <= N_cond; ++k_1__) {
                for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "v" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s";
            param_names__.push_back(param_name_stream__.str());
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "n_trials";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_3__ = 1; k_3__ <= Max_tr; ++k_3__) {
            for (int k_2__ = 1; k_2__ <= 2; ++k_2__) {
                for (int k_1__ = 1; k_1__ <= N_cond; ++k_1__) {
                    for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__ << '.' << k_3__;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_d";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= N_choices; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N_cond; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu_v" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_d";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_A";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_1__ = 1; k_1__ <= N_choices; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N_cond; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_v" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "d" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "A" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_2__ = 1; k_2__ <= N_choices; ++k_2__) {
            for (int k_1__ = 1; k_1__ <= N_cond; ++k_1__) {
                for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "v" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "s";
            param_names__.push_back(param_name_stream__.str());
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "n_trials";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_3__ = 1; k_3__ <= Max_tr; ++k_3__) {
            for (int k_2__ = 1; k_2__ <= 2; ++k_2__) {
                for (int k_1__ = 1; k_1__ <= N_cond; ++k_1__) {
                    for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__ << '.' << k_2__ << '.' << k_3__;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
    }

}; // model

}

typedef model_choiceRT_lba_namespace::model_choiceRT_lba stan_model;


#endif
