/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_prl_fictitious_woa_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_prl_fictitious_woa");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_prl_fictitious_woa");
    reader.add_event(179, 164, "end", "model_prl_fictitious_woa");
    return reader;
}

#include <meta_header.hpp>
 class model_prl_fictitious_woa : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<int> > choice;
    vector<vector<double> > outcome;
    vector_d initV;
public:
    model_prl_fictitious_woa(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_prl_fictitious_woa(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_prl_fictitious_woa_namespace::model_prl_fictitious_woa";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 25;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 26;
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            context__.validate_dims("data initialization", "choice", "int", context__.to_vec(N,T));
            validate_non_negative_index("choice", "N", N);
            validate_non_negative_index("choice", "T", T);
            choice = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("choice");
            pos__ = 0;
            size_t choice_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < choice_limit_1__; ++i_1__) {
                size_t choice_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < choice_limit_0__; ++i_0__) {
                    choice[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 27;
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("outcome");
            pos__ = 0;
            size_t outcome_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
                size_t outcome_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                    outcome[i_0__][i_1__] = vals_r__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 23;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 24;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 25;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 26;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],-(1));
                    check_less_or_equal(function__,"choice[k0__][k1__]",choice[k0__][k1__],2);
                }
            }
            current_statement_begin__ = 27;
            // initialize data variables
            current_statement_begin__ = 32;
            validate_non_negative_index("initV", "2", 2);
            initV = vector_d(static_cast<Eigen::VectorXd::Index>(2));
            stan::math::fill(initV,DUMMY_VAR__);

            current_statement_begin__ = 33;
            stan::math::assign(initV, rep_vector(0.0,2));

            // validate transformed data
            current_statement_begin__ = 32;

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 39;
            validate_non_negative_index("mu_pr", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 40;
            validate_non_negative_index("sigma", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 43;
            validate_non_negative_index("eta_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 44;
            validate_non_negative_index("beta_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_prl_fictitious_woa() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "2", 2);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(2));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "2", 2);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(2));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("eta_pr")))
            throw std::runtime_error("variable eta_pr missing");
        vals_r__ = context__.vals_r("eta_pr");
        pos__ = 0U;
        validate_non_negative_index("eta_pr", "N", N);
        context__.validate_dims("initialization", "eta_pr", "vector_d", context__.to_vec(N));
        vector_d eta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            eta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(eta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable eta_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        validate_non_negative_index("beta_pr", "N", N);
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(2,lp__);
            else
                mu_pr = in__.vector_constrain(2);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,2,lp__);
            else
                sigma = in__.vector_lb_constrain(0,2);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  eta_pr;
            (void) eta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                eta_pr = in__.vector_constrain(N,lp__);
            else
                eta_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta_pr;
            (void) beta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_pr = in__.vector_constrain(N,lp__);
            else
                beta_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 49;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
            (void) eta;  // dummy to suppress unused var warning

            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta,DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);


            current_statement_begin__ = 52;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 53;
                stan::model::assign(eta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(eta_pr,i,"eta_pr",1)))), 
                            "assigning variable eta");
                current_statement_begin__ = 54;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10), 
                            "assigning variable beta");
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(eta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"eta",eta,0);
            check_less_or_equal(function__,"eta",eta,1);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"beta",beta,0);
            check_less_or_equal(function__,"beta",beta,10);

            // model body

            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 64;
            lp_accum__.add(normal_log<propto__>(eta_pr, 0, 1));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            current_statement_begin__ = 67;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 69;
                validate_non_negative_index("ev", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(2));
                (void) ev;  // dummy to suppress unused var warning

                stan::math::initialize(ev, DUMMY_VAR__);
                stan::math::fill(ev,DUMMY_VAR__);
                current_statement_begin__ = 70;
                validate_non_negative_index("prob", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  prob(static_cast<Eigen::VectorXd::Index>(2));
                (void) prob;  // dummy to suppress unused var warning

                stan::math::initialize(prob, DUMMY_VAR__);
                stan::math::fill(prob,DUMMY_VAR__);
                current_statement_begin__ = 71;
                local_scalar_t__ prob_1_;
                (void) prob_1_;  // dummy to suppress unused var warning

                stan::math::initialize(prob_1_, DUMMY_VAR__);
                stan::math::fill(prob_1_,DUMMY_VAR__);
                current_statement_begin__ = 73;
                local_scalar_t__ PE;
                (void) PE;  // dummy to suppress unused var warning

                stan::math::initialize(PE, DUMMY_VAR__);
                stan::math::fill(PE,DUMMY_VAR__);
                current_statement_begin__ = 74;
                local_scalar_t__ PEnc;
                (void) PEnc;  // dummy to suppress unused var warning

                stan::math::initialize(PEnc, DUMMY_VAR__);
                stan::math::fill(PEnc,DUMMY_VAR__);


                current_statement_begin__ = 77;
                stan::math::assign(ev, initV);
                current_statement_begin__ = 79;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 81;
                    stan::model::assign(prob, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                (1 / (1 + stan::math::exp((get_base1(beta,i,"beta",1) * (get_base1(ev,2,"ev",1) - get_base1(ev,1,"ev",1)))))), 
                                "assigning variable prob");
                    current_statement_begin__ = 82;
                    stan::math::assign(prob_1_, get_base1(prob,1,"prob",1));
                    current_statement_begin__ = 83;
                    stan::model::assign(prob, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (1 - prob_1_), 
                                "assigning variable prob");
                    current_statement_begin__ = 84;
                    lp_accum__.add(categorical_log<propto__>(get_base1(get_base1(choice,i,"choice",1),t,"choice",2), prob));
                    current_statement_begin__ = 87;
                    stan::math::assign(PE, (get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                    current_statement_begin__ = 88;
                    stan::math::assign(PEnc, (-(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1)));
                    current_statement_begin__ = 91;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), "ev") + (get_base1(eta,i,"eta",1) * PE)), 
                                "assigning variable ev");
                    current_statement_begin__ = 92;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni((3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2))), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni((3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2))), stan::model::nil_index_list()), "ev") + (get_base1(eta,i,"eta",1) * PEnc)), 
                                "assigning variable ev");
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("eta_pr");
        names__.push_back("beta_pr");
        names__.push_back("eta");
        names__.push_back("beta");
        names__.push_back("mu_eta");
        names__.push_back("mu_beta");
        names__.push_back("log_lik");
        names__.push_back("ev_c");
        names__.push_back("ev_nc");
        names__.push_back("pe_c");
        names__.push_back("pe_nc");
        names__.push_back("dv");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_prl_fictitious_woa_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(2);
        vector_d sigma = in__.vector_lb_constrain(0,2);
        vector_d eta_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(eta_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 49;
            validate_non_negative_index("eta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  eta(static_cast<Eigen::VectorXd::Index>(N));
            (void) eta;  // dummy to suppress unused var warning

            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta,DUMMY_VAR__);
            current_statement_begin__ = 50;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);


            current_statement_begin__ = 52;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 53;
                stan::model::assign(eta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,1,"mu_pr",1) + (get_base1(sigma,1,"sigma",1) * get_base1(eta_pr,i,"eta_pr",1)))), 
                            "assigning variable eta");
                current_statement_begin__ = 54;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))) * 10), 
                            "assigning variable beta");
            }

            // validate transformed parameters
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"eta",eta,0);
            check_less_or_equal(function__,"eta",eta,1);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"beta",beta,0);
            check_less_or_equal(function__,"beta",beta,10);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(eta[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 99;
            local_scalar_t__ mu_eta;
            (void) mu_eta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_eta, DUMMY_VAR__);
            stan::math::fill(mu_eta,DUMMY_VAR__);
            current_statement_begin__ = 100;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta, DUMMY_VAR__);
            stan::math::fill(mu_beta,DUMMY_VAR__);
            current_statement_begin__ = 103;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 106;
            validate_non_negative_index("ev_c", "N", N);
            validate_non_negative_index("ev_c", "T", T);
            vector<vector<local_scalar_t__> > ev_c(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(ev_c, DUMMY_VAR__);
            stan::math::fill(ev_c,DUMMY_VAR__);
            current_statement_begin__ = 107;
            validate_non_negative_index("ev_nc", "N", N);
            validate_non_negative_index("ev_nc", "T", T);
            vector<vector<local_scalar_t__> > ev_nc(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(ev_nc, DUMMY_VAR__);
            stan::math::fill(ev_nc,DUMMY_VAR__);
            current_statement_begin__ = 109;
            validate_non_negative_index("pe_c", "N", N);
            validate_non_negative_index("pe_c", "T", T);
            vector<vector<local_scalar_t__> > pe_c(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(pe_c, DUMMY_VAR__);
            stan::math::fill(pe_c,DUMMY_VAR__);
            current_statement_begin__ = 110;
            validate_non_negative_index("pe_nc", "N", N);
            validate_non_negative_index("pe_nc", "T", T);
            vector<vector<local_scalar_t__> > pe_nc(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(pe_nc, DUMMY_VAR__);
            stan::math::fill(pe_nc,DUMMY_VAR__);
            current_statement_begin__ = 111;
            validate_non_negative_index("dv", "N", N);
            validate_non_negative_index("dv", "T", T);
            vector<vector<local_scalar_t__> > dv(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(dv, DUMMY_VAR__);
            stan::math::fill(dv,DUMMY_VAR__);
            current_statement_begin__ = 114;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 117;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 118;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 119;
                    stan::model::assign(ev_c, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable ev_c");
                    current_statement_begin__ = 120;
                    stan::model::assign(ev_nc, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable ev_nc");
                    current_statement_begin__ = 122;
                    stan::model::assign(pe_c, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable pe_c");
                    current_statement_begin__ = 123;
                    stan::model::assign(pe_nc, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable pe_nc");
                    current_statement_begin__ = 124;
                    stan::model::assign(dv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable dv");
                    current_statement_begin__ = 126;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 130;
            stan::math::assign(mu_eta, Phi_approx(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 131;
            stan::math::assign(mu_beta, (Phi_approx(get_base1(mu_pr,2,"mu_pr",1)) * 10));

            current_statement_begin__ = 134;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 136;
                validate_non_negative_index("ev", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  ev(static_cast<Eigen::VectorXd::Index>(2));
                (void) ev;  // dummy to suppress unused var warning

                stan::math::initialize(ev, DUMMY_VAR__);
                stan::math::fill(ev,DUMMY_VAR__);
                current_statement_begin__ = 137;
                validate_non_negative_index("prob", "2", 2);
                Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  prob(static_cast<Eigen::VectorXd::Index>(2));
                (void) prob;  // dummy to suppress unused var warning

                stan::math::initialize(prob, DUMMY_VAR__);
                stan::math::fill(prob,DUMMY_VAR__);
                current_statement_begin__ = 138;
                local_scalar_t__ prob_1_;
                (void) prob_1_;  // dummy to suppress unused var warning

                stan::math::initialize(prob_1_, DUMMY_VAR__);
                stan::math::fill(prob_1_,DUMMY_VAR__);
                current_statement_begin__ = 140;
                local_scalar_t__ PE;
                (void) PE;  // dummy to suppress unused var warning

                stan::math::initialize(PE, DUMMY_VAR__);
                stan::math::fill(PE,DUMMY_VAR__);
                current_statement_begin__ = 141;
                local_scalar_t__ PEnc;
                (void) PEnc;  // dummy to suppress unused var warning

                stan::math::initialize(PEnc, DUMMY_VAR__);
                stan::math::fill(PEnc,DUMMY_VAR__);


                current_statement_begin__ = 144;
                stan::math::assign(ev, initV);
                current_statement_begin__ = 146;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 148;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 150;
                    stan::model::assign(prob, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                (1 / (1 + stan::math::exp((get_base1(beta,i,"beta",1) * (get_base1(ev,2,"ev",1) - get_base1(ev,1,"ev",1)))))), 
                                "assigning variable prob");
                    current_statement_begin__ = 151;
                    stan::math::assign(prob_1_, get_base1(prob,1,"prob",1));
                    current_statement_begin__ = 152;
                    stan::model::assign(prob, 
                                stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                                (1 - prob_1_), 
                                "assigning variable prob");
                    current_statement_begin__ = 154;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + categorical_log(get_base1(get_base1(choice,i,"choice",1),t,"choice",2),prob)), 
                                "assigning variable log_lik");
                    current_statement_begin__ = 157;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                categorical_rng(prob, base_rng__), 
                                "assigning variable y_pred");
                    current_statement_begin__ = 160;
                    stan::math::assign(PE, (get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2) - get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1)));
                    current_statement_begin__ = 161;
                    stan::math::assign(PEnc, (-(get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2)) - get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1)));
                    current_statement_begin__ = 164;
                    stan::model::assign(ev_c, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(ev,get_base1(get_base1(choice,i,"choice",1),t,"choice",2),"ev",1), 
                                "assigning variable ev_c");
                    current_statement_begin__ = 165;
                    stan::model::assign(ev_nc, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                get_base1(ev,(3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2)),"ev",1), 
                                "assigning variable ev_nc");
                    current_statement_begin__ = 167;
                    stan::model::assign(pe_c, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                PE, 
                                "assigning variable pe_c");
                    current_statement_begin__ = 168;
                    stan::model::assign(pe_nc, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                PEnc, 
                                "assigning variable pe_nc");
                    current_statement_begin__ = 169;
                    stan::model::assign(dv, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                (PE - PEnc), 
                                "assigning variable dv");
                    current_statement_begin__ = 172;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni(get_base1(get_base1(choice,i,"choice",1),t,"choice",2)), stan::model::nil_index_list()), "ev") + (get_base1(eta,i,"eta",1) * PE)), 
                                "assigning variable ev");
                    current_statement_begin__ = 173;
                    stan::model::assign(ev, 
                                stan::model::cons_list(stan::model::index_uni((3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2))), stan::model::nil_index_list()), 
                                (stan::model::rvalue(ev, stan::model::cons_list(stan::model::index_uni((3 - get_base1(get_base1(choice,i,"choice",1),t,"choice",2))), stan::model::nil_index_list()), "ev") + (get_base1(eta,i,"eta",1) * PEnc)), 
                                "assigning variable ev");
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 99;
            check_greater_or_equal(function__,"mu_eta",mu_eta,0);
            check_less_or_equal(function__,"mu_eta",mu_eta,1);
            current_statement_begin__ = 100;
            check_greater_or_equal(function__,"mu_beta",mu_beta,0);
            check_less_or_equal(function__,"mu_beta",mu_beta,10);
            current_statement_begin__ = 103;
            current_statement_begin__ = 106;
            current_statement_begin__ = 107;
            current_statement_begin__ = 109;
            current_statement_begin__ = 110;
            current_statement_begin__ = 111;
            current_statement_begin__ = 114;

            // write generated quantities
        vars__.push_back(mu_eta);
        vars__.push_back(mu_beta);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(ev_c[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(ev_nc[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(pe_c[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(pe_nc[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(dv[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_prl_fictitious_woa";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_c" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_nc" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pe_c" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pe_nc" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "dv" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_c" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ev_nc" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pe_c" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pe_nc" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "dv" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_prl_fictitious_woa_namespace::model_prl_fictitious_woa stan_model;


#endif
