% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyprus_readutils.R
\name{cyprus_read_loops}
\alias{cyprus_read_loops}
\title{read HDF5 loop files in the Cyprus CalcLoops format}
\usage{
cyprus_read_loops(selections, files, Time, nstoch, accumulated = TRUE,
  legacy_traj = TRUE, verbose = FALSE, check_group_names = FALSE,
  spin_project = FALSE, project_gamma = NULL, use_parallel = TRUE)
}
\arguments{
\item{selections}{Named list with names from the list 'Naive', 'Scalar', 'dOp', 'Loops'
'LpsDw', 'LpsDwCv', 'LoopsCv' specifying the requesetd loop types.
The elements of this list are in turn expected
be data frames of the form
\tabular{rrr}{
\strong{px} \tab \strong{py} \tab \strong{pz} \cr
0           \tab 0           \tab 1           \cr
-2          \tab 1           \tab -3          \cr
...         \tab ...         \tab ...
}
specifying the momentum combinations to be extracted for each
loop type.}

\item{files}{Vector of strings, list of HDF5 files to be processed.}

\item{Time}{Integer, time extent of the lattice.}

\item{nstoch}{Integer, number of stochastic samples to be expected in file.}

\item{accumulated}{Boolean or vector of boolean, specifies whether the loops,
as organised by stochastic sample,
are accumulated, such that, say, element \code{n} corresponds to the
sum over the first \code{n} stochastic samples. If specified as \code{TRUE},
the data is post-processed to recover the measurements for the particular
samples. In case this is specified as a vector, it must be of the same
length as \code{files}. Default: TRUE.}

\item{legacy_traj}{Boolean. The root group for the loop data is 'conf_xxxx', where 'xxxx'
corresponds to what is passed via the 'traj' flag to CalcLoops. When
left empty, this defaults to '0004'. If this was left emtpy when
the loop files were generated, set this to \code{TRUE} and the paths
will be constructed with 'conf_0004' as their root group.
When specified as a vector, it must be of length \code{length(files)}
giving the integer configuration indices, such as \code{c(0, 2, 4, 6)}
Default: TRUE.}

\item{verbose}{Boolean, output I/O time per file. Requires 'tictoc' package. Default FALSE.}

\item{check_group_names}{Boolean, employ \code{rhdf5::h5ls} to check if all the group names
that we want to read are actually in the file. This can be slow
for large files. Default: FALSE.}

\item{spin_project}{Boolean, whether the loops should be spin projected after being read.
Must be provided to together with \code{project_gamma}! Default: FALSE}

\item{project_gamma}{Named list of the same length as \code{selections} containing, for each
selected loop type a 4x4 complex-valued projection matrix. For vector
loop types, one matrix must be provided per direction (so \code{project_gamma$loop_type}
is a numbered list with indices \code{c(1,2,3,4)}. Default: NULL}

\item{use_parallel}{Boolean, whether to parallelise over the files using the \code{mclapply} from the \code{parallel}
package.}
}
\value{
Named nested list of the same length as \code{selections} containg the loop data
in the \link{raw_cf} format. Each named element corresponds to one loop
type.
For scalar-valued loop types, each element of the underlying numbered list
corresponds to one momentum combination as specified via \code{selections}
for this loop type in the same order.
For the vector-valued loop types, the first level of the underlying numbered
list has four elements corresponding to the four derivative directions
in the order t,x,y,z.
At the next level, the underlying numbered list corresponds to the momentum
combinations for this loop type and derivative direction, just as for the
scalar type.
}
\description{
The CalcLoops code produces HDF5 files which contain
a matrix of momenta and the data for the loops (without
spin projection) organised by stochastic sample. Currently, the
reading code assumes that there is a single configuration stored per
file.
}
