% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selector_gcv.R
\name{gcv_selector}
\alias{gcv_selector}
\title{IPW Estimator Selector via Global Cross-Validation}
\usage{
gcv_selector(
  W,
  A,
  Y,
  delta = 0,
  gn_pred_natural,
  gn_pred_shifted,
  Qn_pred_natural,
  Qn_pred_shifted
)
}
\arguments{
\item{W}{A \code{matrix}, \code{data.frame}, or similar containing a set of
baseline covariates.}

\item{A}{A \code{numeric} vector corresponding to a exposure variable. The
parameter of interest is defined as a location shift of this quantity.}

\item{Y}{A \code{numeric} vector of the observed outcomes.}

\item{delta}{A \code{numeric} value indicating the shift in the exposure to
be used in defining the target parameter. This is defined with respect to
the scale of the exposure (A).}

\item{gn_pred_natural}{A \code{matrix} of conditional density estimates of
the exposure mechanism g(A|W) along a grid of the regularization parameter,
at the natural (observed, actual) values of the exposure.}

\item{gn_pred_shifted}{A \code{matrix} of conditional density estimates of
the exposure mechanism g(A+delta|W) along a grid of the regularization
parameter, at the shifted (counterfactual) values of the exposure.}

\item{Qn_pred_natural}{A \code{numeric} of the outcome mechanism estimate at
the natural (i.e., observed) values of the exposure. HAL regression is used
for the estimate, with the regularization term chosen by cross-validation.}

\item{Qn_pred_shifted}{A \code{numeric} of the outcome mechanism estimate at
the shifted (i.e., counterfactual) values of the exposure. HAL regression
is used for the estimate, with the regularization term chosen by
cross-validation.}
}
\description{
IPW Estimator Selector via Global Cross-Validation
}
\keyword{internal}
