% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bin_lengths}
\alias{bin_lengths}
\title{Convert a vector of lengths into binned values}
\usage{
bin_lengths(x, binwidth, include_upper = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector of values}

\item{binwidth}{Numeric vector specifying how wide the length bins should be}

\item{include_upper}{Logical. Append the upper value of the bin and return
the length range as a character string (TRUE), or return the lower value as
numeric (FALSE, default)}

\item{...}{Additional arguments passed onto \code{\link[base]{cut}}}
}
\value{
A vector of values the same length as x, but binned to the values
according to binwidth
}
\description{
This will take a vector of numeric values and bin them according to the value
specified in binwidth
}
\examples{
bin_lengths(length_data$length, binwidth = 2)
}
