% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codemeta_writer.R
\name{codemeta_writer}
\alias{codemeta_writer}
\title{codemeta writer}
\usage{
codemeta_writer(z, auto_unbox = TRUE, pretty = TRUE, ...)
}
\arguments{
\item{z}{an object of class \code{handl}; see \link{handl} for more}

\item{auto_unbox}{(logical) automatically "unbox" all atomic
vectors of length 1 (default: \code{TRUE}). passed to \code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}}

\item{pretty}{(logical) adds indentation whitespace to JSON output
(default: \code{TRUE}), passed to \code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}}

\item{...}{further params passed to \code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}}
}
\value{
an object of class \code{json}
}
\description{
codemeta writer
}
\examples{
(x <- system.file('extdata/crossref.bib', package = "handlr"))
(z <- bibtex_reader(x))
codemeta_writer(z)

# many citeproc to schema 
z <- system.file('extdata/citeproc-many.json', package = "handlr")
w <- citeproc_reader(x = z)
codemeta_writer(w)
codemeta_writer(w, pretty = FALSE)
}
\seealso{
Other writers: \code{\link{bibtex_writer}},
  \code{\link{citeproc_writer}},
  \code{\link{rdf_xml_writer}}, \code{\link{ris_writer}},
  \code{\link{schema_org_writer}}

Other codemeta: \code{\link{codemeta_reader}}
}
\concept{codemeta}
\concept{writers}
