% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_model_2chains}
\alias{example_model_2chains}
\title{Example of a hierarchical model}
\format{
A hierarchical model created by \code{\link[=fit_model]{fit_model()}} with two chains of 100 MCMC iterations. It is a named
list of 4 objects:
\describe{
\item{graph_measurements}{A data frame of model training data that shows the writer, document name, cluster assignment,
slope, principle component rotation angle, and wrapped principle component rotation angle for each training graph.}
\item{cluster_fill_counts}{A data frame of the cluster fill counts for each model training document.}
\item{rjags_data}{The model training information from \code{graph_measurements} and \code{cluster_fill_counts} formatted for RJAGS.}
\item{fitted_model}{A model fit using the \code{rjags_data} and the RJAGS and coda packages. It is an MCMC list that contains an MCMC object for
each chain.}
}
}
\usage{
example_model_2chains
}
\description{
Example of a hierarchical model
}
\examples{
# convert to a data frame and view all variable names
df <- as.data.frame(coda::as.mcmc(example_model_1chain$fitted_model))
colnames(df)

# view a trace plot
plot_trace(variable = "mu[1,1]", model = example_model_2chains)

# drop the first 25 MCMC iterations from each chain for burn-in
model <- drop_burnin(model = example_model_2chains, burn_in = 25)

\dontrun{
# analyze questioned documents
template_dir <- /path/to/cluster_template_directory
questioned_images_dir <- /path/to/questioned_documents_directory
analysis <- analyze_questioned_documents(
   template_dir = template_dir,
   questioned_images_dir = questioned_images_dir
   model = example_model_2chains
   num_cores = 2
)
analysis$posterior_probabilities
}

}
\keyword{datasets}
