% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_divisions.R
\name{lords_divisions}
\alias{lords_divisions}
\title{lords_divisions}
\usage{
lords_divisions(division_id = NULL, summary = FALSE,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE)
}
\arguments{
\item{division_id}{The id of a particular vote. If empty, returns a data frame with information on all lords divisions. Defaults to NULL.}

\item{summary}{If TRUE, returns a small data frame summarising a division outcome. Otherwise returns a data frame with details on how each peer voted. Has no effect if `division_id` is empty. Defaults to FALSE.}

\item{start_date}{The earliest date to include in the data frame, if calling all divisions. Defaults to '1900-01-01'.}

\item{end_date}{The latest date to include in the data frame, if calling all divisions. Defaults to current system date.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Imports data on House of Lords divisions
}
\examples{
\dontrun{

x <- lords_divisions(division_id = 705891, summary = TRUE)

x <- lords_divisions(division_id = 705891, summary = FALSE)

# Return all lords divisions in 2016
x <- lords_divisions(NULL, FALSE, start_date = '2016-01-01', end_date = '2016-12-31')

}
}
\keyword{Divisions}
\keyword{Lords}
