% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_oral_question_times.R
\name{commons_oral_question_times}
\alias{commons_oral_question_times}
\title{Imports data on House of Commons oral question times}
\usage{
commons_oral_question_times(session = NULL, question_id = NULL,
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{session}{Accepts a session in format yyyy/yy (e.g. 2016/17) and returns a tibble of all oral question times from that session}

\item{question_id}{Accepts a question time ID, and returns a tibble of that question time.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with information on oral question times in the House of Commons.
}
\description{
Imports data on House of Commons oral question times
}
\examples{
\dontrun{

 x <- commons_oral_question_times(session='2016/17', question_id='685697')

}
}
\seealso{
\code{\link{all_answered_questions}} \code{\link{commons_answered_questions}} \code{\link{commons_oral_questions}} \code{\link{commons_written_questions}}  \code{\link{lords_written_questions}} \code{\link{mp_questions}}
}
\keyword{Oral}
\keyword{Questions}
\keyword{Time}
