% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_questions.R
\name{mp_questions}
\alias{mp_questions}
\alias{hansard_mp_questions}
\title{Questions asked by a given MP or MPs}
\usage{
mp_questions(mp_id = NULL, question_type = "all",
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)

hansard_mp_questions(mp_id = NULL, question_type = "all",
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{mp_id}{The ID number of a member of the House of Commons, or a vector
of IDs. Defaults to \code{NULL}.}

\item{question_type}{Accepts the arguments \code{'all'}, \code{'oral'} and
\code{'written'}. This parameter is not case sensitive.
Defaults to \code{'all'}.}

\item{start_date}{Only includes questions answered on or after this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes questions answered on or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, returns data to console on the progress
of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on all questions asked by a
member of the House of Commons.
}
\description{
Accepts an ID number for a member of the House of Commons, and returns a
tibble of of all their oral and written questions.
}
\examples{
\dontrun{
x <- mp_questions(c(172,3967) 'all')

y <- mp_questions(172, 'all')

z <- mp_questions(c(172,3967) 'written')
}
}
\seealso{
\code{\link{all_answered_questions}}

\code{\link{commons_answered_questions}}

\code{\link{commons_oral_questions}}

\code{\link{commons_oral_question_times}}

\code{\link{commons_written_questions}}

\code{\link{lords_written_questions}}
}
