% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_sessions.R
\name{lords_sessions}
\alias{lords_sessions}
\alias{hansard_lords_sessions}
\title{Lords sessions}
\usage{
lords_sessions(start_date = "1900-01-01", end_date = Sys.Date(),
  tidy = TRUE, tidy_style = "snake", verbose = TRUE)

hansard_lords_sessions(start_date = "1900-01-01",
  end_date = Sys.Date(), tidy = TRUE, tidy_style = "snake",
  verbose = TRUE)
}
\arguments{
\item{start_date}{Only includes sessions starting on or after this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes sessions ending on or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts any style accepted by \link[snakecase]{to_any_case}.
Defaults to \code{'snake'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\description{
Returns the session code and other basic details for individual
House of Lords sittings. Note that this API does not appear to have been
updated with data after 2017-01-31.
}
\examples{
\dontrun{

a <- lords_sessions(start_date = "2017-01-01", end_date = "2017-01-31")
}

}
\seealso{
\code{\link[=lords_attendance_session]{lords_attendance_session()}}

\code{\link[=sessions_info]{sessions_info()}}
}
