
#line 1 "src/txt/readstat_spss_commands_read.rl"
#include <stdlib.h>
#include <strings.h>
#include <inttypes.h>

#include "../readstat.h"
#include "readstat_schema.h"

#include "readstat_copy.h"
#include "commands_util.h"


#line 15 "src/txt/readstat_spss_commands_read.c"
static const char _spss_commands_actions[] = {
	0, 1, 1, 1, 2, 1, 4, 1, 
	8, 1, 12, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 27, 1, 30, 1, 
	31, 1, 32, 1, 34, 2, 0, 1, 
	2, 1, 0, 2, 2, 28, 2, 2, 
	29, 2, 3, 28, 2, 3, 29, 2, 
	4, 9, 2, 4, 12, 2, 4, 20, 
	2, 8, 20, 2, 15, 16, 2, 17, 
	18, 2, 19, 20, 2, 21, 6, 2, 
	21, 7, 2, 21, 12, 2, 21, 20, 
	2, 23, 8, 2, 24, 8, 2, 25, 
	8, 2, 26, 8, 3, 4, 0, 1, 
	3, 4, 14, 13, 3, 4, 35, 5, 
	3, 19, 0, 1, 3, 19, 8, 20, 
	3, 21, 0, 1, 3, 21, 1, 0, 
	3, 21, 6, 11, 3, 21, 12, 6, 
	3, 33, 0, 1, 4, 19, 33, 0, 
	1, 4, 21, 6, 10, 11, 4, 21, 
	6, 11, 10
};

static const short _spss_commands_key_offsets[] = {
	0, 0, 1, 2, 7, 9, 10, 11, 
	13, 14, 15, 16, 17, 18, 19, 20, 
	21, 25, 27, 29, 35, 41, 47, 48, 
	50, 52, 54, 58, 68, 78, 79, 81, 
	85, 87, 92, 97, 98, 108, 118, 119, 
	120, 121, 126, 137, 148, 149, 155, 163, 
	171, 172, 183, 189, 195, 196, 203, 212, 
	221, 222, 226, 229, 233, 241, 249, 250, 
	261, 267, 273, 274, 283, 294, 305, 306, 
	310, 313, 319, 329, 339, 340, 344, 346, 
	350, 356, 362, 363, 365, 367, 369, 371, 
	375, 381, 387, 388, 390, 392, 394, 396, 
	398, 400, 405, 410, 411, 413, 415, 417, 
	419, 421, 425, 427, 429, 433, 439, 445, 
	446, 448, 450, 452, 454, 456, 460, 468, 
	476, 477, 488, 493, 498, 499, 503, 515, 
	520, 525, 526, 538, 550, 551, 552, 553, 
	559, 565, 571, 572, 573, 574, 582, 595, 
	597, 599, 601, 603, 605, 609, 617, 625, 
	626, 637, 642, 647, 648, 649, 651, 654, 
	656, 659, 664, 670, 676, 677, 679, 681, 
	685, 693, 701, 702, 704, 706, 708, 712, 
	717, 722, 723, 729, 741, 746, 751, 752, 
	764, 776, 777, 778, 779, 785, 791, 797, 
	798, 799, 800, 808, 821, 835, 849, 863, 
	877, 891, 905, 919, 933, 945, 950, 955, 
	956, 968, 980, 981, 994, 1006, 1018, 1019, 
	1023, 1031, 1041, 1051, 1052, 1063, 1073, 1083, 
	1084, 1086, 1088, 1090, 1092, 1100, 1102, 1110, 
	1118, 1120, 1122, 1124, 1126, 1128, 1130, 1132, 
	1134, 1138, 1146, 1154, 1155, 1166, 1171, 1176, 
	1177, 1180, 1182, 1190, 1197, 1204, 1205, 1207, 
	1214, 1219, 1224, 1225, 1226, 1227, 1228, 1229, 
	1230, 1235, 1240, 1241, 1245, 1247, 1249, 1253, 
	1261, 1269, 1270, 1272, 1274, 1276, 1278, 1280, 
	1282, 1284, 1286, 1288, 1295, 1302, 1303, 1304, 
	1305, 1311, 1317, 1323, 1324, 1329, 1334, 1335, 
	1336, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 
	1344, 1345, 1346, 1352, 1358, 1359, 1361, 1363, 
	1365, 1367, 1369, 1371, 1375, 1377, 1379, 1381, 
	1385, 1391, 1397, 1398, 1400, 1404, 1419, 1435, 
	1451, 1452, 1453, 1454, 1470, 1471, 1472, 1474, 
	1490, 1507, 1524, 1539, 1540, 1544, 1552, 1560, 
	1561, 1573, 1578, 1583, 1584, 1596, 1608, 1609, 
	1610, 1611, 1616, 1617, 1618, 1625, 1637, 1639, 
	1643, 1645, 1647, 1651, 1657, 1663, 1664, 1666, 
	1668, 1670, 1672, 1674, 1678, 1687, 1696, 1697, 
	1705, 1713, 1714, 1725, 1739, 1753, 1754, 1755, 
	1756, 1760, 1766, 1772, 1773, 1774, 1775, 1781, 
	1792, 1803, 1804, 1805, 1806, 1808, 1814, 1825, 
	1836, 1837, 1850, 1863, 1876, 1889, 1902, 1915, 
	1928, 1939, 1955, 1971, 1972, 1976, 1982, 1989, 
	1996, 1997, 1998, 1999, 2003, 2009, 2015, 2016, 
	2022, 2033, 2046, 2059, 2072, 2085, 2096, 2110, 
	2124, 2125, 2136, 2151, 2166, 2167, 2173, 2175, 
	2177, 2179, 2181, 2183, 2185, 2186, 2192, 2198, 
	2199, 2207, 2215, 2216, 2227, 2236, 2245, 2246, 
	2257, 2259, 2261, 2263, 2265, 2267, 2269, 2280, 
	2287, 2294, 2295, 2297, 2299, 2301, 2303, 2305, 
	2307, 2309, 2313, 2319, 2325, 2326, 2328, 2330, 
	2332, 2334, 2338, 2340, 2342, 2344, 2346, 2348, 
	2352, 2358, 2364, 2365, 2367, 2369, 2371, 2373, 
	2379, 2387, 2395, 2396, 2407, 2413, 2419, 2420, 
	2421, 2422, 2428, 2438, 2448, 2449, 2454, 2463, 
	2472, 2473, 2474, 2475, 2479, 2481, 2483, 2485, 
	2487, 2495, 2497, 2499, 2501, 2506, 2511, 2512, 
	2518, 2524, 2525, 2528, 2534, 2537, 2543, 2549, 
	2550, 2558, 2561, 2565, 2568, 2574, 2580, 2581, 
	2587, 2593, 2595, 2597, 2599, 2601, 2603, 2610, 
	2615, 2620, 2621, 2627, 2633, 2634, 2641, 2643, 
	2645, 2647, 2649, 2654, 2655, 2656, 2668, 2670, 
	2672, 2674, 2676, 2680, 2686, 2692, 2693, 2695, 
	2697, 2699, 2703, 2713, 2723, 2724, 2725, 2726, 
	2731, 2737, 2743, 2744, 2746, 2748, 2750, 2752, 
	2754, 2759, 2764, 2765, 2773, 2781, 2782, 2794, 
	2795, 2796, 2798, 2800, 2802, 2804, 2806, 2811, 
	2820, 2829, 2830, 2842, 2867, 2892, 2917
};

static const char _spss_commands_trans_keys[] = {
	10, 46, 9, 10, 13, 32, 46, 10, 
	46, 42, 42, 42, 47, 79, 77, 77, 
	69, 78, 84, 32, 46, 65, 73, 97, 
	105, 84, 116, 65, 97, 9, 10, 13, 
	32, 83, 115, 9, 10, 13, 32, 76, 
	108, 9, 10, 13, 32, 76, 108, 10, 
	73, 105, 83, 115, 84, 116, 9, 10, 
	13, 32, 9, 10, 13, 32, 70, 82, 
	84, 102, 114, 116, 9, 10, 13, 32, 
	70, 82, 84, 102, 114, 116, 10, 73, 
	105, 76, 88, 108, 120, 69, 101, 9, 
	10, 13, 32, 61, 9, 10, 13, 32, 
	61, 10, 9, 10, 13, 32, 34, 39, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	34, 39, 65, 90, 97, 122, 10, 34, 
	34, 9, 10, 13, 32, 47, 9, 10, 
	13, 32, 47, 70, 82, 84, 102, 114, 
	116, 9, 10, 13, 32, 47, 70, 82, 
	84, 102, 114, 116, 10, 9, 10, 13, 
	32, 48, 57, 9, 10, 13, 32, 65, 
	90, 97, 122, 9, 10, 13, 32, 65, 
	90, 97, 122, 10, 9, 10, 13, 32, 
	95, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 48, 57, 9, 10, 13, 
	32, 48, 57, 10, 9, 10, 13, 32, 
	45, 48, 57, 9, 10, 13, 32, 40, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	40, 65, 90, 97, 122, 10, 65, 97, 
	48, 57, 41, 48, 57, 9, 10, 13, 
	32, 9, 10, 13, 32, 65, 90, 97, 
	122, 9, 10, 13, 32, 65, 90, 97, 
	122, 10, 9, 10, 13, 32, 95, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 48, 57, 9, 10, 13, 32, 48, 
	57, 10, 9, 10, 13, 32, 45, 46, 
	47, 48, 57, 9, 10, 13, 32, 40, 
	46, 47, 65, 90, 97, 122, 9, 10, 
	13, 32, 40, 46, 47, 65, 90, 97, 
	122, 10, 65, 97, 48, 57, 41, 48, 
	57, 9, 10, 13, 32, 46, 47, 9, 
	10, 13, 32, 46, 47, 65, 90, 97, 
	122, 9, 10, 13, 32, 46, 47, 65, 
	90, 97, 122, 10, 78, 88, 110, 120, 
	68, 100, 9, 10, 13, 32, 9, 10, 
	13, 32, 73, 105, 9, 10, 13, 32, 
	73, 105, 10, 78, 110, 80, 112, 85, 
	117, 84, 116, 9, 10, 13, 32, 9, 
	10, 13, 32, 80, 112, 9, 10, 13, 
	32, 80, 112, 10, 82, 114, 79, 111, 
	71, 103, 82, 114, 65, 97, 77, 109, 
	9, 10, 13, 32, 46, 9, 10, 13, 
	32, 46, 10, 69, 101, 67, 99, 85, 
	117, 84, 116, 69, 101, 73, 79, 105, 
	111, 76, 108, 69, 101, 9, 10, 13, 
	32, 9, 10, 13, 32, 72, 104, 9, 
	10, 13, 32, 72, 104, 10, 65, 97, 
	78, 110, 68, 100, 76, 108, 69, 101, 
	9, 10, 13, 32, 9, 10, 13, 32, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	65, 90, 97, 122, 10, 9, 10, 13, 
	32, 95, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 47, 9, 10, 13, 
	32, 47, 10, 65, 90, 97, 122, 9, 
	10, 13, 32, 61, 95, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 61, 
	9, 10, 13, 32, 61, 10, 9, 10, 
	13, 32, 34, 39, 48, 57, 65, 90, 
	97, 122, 9, 10, 13, 32, 34, 39, 
	48, 57, 65, 90, 97, 122, 10, 34, 
	34, 9, 10, 13, 32, 46, 47, 9, 
	10, 13, 32, 46, 47, 9, 10, 13, 
	32, 46, 47, 10, 39, 39, 9, 10, 
	13, 32, 46, 47, 48, 57, 9, 10, 
	13, 32, 46, 47, 95, 48, 57, 65, 
	90, 97, 122, 82, 114, 77, 109, 65, 
	97, 84, 116, 83, 115, 9, 10, 13, 
	32, 9, 10, 13, 32, 65, 90, 97, 
	122, 9, 10, 13, 32, 65, 90, 97, 
	122, 10, 9, 10, 13, 32, 95, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 40, 9, 10, 13, 32, 40, 10, 
	70, 48, 57, 46, 48, 57, 48, 57, 
	41, 48, 57, 9, 10, 13, 32, 46, 
	9, 10, 13, 32, 46, 47, 9, 10, 
	13, 32, 46, 47, 10, 69, 101, 84, 
	116, 9, 10, 13, 32, 9, 10, 13, 
	32, 68, 70, 100, 102, 9, 10, 13, 
	32, 68, 70, 100, 102, 10, 65, 97, 
	84, 116, 65, 97, 9, 10, 13, 32, 
	9, 10, 13, 32, 47, 9, 10, 13, 
	32, 47, 10, 86, 118, 65, 90, 97, 
	122, 9, 10, 13, 32, 61, 95, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 61, 9, 10, 13, 32, 61, 10, 
	9, 10, 13, 32, 34, 39, 48, 57, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	34, 39, 48, 57, 65, 90, 97, 122, 
	10, 34, 34, 9, 10, 13, 32, 46, 
	47, 9, 10, 13, 32, 46, 47, 9, 
	10, 13, 32, 46, 47, 10, 39, 39, 
	9, 10, 13, 32, 46, 47, 48, 57, 
	9, 10, 13, 32, 46, 47, 95, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 61, 65, 95, 97, 48, 57, 66, 
	90, 98, 122, 9, 10, 13, 32, 61, 
	82, 95, 114, 48, 57, 65, 90, 97, 
	122, 9, 10, 13, 32, 61, 73, 95, 
	105, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 61, 65, 95, 97, 48, 
	57, 66, 90, 98, 122, 9, 10, 13, 
	32, 61, 66, 95, 98, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 61, 
	76, 95, 108, 48, 57, 65, 90, 97, 
	122, 9, 10, 13, 32, 61, 69, 95, 
	101, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 61, 83, 95, 115, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 61, 95, 48, 57, 65, 90, 97, 
	122, 9, 10, 13, 32, 61, 9, 10, 
	13, 32, 61, 10, 9, 10, 13, 32, 
	34, 39, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 34, 39, 48, 57, 
	65, 90, 97, 122, 10, 9, 10, 13, 
	32, 46, 47, 95, 48, 57, 65, 90, 
	97, 122, 9, 10, 13, 32, 46, 47, 
	65, 68, 70, 97, 100, 102, 9, 10, 
	13, 32, 46, 47, 65, 68, 70, 97, 
	100, 102, 10, 68, 100, 48, 57, 9, 
	10, 13, 32, 46, 47, 48, 57, 9, 
	10, 13, 32, 46, 47, 65, 90, 97, 
	122, 9, 10, 13, 32, 46, 47, 65, 
	90, 97, 122, 10, 9, 10, 13, 32, 
	95, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 65, 68, 70, 97, 100, 
	102, 9, 10, 13, 32, 65, 68, 70, 
	97, 100, 102, 10, 65, 97, 84, 116, 
	69, 101, 48, 57, 9, 10, 13, 32, 
	46, 47, 48, 57, 48, 57, 9, 10, 
	13, 32, 46, 47, 48, 57, 9, 10, 
	13, 32, 46, 47, 48, 57, 73, 105, 
	83, 115, 84, 116, 69, 101, 67, 99, 
	79, 111, 68, 100, 69, 101, 9, 10, 
	13, 32, 9, 10, 13, 32, 65, 90, 
	97, 122, 9, 10, 13, 32, 65, 90, 
	97, 122, 10, 9, 10, 13, 32, 95, 
	48, 57, 65, 90, 97, 122, 9, 10, 
	13, 32, 40, 9, 10, 13, 32, 40, 
	10, 45, 48, 57, 48, 57, 9, 10, 
	13, 32, 46, 61, 48, 57, 9, 10, 
	13, 32, 45, 48, 57, 9, 10, 13, 
	32, 45, 48, 57, 10, 48, 57, 9, 
	10, 13, 32, 61, 48, 57, 9, 10, 
	13, 32, 83, 9, 10, 13, 32, 83, 
	10, 89, 83, 77, 73, 83, 9, 10, 
	13, 32, 41, 9, 10, 13, 32, 41, 
	10, 65, 69, 97, 101, 86, 118, 69, 
	101, 9, 10, 13, 32, 9, 10, 13, 
	32, 68, 79, 100, 111, 9, 10, 13, 
	32, 68, 79, 100, 111, 10, 73, 105, 
	67, 99, 84, 116, 73, 105, 79, 111, 
	78, 110, 65, 97, 82, 114, 89, 121, 
	9, 10, 13, 32, 34, 39, 61, 9, 
	10, 13, 32, 34, 39, 61, 10, 34, 
	34, 9, 10, 13, 32, 46, 47, 9, 
	10, 13, 32, 46, 47, 9, 10, 13, 
	32, 46, 47, 10, 9, 10, 13, 32, 
	67, 9, 10, 13, 32, 67, 10, 79, 
	77, 80, 82, 69, 83, 83, 69, 68, 
	39, 39, 9, 10, 13, 32, 34, 39, 
	9, 10, 13, 32, 34, 39, 10, 85, 
	117, 84, 116, 70, 102, 73, 105, 76, 
	108, 69, 101, 76, 84, 108, 116, 69, 
	101, 67, 99, 84, 116, 9, 10, 13, 
	32, 9, 10, 13, 32, 73, 105, 9, 
	10, 13, 32, 73, 105, 10, 70, 102, 
	9, 10, 13, 32, 9, 10, 13, 32, 
	34, 39, 45, 40, 41, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 34, 
	39, 45, 46, 40, 41, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 34, 
	39, 45, 46, 40, 41, 48, 57, 65, 
	90, 97, 122, 10, 34, 34, 9, 10, 
	13, 32, 34, 39, 45, 46, 40, 41, 
	48, 57, 65, 90, 97, 122, 39, 39, 
	48, 57, 9, 10, 13, 32, 34, 39, 
	45, 46, 40, 41, 48, 57, 65, 90, 
	97, 122, 9, 10, 13, 32, 34, 39, 
	45, 46, 95, 40, 41, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 34, 
	39, 45, 46, 95, 40, 41, 48, 57, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	34, 39, 45, 40, 41, 48, 57, 65, 
	90, 97, 122, 10, 9, 10, 13, 32, 
	9, 10, 13, 32, 65, 90, 97, 122, 
	9, 10, 13, 32, 65, 90, 97, 122, 
	10, 9, 10, 13, 32, 61, 95, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 61, 9, 10, 13, 32, 61, 10, 
	9, 10, 13, 32, 34, 39, 48, 57, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	34, 39, 48, 57, 65, 90, 97, 122, 
	10, 34, 34, 9, 10, 13, 32, 46, 
	39, 39, 9, 10, 13, 32, 46, 48, 
	57, 9, 10, 13, 32, 46, 95, 48, 
	57, 65, 90, 97, 122, 65, 97, 76, 
	82, 108, 114, 85, 117, 69, 101, 9, 
	10, 13, 32, 9, 10, 13, 32, 76, 
	108, 9, 10, 13, 32, 76, 108, 10, 
	65, 97, 66, 98, 69, 101, 76, 108, 
	83, 115, 9, 10, 13, 32, 9, 10, 
	13, 32, 47, 65, 90, 97, 122, 9, 
	10, 13, 32, 47, 65, 90, 97, 122, 
	10, 9, 10, 13, 32, 65, 90, 97, 
	122, 9, 10, 13, 32, 65, 90, 97, 
	122, 10, 9, 10, 13, 32, 95, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 34, 39, 45, 46, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 34, 
	39, 45, 46, 48, 57, 65, 90, 97, 
	122, 10, 34, 34, 9, 10, 13, 32, 
	9, 10, 13, 32, 34, 39, 9, 10, 
	13, 32, 34, 39, 10, 34, 34, 9, 
	10, 13, 32, 46, 47, 9, 10, 13, 
	32, 34, 39, 45, 46, 47, 48, 57, 
	9, 10, 13, 32, 34, 39, 45, 46, 
	47, 48, 57, 10, 39, 39, 48, 57, 
	9, 10, 13, 32, 48, 57, 9, 10, 
	13, 32, 46, 86, 118, 65, 90, 97, 
	122, 9, 10, 13, 32, 46, 86, 118, 
	65, 90, 97, 122, 10, 9, 10, 13, 
	32, 65, 95, 97, 48, 57, 66, 90, 
	98, 122, 9, 10, 13, 32, 82, 95, 
	114, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 73, 95, 105, 48, 57, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	65, 95, 97, 48, 57, 66, 90, 98, 
	122, 9, 10, 13, 32, 66, 95, 98, 
	48, 57, 65, 90, 97, 122, 9, 10, 
	13, 32, 76, 95, 108, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 69, 
	95, 101, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 95, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 34, 
	39, 45, 46, 76, 108, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 34, 
	39, 45, 46, 76, 108, 48, 57, 65, 
	90, 97, 122, 10, 9, 10, 13, 32, 
	9, 10, 13, 32, 48, 57, 9, 10, 
	13, 32, 34, 39, 45, 9, 10, 13, 
	32, 34, 39, 45, 10, 39, 39, 9, 
	10, 13, 32, 9, 10, 13, 32, 48, 
	57, 9, 10, 13, 32, 48, 57, 10, 
	9, 10, 13, 32, 48, 57, 9, 10, 
	13, 32, 95, 48, 57, 65, 90, 97, 
	122, 9, 10, 13, 32, 69, 95, 101, 
	48, 57, 65, 90, 97, 122, 9, 10, 
	13, 32, 86, 95, 118, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 69, 
	95, 101, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 76, 95, 108, 48, 
	57, 65, 90, 97, 122, 9, 10, 13, 
	32, 95, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 34, 39, 45, 46, 
	48, 57, 65, 90, 97, 122, 9, 10, 
	13, 32, 34, 39, 45, 46, 48, 57, 
	65, 90, 97, 122, 10, 9, 10, 13, 
	32, 95, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 34, 39, 40, 45, 
	46, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 34, 39, 40, 45, 46, 
	48, 57, 65, 90, 97, 122, 10, 78, 
	79, 83, 110, 111, 115, 79, 111, 77, 
	109, 73, 105, 78, 110, 65, 97, 76, 
	108, 41, 9, 10, 13, 32, 46, 47, 
	9, 10, 13, 32, 46, 47, 10, 9, 
	10, 13, 32, 65, 90, 97, 122, 9, 
	10, 13, 32, 65, 90, 97, 122, 10, 
	9, 10, 13, 32, 95, 48, 57, 65, 
	90, 97, 122, 9, 10, 13, 32, 40, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	40, 65, 90, 97, 122, 10, 9, 10, 
	13, 32, 95, 48, 57, 65, 90, 97, 
	122, 82, 114, 68, 100, 67, 99, 65, 
	97, 76, 108, 69, 101, 9, 10, 13, 
	32, 95, 48, 57, 65, 90, 97, 122, 
	9, 10, 13, 32, 46, 86, 118, 9, 
	10, 13, 32, 46, 86, 118, 10, 65, 
	97, 82, 114, 73, 105, 65, 97, 66, 
	98, 76, 108, 69, 101, 9, 10, 13, 
	32, 9, 10, 13, 32, 76, 108, 9, 
	10, 13, 32, 76, 108, 10, 69, 101, 
	86, 118, 69, 101, 76, 108, 9, 10, 
	13, 32, 73, 105, 65, 97, 66, 98, 
	76, 108, 69, 101, 9, 10, 13, 32, 
	9, 10, 13, 32, 76, 108, 9, 10, 
	13, 32, 76, 108, 10, 65, 97, 66, 
	98, 69, 101, 76, 108, 9, 10, 13, 
	32, 83, 115, 9, 10, 13, 32, 65, 
	90, 97, 122, 9, 10, 13, 32, 65, 
	90, 97, 122, 10, 9, 10, 13, 32, 
	95, 48, 57, 65, 90, 97, 122, 9, 
	10, 13, 32, 34, 39, 9, 10, 13, 
	32, 34, 39, 10, 34, 34, 9, 10, 
	13, 32, 46, 47, 9, 10, 13, 32, 
	46, 47, 65, 90, 97, 122, 9, 10, 
	13, 32, 46, 47, 65, 90, 97, 122, 
	10, 9, 10, 13, 32, 46, 9, 10, 
	13, 32, 46, 65, 90, 97, 122, 9, 
	10, 13, 32, 46, 65, 90, 97, 122, 
	10, 39, 39, 9, 10, 13, 32, 65, 
	97, 84, 116, 69, 101, 48, 57, 9, 
	10, 13, 32, 46, 47, 48, 57, 73, 
	105, 76, 108, 69, 101, 9, 10, 13, 
	32, 61, 9, 10, 13, 32, 61, 10, 
	9, 10, 13, 32, 34, 39, 9, 10, 
	13, 32, 34, 39, 10, 41, 48, 57, 
	9, 10, 13, 32, 46, 47, 41, 48, 
	57, 9, 10, 13, 32, 48, 57, 9, 
	10, 13, 32, 48, 57, 10, 9, 10, 
	13, 32, 46, 47, 48, 57, 41, 48, 
	57, 9, 10, 13, 32, 41, 48, 57, 
	9, 10, 13, 32, 48, 57, 9, 10, 
	13, 32, 48, 57, 10, 9, 10, 13, 
	32, 48, 57, 9, 10, 13, 32, 48, 
	57, 69, 101, 67, 99, 79, 111, 82, 
	114, 68, 100, 9, 10, 13, 32, 61, 
	83, 115, 9, 10, 13, 32, 61, 9, 
	10, 13, 32, 61, 10, 9, 10, 13, 
	32, 48, 57, 9, 10, 13, 32, 48, 
	57, 10, 9, 10, 13, 32, 47, 48, 
	57, 65, 97, 66, 98, 76, 108, 69, 
	101, 9, 10, 13, 32, 47, 39, 39, 
	9, 10, 13, 32, 47, 95, 48, 57, 
	65, 90, 97, 122, 69, 101, 68, 100, 
	69, 101, 84, 116, 9, 10, 13, 32, 
	9, 10, 13, 32, 78, 110, 9, 10, 
	13, 32, 78, 110, 10, 65, 97, 77, 
	109, 69, 101, 9, 10, 13, 32, 9, 
	10, 13, 32, 34, 39, 65, 90, 97, 
	122, 9, 10, 13, 32, 34, 39, 65, 
	90, 97, 122, 10, 34, 34, 9, 10, 
	13, 32, 46, 9, 10, 13, 32, 87, 
	119, 9, 10, 13, 32, 87, 119, 10, 
	73, 105, 78, 110, 68, 100, 79, 111, 
	87, 119, 9, 10, 13, 32, 61, 9, 
	10, 13, 32, 61, 10, 9, 10, 13, 
	32, 65, 90, 97, 122, 9, 10, 13, 
	32, 65, 90, 97, 122, 10, 9, 10, 
	13, 32, 46, 95, 48, 57, 65, 90, 
	97, 122, 39, 39, 83, 115, 80, 112, 
	76, 108, 65, 97, 89, 121, 9, 10, 
	13, 32, 46, 9, 10, 13, 32, 46, 
	65, 90, 97, 122, 9, 10, 13, 32, 
	46, 65, 90, 97, 122, 10, 9, 10, 
	13, 32, 46, 95, 48, 57, 65, 90, 
	97, 122, 9, 10, 13, 32, 42, 47, 
	67, 68, 69, 70, 71, 73, 76, 82, 
	83, 86, 100, 101, 102, 103, 105, 108, 
	114, 115, 118, 9, 10, 13, 32, 42, 
	47, 67, 68, 69, 70, 71, 73, 76, 
	82, 83, 86, 100, 101, 102, 103, 105, 
	108, 114, 115, 118, 9, 10, 13, 32, 
	42, 47, 67, 68, 69, 70, 71, 73, 
	76, 82, 83, 86, 100, 101, 102, 103, 
	105, 108, 114, 115, 118, 9, 10, 13, 
	32, 42, 47, 67, 68, 69, 70, 71, 
	73, 76, 82, 83, 86, 100, 101, 102, 
	103, 105, 108, 114, 115, 118, 48, 57, 
	0
};

static const char _spss_commands_single_lengths[] = {
	0, 1, 1, 5, 2, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	4, 2, 2, 6, 6, 6, 1, 2, 
	2, 2, 4, 10, 10, 1, 2, 4, 
	2, 5, 5, 1, 6, 6, 1, 1, 
	1, 5, 11, 11, 1, 4, 4, 4, 
	1, 5, 4, 4, 1, 5, 5, 5, 
	1, 2, 1, 4, 4, 4, 1, 5, 
	4, 4, 1, 7, 7, 7, 1, 2, 
	1, 6, 6, 6, 1, 4, 2, 4, 
	6, 6, 1, 2, 2, 2, 2, 4, 
	6, 6, 1, 2, 2, 2, 2, 2, 
	2, 5, 5, 1, 2, 2, 2, 2, 
	2, 4, 2, 2, 4, 6, 6, 1, 
	2, 2, 2, 2, 2, 4, 4, 4, 
	1, 5, 5, 5, 1, 0, 6, 5, 
	5, 1, 6, 6, 1, 1, 1, 6, 
	6, 6, 1, 1, 1, 6, 7, 2, 
	2, 2, 2, 2, 4, 4, 4, 1, 
	5, 5, 5, 1, 1, 0, 1, 0, 
	1, 5, 6, 6, 1, 2, 2, 4, 
	8, 8, 1, 2, 2, 2, 4, 5, 
	5, 1, 2, 6, 5, 5, 1, 6, 
	6, 1, 1, 1, 6, 6, 6, 1, 
	1, 1, 6, 7, 8, 8, 8, 8, 
	8, 8, 8, 8, 6, 5, 5, 1, 
	6, 6, 1, 7, 12, 12, 1, 2, 
	6, 6, 6, 1, 5, 10, 10, 1, 
	2, 2, 2, 0, 6, 0, 6, 6, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	4, 4, 4, 1, 5, 5, 5, 1, 
	1, 0, 6, 5, 5, 1, 0, 5, 
	5, 5, 1, 1, 1, 1, 1, 1, 
	5, 5, 1, 4, 2, 2, 4, 8, 
	8, 1, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 7, 7, 1, 1, 1, 
	6, 6, 6, 1, 5, 5, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 6, 1, 2, 2, 2, 
	2, 2, 2, 4, 2, 2, 2, 4, 
	6, 6, 1, 2, 4, 7, 8, 8, 
	1, 1, 1, 8, 1, 1, 0, 8, 
	9, 9, 7, 1, 4, 4, 4, 1, 
	6, 5, 5, 1, 6, 6, 1, 1, 
	1, 5, 1, 1, 5, 6, 2, 4, 
	2, 2, 4, 6, 6, 1, 2, 2, 
	2, 2, 2, 4, 5, 5, 1, 4, 
	4, 1, 5, 8, 8, 1, 1, 1, 
	4, 6, 6, 1, 1, 1, 6, 9, 
	9, 1, 1, 1, 0, 4, 7, 7, 
	1, 7, 7, 7, 7, 7, 7, 7, 
	5, 10, 10, 1, 4, 4, 7, 7, 
	1, 1, 1, 4, 4, 4, 1, 4, 
	5, 7, 7, 7, 7, 5, 8, 8, 
	1, 5, 9, 9, 1, 6, 2, 2, 
	2, 2, 2, 2, 1, 6, 6, 1, 
	4, 4, 1, 5, 5, 5, 1, 5, 
	2, 2, 2, 2, 2, 2, 5, 7, 
	7, 1, 2, 2, 2, 2, 2, 2, 
	2, 4, 6, 6, 1, 2, 2, 2, 
	2, 4, 2, 2, 2, 2, 2, 4, 
	6, 6, 1, 2, 2, 2, 2, 6, 
	4, 4, 1, 5, 6, 6, 1, 1, 
	1, 6, 6, 6, 1, 5, 5, 5, 
	1, 1, 1, 4, 2, 2, 2, 0, 
	6, 2, 2, 2, 5, 5, 1, 6, 
	6, 1, 1, 6, 1, 4, 4, 1, 
	6, 1, 4, 1, 4, 4, 1, 4, 
	4, 2, 2, 2, 2, 2, 7, 5, 
	5, 1, 4, 4, 1, 5, 2, 2, 
	2, 2, 5, 1, 1, 6, 2, 2, 
	2, 2, 4, 6, 6, 1, 2, 2, 
	2, 4, 6, 6, 1, 1, 1, 5, 
	6, 6, 1, 2, 2, 2, 2, 2, 
	5, 5, 1, 4, 4, 1, 6, 1, 
	1, 2, 2, 2, 2, 2, 5, 5, 
	5, 1, 6, 25, 25, 25, 25
};

static const char _spss_commands_range_lengths[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 2, 2, 0, 0, 
	0, 0, 0, 0, 0, 1, 2, 2, 
	0, 3, 1, 1, 0, 1, 2, 2, 
	0, 1, 1, 0, 2, 2, 0, 3, 
	1, 1, 0, 1, 2, 2, 0, 1, 
	1, 0, 2, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 2, 2, 
	0, 3, 0, 0, 0, 2, 3, 0, 
	0, 0, 3, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 3, 0, 
	0, 0, 0, 0, 0, 2, 2, 0, 
	3, 0, 0, 0, 0, 1, 1, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 0, 0, 0, 3, 
	3, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 0, 0, 0, 
	3, 3, 0, 3, 0, 0, 0, 1, 
	1, 2, 2, 0, 3, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 2, 2, 0, 3, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 4, 4, 4, 
	0, 0, 0, 4, 0, 0, 1, 4, 
	4, 4, 4, 0, 0, 2, 2, 0, 
	3, 0, 0, 0, 3, 3, 0, 0, 
	0, 0, 0, 0, 1, 3, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 2, 2, 0, 2, 
	2, 0, 3, 3, 3, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 0, 1, 1, 2, 2, 
	0, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 1, 1, 0, 1, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	0, 3, 3, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 0, 3, 2, 2, 0, 3, 
	0, 0, 0, 0, 0, 0, 3, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	2, 2, 0, 3, 0, 0, 0, 0, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 1, 1, 1, 0, 
	1, 1, 0, 1, 1, 1, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 3, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 2, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 2, 2, 0, 3, 0, 
	0, 0, 0, 0, 0, 0, 0, 2, 
	2, 0, 3, 0, 0, 0, 1
};

static const short _spss_commands_index_offsets[] = {
	0, 0, 2, 4, 10, 13, 15, 17, 
	20, 22, 24, 26, 28, 30, 32, 34, 
	36, 41, 44, 47, 54, 61, 68, 70, 
	73, 76, 79, 84, 95, 106, 108, 111, 
	116, 119, 125, 131, 133, 142, 151, 153, 
	155, 157, 163, 175, 187, 189, 195, 202, 
	209, 211, 220, 226, 232, 234, 241, 249, 
	257, 259, 263, 266, 271, 278, 285, 287, 
	296, 302, 308, 310, 319, 329, 339, 341, 
	345, 348, 355, 364, 373, 375, 380, 383, 
	388, 395, 402, 404, 407, 410, 413, 416, 
	421, 428, 435, 437, 440, 443, 446, 449, 
	452, 455, 461, 467, 469, 472, 475, 478, 
	481, 484, 489, 492, 495, 500, 507, 514, 
	516, 519, 522, 525, 528, 531, 536, 543, 
	550, 552, 561, 567, 573, 575, 578, 588, 
	594, 600, 602, 612, 622, 624, 626, 628, 
	635, 642, 649, 651, 653, 655, 663, 674, 
	677, 680, 683, 686, 689, 694, 701, 708, 
	710, 719, 725, 731, 733, 735, 737, 740, 
	742, 745, 751, 758, 765, 767, 770, 773, 
	778, 787, 796, 798, 801, 804, 807, 812, 
	818, 824, 826, 831, 841, 847, 853, 855, 
	865, 875, 877, 879, 881, 888, 895, 902, 
	904, 906, 908, 916, 927, 939, 951, 963, 
	975, 987, 999, 1011, 1023, 1033, 1039, 1045, 
	1047, 1057, 1067, 1069, 1080, 1093, 1106, 1108, 
	1112, 1120, 1129, 1138, 1140, 1149, 1160, 1171, 
	1173, 1176, 1179, 1182, 1184, 1192, 1194, 1202, 
	1210, 1213, 1216, 1219, 1222, 1225, 1228, 1231, 
	1234, 1239, 1246, 1253, 1255, 1264, 1270, 1276, 
	1278, 1281, 1283, 1291, 1298, 1305, 1307, 1309, 
	1316, 1322, 1328, 1330, 1332, 1334, 1336, 1338, 
	1340, 1346, 1352, 1354, 1359, 1362, 1365, 1370, 
	1379, 1388, 1390, 1393, 1396, 1399, 1402, 1405, 
	1408, 1411, 1414, 1417, 1425, 1433, 1435, 1437, 
	1439, 1446, 1453, 1460, 1462, 1468, 1474, 1476, 
	1478, 1480, 1482, 1484, 1486, 1488, 1490, 1492, 
	1494, 1496, 1498, 1505, 1512, 1514, 1517, 1520, 
	1523, 1526, 1529, 1532, 1537, 1540, 1543, 1546, 
	1551, 1558, 1565, 1567, 1570, 1575, 1587, 1600, 
	1613, 1615, 1617, 1619, 1632, 1634, 1636, 1638, 
	1651, 1665, 1679, 1691, 1693, 1698, 1705, 1712, 
	1714, 1724, 1730, 1736, 1738, 1748, 1758, 1760, 
	1762, 1764, 1770, 1772, 1774, 1781, 1791, 1794, 
	1799, 1802, 1805, 1810, 1817, 1824, 1826, 1829, 
	1832, 1835, 1838, 1841, 1846, 1854, 1862, 1864, 
	1871, 1878, 1880, 1889, 1901, 1913, 1915, 1917, 
	1919, 1924, 1931, 1938, 1940, 1942, 1944, 1951, 
	1962, 1973, 1975, 1977, 1979, 1981, 1987, 1997, 
	2007, 2009, 2020, 2031, 2042, 2053, 2064, 2075, 
	2086, 2095, 2109, 2123, 2125, 2130, 2136, 2144, 
	2152, 2154, 2156, 2158, 2163, 2169, 2175, 2177, 
	2183, 2192, 2203, 2214, 2225, 2236, 2245, 2257, 
	2269, 2271, 2280, 2293, 2306, 2308, 2315, 2318, 
	2321, 2324, 2327, 2330, 2333, 2335, 2342, 2349, 
	2351, 2358, 2365, 2367, 2376, 2384, 2392, 2394, 
	2403, 2406, 2409, 2412, 2415, 2418, 2421, 2430, 
	2438, 2446, 2448, 2451, 2454, 2457, 2460, 2463, 
	2466, 2469, 2474, 2481, 2488, 2490, 2493, 2496, 
	2499, 2502, 2507, 2510, 2513, 2516, 2519, 2522, 
	2527, 2534, 2541, 2543, 2546, 2549, 2552, 2555, 
	2562, 2569, 2576, 2578, 2587, 2594, 2601, 2603, 
	2605, 2607, 2614, 2623, 2632, 2634, 2640, 2648, 
	2656, 2658, 2660, 2662, 2667, 2670, 2673, 2676, 
	2678, 2686, 2689, 2692, 2695, 2701, 2707, 2709, 
	2716, 2723, 2725, 2728, 2735, 2738, 2744, 2750, 
	2752, 2760, 2763, 2768, 2771, 2777, 2783, 2785, 
	2791, 2797, 2800, 2803, 2806, 2809, 2812, 2820, 
	2826, 2832, 2834, 2840, 2846, 2848, 2855, 2858, 
	2861, 2864, 2867, 2873, 2875, 2877, 2887, 2890, 
	2893, 2896, 2899, 2904, 2911, 2918, 2920, 2923, 
	2926, 2929, 2934, 2943, 2952, 2954, 2956, 2958, 
	2964, 2971, 2978, 2980, 2983, 2986, 2989, 2992, 
	2995, 3001, 3007, 3009, 3016, 3023, 3025, 3035, 
	3037, 3039, 3042, 3045, 3048, 3051, 3054, 3060, 
	3068, 3076, 3078, 3088, 3114, 3140, 3166
};

static const short _spss_commands_trans_targs[] = {
	612, 0, 3, 2, 3, 612, 4, 3, 
	3, 2, 612, 3, 2, 6, 0, 7, 
	6, 7, 611, 6, 9, 0, 10, 0, 
	11, 0, 12, 0, 13, 0, 14, 0, 
	15, 0, 611, 15, 17, 601, 17, 601, 
	0, 18, 18, 0, 19, 19, 0, 20, 
	21, 22, 20, 568, 568, 0, 20, 21, 
	22, 20, 23, 23, 0, 20, 21, 22, 
	20, 23, 23, 0, 21, 0, 24, 24, 
	0, 25, 25, 0, 26, 26, 0, 27, 
	28, 29, 27, 0, 27, 28, 29, 27, 
	30, 545, 558, 30, 545, 558, 0, 27, 
	28, 29, 27, 30, 545, 558, 30, 545, 
	558, 0, 28, 0, 31, 31, 0, 32, 
	566, 32, 566, 0, 33, 33, 0, 33, 
	34, 35, 33, 36, 0, 33, 34, 35, 
	33, 36, 0, 34, 0, 36, 37, 38, 
	36, 39, 563, 565, 565, 0, 36, 37, 
	38, 36, 39, 563, 565, 565, 0, 37, 
	0, 41, 40, 41, 40, 42, 43, 44, 
	42, 45, 0, 42, 43, 44, 42, 45, 
	30, 545, 558, 30, 545, 558, 0, 42, 
	43, 44, 42, 45, 30, 545, 558, 30, 
	545, 558, 0, 43, 0, 46, 47, 48, 
	46, 544, 0, 46, 47, 48, 46, 49, 
	49, 0, 46, 47, 48, 46, 49, 49, 
	0, 47, 0, 50, 51, 52, 50, 49, 
	49, 49, 49, 0, 50, 51, 52, 50, 
	53, 0, 50, 51, 52, 50, 53, 0, 
	51, 0, 54, 55, 56, 54, 540, 53, 
	0, 54, 55, 56, 54, 57, 63, 63, 
	0, 54, 55, 56, 54, 57, 63, 63, 
	0, 55, 0, 537, 537, 58, 0, 59, 
	58, 0, 60, 61, 62, 60, 0, 60, 
	61, 62, 60, 63, 63, 0, 60, 61, 
	62, 60, 63, 63, 0, 61, 0, 64, 
	65, 66, 64, 63, 63, 63, 63, 0, 
	64, 65, 66, 64, 67, 0, 64, 65, 
	66, 64, 67, 0, 65, 0, 68, 69, 
	70, 68, 533, 613, 45, 67, 0, 68, 
	69, 70, 68, 71, 613, 45, 63, 63, 
	0, 68, 69, 70, 68, 71, 613, 45, 
	63, 63, 0, 69, 0, 530, 530, 72, 
	0, 73, 72, 0, 74, 75, 76, 74, 
	613, 45, 0, 74, 75, 76, 74, 613, 
	45, 63, 63, 0, 74, 75, 76, 74, 
	613, 45, 63, 63, 0, 75, 0, 78, 
	100, 78, 100, 0, 79, 79, 0, 80, 
	81, 82, 80, 0, 80, 81, 82, 80, 
	83, 83, 0, 80, 81, 82, 80, 83, 
	83, 0, 81, 0, 84, 84, 0, 85, 
	85, 0, 86, 86, 0, 87, 87, 0, 
	88, 89, 90, 88, 0, 88, 89, 90, 
	88, 91, 91, 0, 88, 89, 90, 88, 
	91, 91, 0, 89, 0, 92, 92, 0, 
	93, 93, 0, 94, 94, 0, 95, 95, 
	0, 96, 96, 0, 97, 97, 0, 97, 
	98, 99, 97, 611, 0, 97, 98, 99, 
	97, 611, 0, 98, 0, 101, 101, 0, 
	102, 102, 0, 103, 103, 0, 104, 104, 
	0, 97, 97, 0, 106, 143, 106, 143, 
	0, 107, 107, 0, 108, 108, 0, 109, 
	110, 111, 109, 0, 109, 110, 111, 109, 
	112, 112, 0, 109, 110, 111, 109, 112, 
	112, 0, 110, 0, 113, 113, 0, 114, 
	114, 0, 115, 115, 0, 116, 116, 0, 
	117, 117, 0, 118, 119, 120, 118, 0, 
	118, 119, 120, 118, 121, 121, 0, 118, 
	119, 120, 118, 121, 121, 0, 119, 0, 
	122, 123, 124, 122, 121, 121, 121, 121, 
	0, 122, 123, 124, 122, 125, 0, 122, 
	123, 124, 122, 125, 0, 123, 0, 126, 
	126, 0, 127, 128, 129, 127, 130, 126, 
	126, 126, 126, 0, 127, 128, 129, 127, 
	130, 0, 127, 128, 129, 127, 130, 0, 
	128, 0, 130, 131, 132, 130, 133, 139, 
	141, 142, 142, 0, 130, 131, 132, 130, 
	133, 139, 141, 142, 142, 0, 131, 0, 
	135, 134, 135, 134, 136, 137, 138, 136, 
	611, 125, 0, 136, 137, 138, 136, 611, 
	125, 0, 136, 137, 138, 136, 611, 125, 
	0, 137, 0, 135, 140, 135, 140, 136, 
	137, 138, 136, 611, 125, 141, 0, 136, 
	137, 138, 136, 611, 125, 142, 142, 142, 
	142, 0, 144, 144, 0, 145, 145, 0, 
	146, 146, 0, 147, 147, 0, 148, 148, 
	0, 149, 150, 151, 149, 0, 149, 150, 
	151, 149, 152, 152, 0, 149, 150, 151, 
	149, 152, 152, 0, 150, 0, 153, 154, 
	155, 153, 152, 152, 152, 152, 0, 153, 
	154, 155, 153, 156, 0, 153, 154, 155, 
	153, 156, 0, 154, 0, 157, 0, 158, 
	0, 159, 158, 0, 160, 0, 161, 160, 
	0, 162, 163, 164, 162, 611, 0, 162, 
	163, 164, 162, 611, 148, 0, 162, 163, 
	164, 162, 611, 148, 0, 163, 0, 166, 
	166, 0, 167, 167, 0, 168, 169, 170, 
	168, 0, 168, 169, 170, 168, 171, 521, 
	171, 521, 0, 168, 169, 170, 168, 171, 
	521, 171, 521, 0, 169, 0, 172, 172, 
	0, 173, 173, 0, 174, 174, 0, 175, 
	176, 177, 175, 0, 175, 176, 177, 175, 
	178, 0, 175, 176, 177, 175, 178, 0, 
	176, 0, 196, 196, 179, 179, 0, 180, 
	181, 182, 180, 183, 179, 179, 179, 179, 
	0, 180, 181, 182, 180, 183, 0, 180, 
	181, 182, 180, 183, 0, 181, 0, 183, 
	184, 185, 183, 186, 192, 194, 195, 195, 
	0, 183, 184, 185, 183, 186, 192, 194, 
	195, 195, 0, 184, 0, 188, 187, 188, 
	187, 189, 190, 191, 189, 611, 178, 0, 
	189, 190, 191, 189, 611, 178, 0, 189, 
	190, 191, 189, 611, 178, 0, 190, 0, 
	188, 193, 188, 193, 189, 190, 191, 189, 
	611, 178, 194, 0, 189, 190, 191, 189, 
	611, 178, 195, 195, 195, 195, 0, 180, 
	181, 182, 180, 183, 197, 179, 197, 179, 
	179, 179, 0, 180, 181, 182, 180, 183, 
	198, 179, 198, 179, 179, 179, 0, 180, 
	181, 182, 180, 183, 199, 179, 199, 179, 
	179, 179, 0, 180, 181, 182, 180, 183, 
	200, 179, 200, 179, 179, 179, 0, 180, 
	181, 182, 180, 183, 201, 179, 201, 179, 
	179, 179, 0, 180, 181, 182, 180, 183, 
	202, 179, 202, 179, 179, 179, 0, 180, 
	181, 182, 180, 183, 203, 179, 203, 179, 
	179, 179, 0, 180, 181, 182, 180, 183, 
	204, 179, 204, 179, 179, 179, 0, 205, 
	206, 207, 205, 208, 179, 179, 179, 179, 
	0, 205, 206, 207, 205, 208, 0, 205, 
	206, 207, 205, 208, 0, 206, 0, 208, 
	209, 210, 208, 186, 192, 194, 211, 211, 
	0, 208, 209, 210, 208, 186, 192, 194, 
	211, 211, 0, 209, 0, 212, 213, 214, 
	212, 611, 178, 211, 211, 211, 211, 0, 
	212, 213, 214, 212, 611, 178, 215, 224, 
	229, 215, 224, 229, 0, 212, 213, 214, 
	212, 611, 178, 215, 224, 229, 215, 224, 
	229, 0, 213, 0, 516, 516, 216, 0, 
	217, 218, 219, 217, 611, 178, 216, 0, 
	217, 218, 219, 217, 611, 178, 220, 220, 
	0, 217, 218, 219, 217, 611, 178, 220, 
	220, 0, 218, 0, 221, 222, 223, 221, 
	220, 220, 220, 220, 0, 221, 222, 223, 
	221, 215, 224, 229, 215, 224, 229, 0, 
	221, 222, 223, 221, 215, 224, 229, 215, 
	224, 229, 0, 222, 0, 225, 225, 0, 
	226, 226, 0, 227, 227, 0, 228, 0, 
	217, 218, 219, 217, 611, 178, 228, 0, 
	230, 0, 217, 218, 219, 217, 614, 178, 
	230, 0, 217, 218, 219, 217, 611, 178, 
	231, 0, 233, 233, 0, 234, 234, 0, 
	97, 97, 0, 236, 236, 0, 237, 237, 
	0, 238, 238, 0, 239, 239, 0, 240, 
	240, 0, 241, 242, 243, 241, 0, 241, 
	242, 243, 241, 244, 244, 0, 241, 242, 
	243, 241, 244, 244, 0, 242, 0, 245, 
	246, 247, 245, 244, 244, 244, 244, 0, 
	245, 246, 247, 245, 248, 0, 245, 246, 
	247, 245, 248, 0, 246, 0, 249, 250, 
	0, 250, 0, 251, 252, 253, 251, 254, 
	256, 250, 0, 251, 252, 253, 251, 249, 
	250, 0, 251, 252, 253, 251, 249, 250, 
	0, 252, 0, 255, 0, 251, 252, 253, 
	251, 256, 255, 0, 256, 257, 258, 256, 
	259, 0, 256, 257, 258, 256, 259, 0, 
	257, 0, 260, 0, 261, 0, 262, 0, 
	263, 0, 264, 0, 264, 265, 266, 264, 
	97, 0, 264, 265, 266, 264, 97, 0, 
	265, 0, 268, 315, 268, 315, 0, 269, 
	269, 0, 270, 270, 0, 271, 272, 273, 
	271, 0, 271, 272, 273, 271, 274, 309, 
	274, 309, 0, 271, 272, 273, 271, 274, 
	309, 274, 309, 0, 272, 0, 275, 275, 
	0, 276, 276, 0, 277, 277, 0, 278, 
	278, 0, 279, 279, 0, 280, 280, 0, 
	281, 281, 0, 282, 282, 0, 283, 283, 
	0, 283, 284, 285, 283, 286, 304, 306, 
	0, 283, 284, 285, 283, 286, 304, 306, 
	0, 284, 0, 288, 287, 288, 287, 289, 
	290, 291, 289, 611, 292, 0, 289, 290, 
	291, 289, 611, 292, 0, 289, 290, 291, 
	289, 611, 292, 0, 290, 0, 292, 293, 
	294, 292, 295, 0, 292, 293, 294, 292, 
	295, 0, 293, 0, 296, 0, 297, 0, 
	298, 0, 299, 0, 300, 0, 301, 0, 
	302, 0, 303, 0, 97, 0, 288, 305, 
	288, 305, 306, 307, 308, 306, 286, 304, 
	0, 306, 307, 308, 306, 286, 304, 0, 
	307, 0, 310, 310, 0, 311, 311, 0, 
	312, 312, 0, 313, 313, 0, 314, 314, 
	0, 283, 283, 0, 316, 340, 316, 340, 
	0, 317, 317, 0, 318, 318, 0, 319, 
	319, 0, 320, 321, 322, 320, 0, 320, 
	321, 322, 320, 323, 323, 0, 320, 321, 
	322, 320, 323, 323, 0, 321, 0, 324, 
	324, 0, 325, 338, 339, 325, 0, 326, 
	327, 328, 326, 329, 332, 334, 326, 335, 
	336, 336, 0, 326, 327, 328, 326, 329, 
	332, 334, 611, 326, 335, 336, 336, 0, 
	326, 327, 328, 326, 329, 332, 334, 611, 
	326, 335, 336, 336, 0, 327, 0, 331, 
	330, 331, 330, 326, 327, 328, 326, 329, 
	332, 334, 611, 326, 335, 336, 336, 0, 
	331, 333, 331, 333, 335, 0, 326, 327, 
	328, 326, 329, 332, 334, 611, 326, 335, 
	336, 336, 0, 326, 327, 328, 326, 329, 
	332, 334, 611, 336, 326, 337, 336, 336, 
	0, 326, 327, 328, 326, 329, 332, 334, 
	611, 336, 326, 337, 336, 336, 0, 326, 
	327, 328, 326, 329, 332, 334, 326, 335, 
	336, 336, 0, 338, 0, 341, 342, 343, 
	341, 0, 341, 342, 343, 341, 344, 344, 
	0, 341, 342, 343, 341, 344, 344, 0, 
	342, 0, 345, 346, 347, 345, 348, 344, 
	344, 344, 344, 0, 345, 346, 347, 345, 
	348, 0, 345, 346, 347, 345, 348, 0, 
	346, 0, 348, 349, 350, 348, 351, 354, 
	356, 357, 357, 0, 348, 349, 350, 348, 
	351, 354, 356, 357, 357, 0, 349, 0, 
	353, 352, 353, 352, 97, 98, 99, 97, 
	611, 0, 353, 355, 353, 355, 97, 98, 
	99, 97, 611, 356, 0, 97, 98, 99, 
	97, 611, 357, 357, 357, 357, 0, 359, 
	359, 0, 360, 482, 360, 482, 0, 361, 
	361, 0, 362, 362, 0, 363, 364, 365, 
	363, 0, 363, 364, 365, 363, 366, 366, 
	0, 363, 364, 365, 363, 366, 366, 0, 
	364, 0, 367, 367, 0, 368, 368, 0, 
	369, 369, 0, 370, 370, 0, 371, 371, 
	0, 372, 373, 374, 372, 0, 372, 373, 
	374, 372, 375, 378, 378, 0, 372, 373, 
	374, 372, 375, 378, 378, 0, 373, 0, 
	375, 376, 377, 375, 378, 378, 0, 375, 
	376, 377, 375, 378, 378, 0, 376, 0, 
	379, 380, 381, 379, 378, 378, 378, 378, 
	0, 379, 380, 381, 379, 382, 394, 396, 
	412, 413, 424, 424, 0, 379, 380, 381, 
	379, 382, 394, 396, 412, 413, 424, 424, 
	0, 380, 0, 384, 383, 384, 383, 385, 
	386, 387, 385, 0, 385, 386, 387, 385, 
	388, 417, 0, 385, 386, 387, 385, 388, 
	417, 0, 386, 0, 390, 389, 390, 389, 
	391, 392, 393, 391, 611, 463, 0, 391, 
	392, 393, 391, 382, 394, 396, 611, 398, 
	413, 0, 391, 392, 393, 391, 382, 394, 
	396, 611, 398, 413, 0, 392, 0, 384, 
	395, 384, 395, 397, 0, 385, 386, 387, 
	385, 397, 0, 398, 399, 400, 398, 611, 
	401, 401, 378, 378, 0, 398, 399, 400, 
	398, 611, 401, 401, 378, 378, 0, 399, 
	0, 379, 380, 381, 379, 402, 378, 402, 
	378, 378, 378, 0, 379, 380, 381, 379, 
	403, 378, 403, 378, 378, 378, 0, 379, 
	380, 381, 379, 404, 378, 404, 378, 378, 
	378, 0, 379, 380, 381, 379, 405, 378, 
	405, 378, 378, 378, 0, 379, 380, 381, 
	379, 406, 378, 406, 378, 378, 378, 0, 
	379, 380, 381, 379, 407, 378, 407, 378, 
	378, 378, 0, 379, 380, 381, 379, 408, 
	378, 408, 378, 378, 378, 0, 409, 410, 
	411, 409, 378, 378, 378, 378, 0, 409, 
	410, 411, 409, 382, 394, 396, 412, 425, 
	425, 413, 424, 424, 0, 409, 410, 411, 
	409, 382, 394, 396, 412, 425, 425, 413, 
	424, 424, 0, 410, 0, 385, 386, 387, 
	385, 0, 414, 415, 416, 414, 413, 0, 
	414, 415, 416, 414, 388, 417, 419, 0, 
	414, 415, 416, 414, 388, 417, 419, 0, 
	415, 0, 390, 418, 390, 418, 420, 421, 
	422, 420, 0, 420, 421, 422, 420, 423, 
	0, 420, 421, 422, 420, 423, 0, 421, 
	0, 385, 386, 387, 385, 423, 0, 379, 
	380, 381, 379, 424, 424, 424, 424, 0, 
	379, 380, 381, 379, 426, 424, 426, 424, 
	424, 424, 0, 379, 380, 381, 379, 427, 
	424, 427, 424, 424, 424, 0, 379, 380, 
	381, 379, 428, 424, 428, 424, 424, 424, 
	0, 379, 380, 381, 379, 429, 424, 429, 
	424, 424, 424, 0, 430, 431, 432, 430, 
	424, 424, 424, 424, 0, 430, 431, 432, 
	430, 382, 394, 396, 412, 413, 433, 433, 
	0, 430, 431, 432, 430, 382, 394, 396, 
	412, 413, 433, 433, 0, 431, 0, 434, 
	435, 436, 434, 433, 433, 433, 433, 0, 
	434, 435, 436, 434, 382, 394, 437, 396, 
	412, 413, 462, 462, 0, 434, 435, 436, 
	434, 382, 394, 437, 396, 412, 413, 462, 
	462, 0, 435, 0, 438, 456, 458, 438, 
	456, 458, 0, 439, 439, 0, 440, 440, 
	0, 441, 441, 0, 442, 442, 0, 443, 
	443, 0, 444, 444, 0, 445, 0, 445, 
	446, 447, 445, 611, 448, 0, 445, 446, 
	447, 445, 611, 448, 0, 446, 0, 448, 
	449, 450, 448, 451, 451, 0, 448, 449, 
	450, 448, 451, 451, 0, 449, 0, 452, 
	453, 454, 452, 451, 451, 451, 451, 0, 
	452, 453, 454, 452, 437, 455, 455, 0, 
	452, 453, 454, 452, 437, 455, 455, 0, 
	453, 0, 452, 453, 454, 452, 455, 455, 
	455, 455, 0, 457, 457, 0, 440, 440, 
	0, 459, 459, 0, 460, 460, 0, 461, 
	461, 0, 444, 444, 0, 434, 435, 436, 
	434, 462, 462, 462, 462, 0, 463, 464, 
	465, 463, 611, 466, 466, 0, 463, 464, 
	465, 463, 611, 466, 466, 0, 464, 0, 
	467, 467, 0, 468, 468, 0, 469, 469, 
	0, 470, 470, 0, 471, 471, 0, 472, 
	472, 0, 473, 473, 0, 474, 475, 476, 
	474, 0, 474, 475, 476, 474, 477, 477, 
	0, 474, 475, 476, 474, 477, 477, 0, 
	475, 0, 478, 478, 0, 479, 479, 0, 
	480, 480, 0, 481, 481, 0, 448, 449, 
	450, 448, 0, 483, 483, 0, 484, 484, 
	0, 485, 485, 0, 486, 486, 0, 487, 
	487, 0, 488, 489, 490, 488, 0, 488, 
	489, 490, 488, 491, 491, 0, 488, 489, 
	490, 488, 491, 491, 0, 489, 0, 492, 
	492, 0, 493, 493, 0, 494, 494, 0, 
	495, 495, 0, 496, 497, 498, 496, 515, 
	515, 0, 496, 497, 498, 496, 499, 499, 
	0, 496, 497, 498, 496, 499, 499, 0, 
	497, 0, 500, 501, 502, 500, 499, 499, 
	499, 499, 0, 500, 501, 502, 500, 503, 
	513, 0, 500, 501, 502, 500, 503, 513, 
	0, 501, 0, 505, 504, 505, 504, 506, 
	507, 508, 506, 611, 509, 0, 506, 507, 
	508, 506, 611, 509, 499, 499, 0, 506, 
	507, 508, 506, 611, 509, 499, 499, 0, 
	507, 0, 510, 511, 512, 510, 611, 0, 
	510, 511, 512, 510, 611, 499, 499, 0, 
	510, 511, 512, 510, 611, 499, 499, 0, 
	511, 0, 505, 514, 505, 514, 496, 497, 
	498, 496, 0, 517, 517, 0, 518, 518, 
	0, 519, 519, 0, 520, 0, 217, 218, 
	219, 217, 611, 178, 520, 0, 522, 522, 
	0, 523, 523, 0, 524, 524, 0, 524, 
	525, 526, 524, 527, 0, 524, 525, 526, 
	524, 527, 0, 525, 0, 527, 528, 529, 
	527, 351, 354, 0, 527, 528, 529, 527, 
	351, 354, 0, 528, 0, 531, 532, 0, 
	74, 75, 76, 74, 613, 45, 0, 531, 
	532, 0, 533, 534, 535, 533, 536, 0, 
	533, 534, 535, 533, 536, 0, 534, 0, 
	68, 69, 70, 68, 613, 45, 536, 0, 
	538, 539, 0, 60, 61, 62, 60, 0, 
	538, 539, 0, 540, 541, 542, 540, 543, 
	0, 540, 541, 542, 540, 543, 0, 541, 
	0, 54, 55, 56, 54, 543, 0, 46, 
	47, 48, 46, 544, 0, 546, 546, 0, 
	547, 547, 0, 548, 548, 0, 549, 549, 
	0, 550, 550, 0, 551, 552, 553, 551, 
	554, 551, 551, 0, 551, 552, 553, 551, 
	554, 0, 551, 552, 553, 551, 554, 0, 
	552, 0, 554, 555, 556, 554, 557, 0, 
	554, 555, 556, 554, 557, 0, 555, 0, 
	42, 43, 44, 42, 45, 557, 0, 559, 
	559, 0, 560, 560, 0, 561, 561, 0, 
	562, 562, 0, 42, 43, 44, 42, 45, 
	0, 41, 564, 41, 564, 42, 43, 44, 
	42, 45, 565, 565, 565, 565, 0, 567, 
	567, 0, 562, 562, 0, 569, 569, 0, 
	570, 570, 0, 571, 572, 573, 571, 0, 
	571, 572, 573, 571, 574, 574, 0, 571, 
	572, 573, 571, 574, 574, 0, 572, 0, 
	575, 575, 0, 576, 576, 0, 577, 577, 
	0, 578, 579, 580, 578, 0, 578, 579, 
	580, 578, 581, 599, 598, 598, 0, 578, 
	579, 580, 578, 581, 599, 598, 598, 0, 
	579, 0, 583, 582, 583, 582, 584, 585, 
	586, 584, 611, 0, 584, 585, 586, 584, 
	587, 587, 0, 584, 585, 586, 584, 587, 
	587, 0, 585, 0, 588, 588, 0, 589, 
	589, 0, 590, 590, 0, 591, 591, 0, 
	592, 592, 0, 592, 593, 594, 592, 595, 
	0, 592, 593, 594, 592, 595, 0, 593, 
	0, 595, 596, 597, 595, 598, 598, 0, 
	595, 596, 597, 595, 598, 598, 0, 596, 
	0, 584, 585, 586, 584, 611, 598, 598, 
	598, 598, 0, 583, 600, 583, 600, 602, 
	602, 0, 603, 603, 0, 604, 604, 0, 
	605, 605, 0, 606, 606, 0, 607, 608, 
	609, 607, 611, 0, 607, 608, 609, 607, 
	611, 610, 610, 0, 607, 608, 609, 607, 
	611, 610, 610, 0, 608, 0, 607, 608, 
	609, 607, 611, 610, 610, 610, 610, 0, 
	611, 612, 1, 611, 2, 5, 8, 16, 
	77, 105, 165, 83, 232, 235, 267, 358, 
	16, 77, 105, 165, 83, 232, 235, 267, 
	358, 0, 611, 612, 1, 611, 2, 5, 
	8, 16, 77, 105, 165, 83, 232, 235, 
	267, 358, 16, 77, 105, 165, 83, 232, 
	235, 267, 358, 0, 611, 612, 1, 611, 
	2, 5, 8, 16, 77, 105, 165, 83, 
	232, 235, 267, 358, 16, 77, 105, 165, 
	83, 232, 235, 267, 358, 0, 611, 612, 
	1, 611, 2, 5, 8, 16, 77, 105, 
	165, 83, 232, 235, 267, 358, 16, 77, 
	105, 165, 83, 232, 235, 267, 358, 231, 
	0, 0
};

static const unsigned char _spss_commands_trans_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 19, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 21, 21, 0, 19, 19, 
	19, 19, 19, 19, 73, 73, 0, 0, 
	0, 70, 15, 17, 0, 5, 5, 5, 
	5, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 0, 
	0, 37, 0, 0, 0, 0, 0, 21, 
	21, 0, 19, 19, 19, 19, 73, 73, 
	0, 0, 0, 76, 76, 76, 76, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	37, 0, 19, 19, 19, 19, 112, 0, 
	0, 0, 43, 43, 43, 43, 3, 1, 
	0, 0, 0, 0, 0, 0, 64, 64, 
	0, 19, 19, 19, 19, 19, 116, 116, 
	0, 0, 0, 0, 0, 37, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 64, 64, 0, 19, 19, 
	19, 19, 116, 116, 0, 0, 0, 76, 
	76, 76, 76, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 37, 0, 19, 19, 
	19, 19, 112, 0, 0, 0, 46, 46, 
	46, 46, 3, 46, 46, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 64, 64, 
	0, 19, 19, 19, 19, 19, 19, 19, 
	116, 116, 0, 0, 0, 0, 0, 37, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 64, 64, 0, 19, 19, 19, 19, 
	19, 19, 116, 116, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 19, 19, 19, 19, 19, 
	19, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 19, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 19, 19, 19, 19, 19, 
	19, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 21, 21, 0, 19, 
	19, 19, 19, 73, 73, 0, 0, 0, 
	23, 23, 23, 23, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 0, 0, 0, 21, 
	21, 0, 79, 79, 79, 79, 79, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	37, 21, 21, 0, 19, 19, 19, 19, 
	19, 19, 112, 73, 73, 0, 0, 0, 
	70, 15, 17, 0, 5, 5, 5, 5, 
	5, 5, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 19, 
	0, 0, 0, 67, 11, 13, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 23, 
	23, 23, 23, 23, 23, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 21, 21, 0, 19, 19, 19, 
	19, 73, 73, 0, 0, 0, 23, 23, 
	23, 23, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 37, 
	0, 0, 1, 0, 37, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 19, 19, 
	19, 19, 19, 19, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 19, 19, 19, 19, 19, 
	19, 19, 19, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 0, 
	0, 0, 21, 21, 21, 21, 0, 79, 
	79, 79, 79, 79, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 37, 21, 21, 
	0, 19, 19, 19, 19, 19, 19, 112, 
	73, 73, 0, 0, 0, 70, 15, 17, 
	0, 58, 58, 58, 58, 58, 58, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 19, 0, 0, 0, 
	67, 11, 13, 0, 9, 9, 9, 9, 
	9, 9, 1, 0, 82, 82, 82, 82, 
	82, 82, 0, 0, 0, 0, 0, 79, 
	79, 79, 79, 79, 0, 0, 0, 0, 
	0, 0, 0, 79, 79, 79, 79, 79, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	79, 79, 79, 79, 0, 0, 0, 0, 
	0, 0, 0, 79, 79, 79, 79, 79, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	79, 79, 79, 79, 0, 0, 0, 0, 
	0, 0, 0, 79, 79, 79, 79, 79, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	79, 79, 79, 79, 0, 0, 0, 0, 
	0, 0, 0, 79, 79, 79, 79, 79, 
	0, 0, 0, 0, 0, 0, 0, 79, 
	79, 79, 79, 79, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 37, 21, 21, 
	0, 19, 19, 19, 19, 19, 19, 112, 
	73, 73, 0, 0, 0, 132, 132, 132, 
	132, 82, 82, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 0, 0, 0, 0, 0, 37, 0, 
	88, 88, 88, 88, 88, 88, 1, 0, 
	0, 0, 0, 0, 0, 0, 21, 21, 
	0, 19, 19, 19, 19, 19, 19, 73, 
	73, 0, 0, 0, 76, 76, 76, 76, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 37, 0, 
	94, 94, 94, 94, 94, 94, 1, 0, 
	37, 0, 91, 91, 91, 91, 91, 91, 
	1, 0, 7, 7, 7, 7, 7, 7, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 21, 21, 0, 19, 19, 
	19, 19, 73, 73, 0, 0, 0, 23, 
	23, 23, 23, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 19, 19, 
	19, 19, 19, 0, 0, 0, 0, 37, 
	0, 37, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	37, 0, 19, 19, 19, 19, 19, 112, 
	0, 0, 0, 37, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 19, 19, 19, 19, 19, 
	19, 19, 19, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 19, 19, 19, 19, 19, 19, 19, 
	0, 0, 0, 70, 15, 17, 0, 5, 
	5, 5, 5, 5, 5, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 19, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 19, 19, 19, 19, 
	19, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 67, 11, 
	13, 0, 0, 0, 0, 0, 0, 0, 
	0, 19, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 19, 19, 
	19, 19, 19, 19, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 37, 
	21, 21, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 37, 21, 21, 0, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 112, 73, 73, 0, 0, 0, 70, 
	15, 17, 0, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 100, 61, 61, 0, 
	67, 11, 13, 0, 37, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 40, 
	21, 21, 0, 23, 23, 23, 23, 23, 
	23, 23, 23, 0, 23, 120, 85, 85, 
	0, 23, 23, 23, 23, 23, 23, 23, 
	23, 0, 23, 124, 85, 85, 0, 19, 
	19, 19, 19, 19, 19, 19, 19, 112, 
	73, 73, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 21, 21, 
	0, 19, 19, 19, 19, 73, 73, 0, 
	0, 0, 23, 23, 23, 23, 23, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	37, 21, 21, 0, 19, 19, 19, 19, 
	19, 19, 112, 73, 73, 0, 0, 0, 
	70, 15, 17, 0, 5, 5, 5, 5, 
	5, 0, 67, 11, 13, 0, 0, 0, 
	0, 0, 0, 1, 0, 23, 23, 23, 
	23, 23, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 19, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 21, 21, 0, 19, 19, 
	19, 19, 19, 73, 73, 0, 0, 0, 
	0, 0, 0, 0, 21, 21, 0, 19, 
	19, 19, 19, 73, 73, 0, 0, 0, 
	145, 145, 145, 145, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 37, 21, 21, 0, 19, 19, 19, 
	19, 19, 19, 19, 19, 112, 73, 73, 
	0, 0, 0, 70, 15, 17, 0, 108, 
	108, 108, 108, 0, 0, 0, 0, 0, 
	0, 0, 0, 19, 19, 19, 19, 19, 
	19, 0, 0, 0, 70, 15, 17, 0, 
	104, 104, 104, 104, 104, 104, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	37, 0, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 112, 0, 0, 0, 67, 
	11, 13, 0, 37, 0, 31, 31, 31, 
	31, 1, 0, 0, 0, 0, 0, 0, 
	21, 21, 21, 21, 0, 19, 19, 19, 
	19, 19, 73, 73, 73, 73, 0, 0, 
	0, 145, 145, 145, 145, 0, 0, 0, 
	0, 0, 0, 0, 145, 145, 145, 145, 
	0, 0, 0, 0, 0, 0, 0, 145, 
	145, 145, 145, 0, 0, 0, 0, 0, 
	0, 0, 145, 145, 145, 145, 0, 0, 
	0, 0, 0, 0, 0, 145, 145, 145, 
	145, 0, 0, 0, 0, 0, 0, 0, 
	145, 145, 145, 145, 0, 0, 0, 0, 
	0, 0, 0, 145, 145, 145, 145, 0, 
	0, 0, 0, 0, 0, 0, 145, 145, 
	145, 145, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 21, 
	21, 37, 21, 21, 0, 19, 19, 19, 
	19, 19, 19, 19, 19, 73, 73, 112, 
	73, 73, 0, 0, 0, 29, 29, 29, 
	29, 0, 33, 33, 33, 33, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	19, 19, 19, 19, 19, 19, 19, 0, 
	0, 0, 67, 11, 13, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 136, 
	0, 19, 19, 19, 19, 140, 0, 0, 
	0, 35, 35, 35, 35, 1, 0, 128, 
	128, 128, 128, 0, 0, 0, 0, 0, 
	128, 128, 128, 128, 0, 0, 0, 0, 
	0, 0, 0, 128, 128, 128, 128, 0, 
	0, 0, 0, 0, 0, 0, 128, 128, 
	128, 128, 0, 0, 0, 0, 0, 0, 
	0, 128, 128, 128, 128, 0, 0, 0, 
	0, 0, 0, 0, 128, 128, 128, 128, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 37, 21, 21, 
	0, 19, 19, 19, 19, 19, 19, 19, 
	19, 112, 73, 73, 0, 0, 0, 150, 
	150, 150, 150, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 37, 21, 21, 0, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 112, 73, 
	73, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 19, 19, 
	19, 19, 19, 19, 0, 0, 0, 0, 
	0, 0, 0, 21, 21, 0, 19, 19, 
	19, 19, 73, 73, 0, 0, 0, 145, 
	145, 145, 145, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 21, 21, 0, 
	19, 19, 19, 19, 19, 73, 73, 0, 
	0, 0, 128, 128, 128, 128, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 128, 128, 128, 
	128, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 19, 19, 
	19, 19, 19, 19, 19, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 19, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 19, 19, 
	19, 19, 19, 19, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 21, 21, 
	0, 19, 19, 19, 19, 73, 73, 0, 
	0, 0, 76, 76, 76, 76, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 19, 
	0, 0, 0, 70, 15, 17, 0, 55, 
	55, 55, 55, 55, 55, 0, 0, 0, 
	0, 0, 0, 0, 21, 21, 0, 19, 
	19, 19, 19, 19, 19, 73, 73, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 21, 21, 0, 
	19, 19, 19, 19, 19, 73, 73, 0, 
	0, 0, 67, 11, 13, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 37, 0, 97, 97, 
	97, 97, 97, 97, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 19, 19, 19, 19, 
	19, 19, 0, 0, 0, 0, 37, 0, 
	25, 25, 25, 25, 25, 25, 0, 0, 
	1, 0, 0, 0, 0, 0, 37, 0, 
	19, 19, 19, 19, 112, 0, 0, 0, 
	52, 52, 52, 52, 52, 52, 1, 0, 
	0, 37, 0, 25, 25, 25, 25, 0, 
	0, 1, 0, 0, 0, 0, 0, 37, 
	0, 19, 19, 19, 19, 112, 0, 0, 
	0, 49, 49, 49, 49, 1, 0, 27, 
	27, 27, 27, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 0, 
	0, 0, 0, 0, 0, 0, 37, 0, 
	19, 19, 19, 19, 112, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 67, 11, 13, 0, 23, 23, 23, 
	23, 23, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 19, 
	19, 19, 19, 19, 19, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 21, 21, 0, 19, 
	19, 19, 19, 19, 19, 73, 73, 0, 
	0, 0, 70, 15, 17, 0, 5, 5, 
	5, 5, 5, 0, 0, 0, 0, 0, 
	0, 0, 0, 19, 19, 19, 19, 19, 
	19, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 19, 19, 19, 19, 19, 0, 0, 
	0, 0, 0, 0, 0, 21, 21, 0, 
	19, 19, 19, 19, 73, 73, 0, 0, 
	0, 23, 23, 23, 23, 23, 0, 0, 
	0, 0, 0, 67, 11, 13, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 21, 21, 0, 19, 19, 19, 19, 
	19, 73, 73, 0, 0, 0, 23, 23, 
	23, 23, 23, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 0, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 7, 7, 7, 
	7, 7, 7, 7, 7, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 37, 
	0, 0
};

static const unsigned char _spss_commands_eof_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 19, 7, 0
};

static const int spss_commands_start = 611;

static const int spss_commands_en_main = 611;


#line 14 "src/txt/readstat_spss_commands_read.rl"


readstat_schema_t *readstat_parse_spss_commands(readstat_parser_t *parser,
    const char *filepath, void *user_ctx, readstat_error_t *outError) {
    readstat_schema_t *schema = NULL;
    unsigned char *bytes = NULL;
    readstat_error_t error = READSTAT_OK;
    ssize_t len = parser->io->seek(0, READSTAT_SEEK_END, parser->io->io_ctx);
    if (len == -1) {
        error = READSTAT_ERROR_SEEK;
        goto cleanup;
    }
    parser->io->seek(0, READSTAT_SEEK_SET, parser->io->io_ctx);

    bytes = malloc(len);

    parser->io->read(bytes, len, parser->io->io_ctx);

    unsigned char *p = bytes;
    unsigned char *pe = bytes + len;
    
    unsigned char *eof = pe;
    
    unsigned char *str_start = NULL;

    size_t str_len = 0;
    
    int cs;
    
    int i;
    int line_no = 0;
    uint64_t first_integer = 0, integer = 0;
    double double_value = NAN;
    unsigned char *line_start = p;

    char varname[32];
    char argname[32];
    char string_value[32];
    char buf[1024];

    char var_list[1024][32];

    long var_col = 0;
    long var_row = 0;
    long var_len = 0;
    long var_count = 0;
    readstat_type_t var_type = READSTAT_TYPE_DOUBLE;
    label_type_t label_type = LABEL_TYPE_DOUBLE;

    int labelset_count = 0;

    if ((schema = calloc(1, sizeof(readstat_schema_t))) == NULL) {
        error = READSTAT_ERROR_MALLOC;
        goto cleanup;
    }

    schema->rows_per_observation = 1;
    
    
#line 1682 "src/txt/readstat_spss_commands_read.c"
	{
	cs = spss_commands_start;
	}

#line 1687 "src/txt/readstat_spss_commands_read.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _spss_commands_trans_keys + _spss_commands_key_offsets[cs];
	_trans = _spss_commands_index_offsets[cs];

	_klen = _spss_commands_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _spss_commands_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _spss_commands_trans_targs[_trans];

	if ( _spss_commands_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _spss_commands_actions + _spss_commands_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 73 "src/txt/readstat_spss_commands_read.rl"
	{
            integer = 0;
        }
	break;
	case 1:
#line 77 "src/txt/readstat_spss_commands_read.rl"
	{
            integer = 10 * integer + ((*p) - '0');
        }
	break;
	case 2:
#line 81 "src/txt/readstat_spss_commands_read.rl"
	{
            var_col = integer - 1;
            var_len = 1;
        }
	break;
	case 3:
#line 86 "src/txt/readstat_spss_commands_read.rl"
	{
            var_len = integer - var_col;
        }
	break;
	case 4:
#line 90 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_copy_quoted(buf, sizeof(buf), (char *)str_start, str_len);
        }
	break;
	case 5:
#line 94 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_copy_quoted(string_value, sizeof(string_value), (char *)str_start, str_len);
        }
	break;
	case 6:
#line 102 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_copy(varname, sizeof(varname), (char *)str_start, str_len);
        }
	break;
	case 7:
#line 106 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_copy(argname, sizeof(argname), (char *)str_start, str_len);
        }
	break;
	case 8:
#line 110 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
            entry->variable.type = var_type;
            entry->row = var_row;
            entry->col = var_col;
            entry->len = var_len;
        }
	break;
	case 9:
#line 118 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
            readstat_copy(entry->variable.label, sizeof(entry->variable.label), buf, sizeof(buf));
        }
	break;
	case 10:
#line 123 "src/txt/readstat_spss_commands_read.rl"
	{
            var_count = 0;
        }
	break;
	case 11:
#line 127 "src/txt/readstat_spss_commands_read.rl"
	{
            if (var_count < sizeof(var_list)/sizeof(var_list[0])) {
                memcpy(var_list[var_count++], varname, sizeof(varname));
            }
        }
	break;
	case 12:
#line 133 "src/txt/readstat_spss_commands_read.rl"
	{
            if (strcasecmp(argname, "FIRSTCASE") == 0) {
                schema->first_line = integer;
            }
            if (strcasecmp(argname, "DELIMITERS") == 0) {
                schema->field_delimiter = buf[0];
            }
        }
	break;
	case 13:
#line 142 "src/txt/readstat_spss_commands_read.rl"
	{
            char labelset_name[256];
            snprintf(labelset_name, sizeof(labelset_name), "labels%d", labelset_count++);
            for (i=0; i<var_count; i++) {
                readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
                readstat_copy(entry->labelset, sizeof(entry->labelset), labelset_name, sizeof(labelset_name));
            }
        }
	break;
	case 14:
#line 151 "src/txt/readstat_spss_commands_read.rl"
	{
            char labelset_name[256];
            snprintf(labelset_name, sizeof(labelset_name), "labels%d", labelset_count);
            error = submit_value_label(parser, labelset_name, label_type,
                first_integer, integer, double_value, string_value, buf, user_ctx);
            if (error != READSTAT_OK)
                goto cleanup;
        }
	break;
	case 15:
#line 160 "src/txt/readstat_spss_commands_read.rl"
	{ str_start = p; }
	break;
	case 16:
#line 160 "src/txt/readstat_spss_commands_read.rl"
	{ str_len = p - str_start; }
	break;
	case 17:
#line 162 "src/txt/readstat_spss_commands_read.rl"
	{ str_start = p; }
	break;
	case 18:
#line 162 "src/txt/readstat_spss_commands_read.rl"
	{ str_len = p - str_start; }
	break;
	case 19:
#line 166 "src/txt/readstat_spss_commands_read.rl"
	{ line_no++; line_start = p; }
	break;
	case 20:
#line 168 "src/txt/readstat_spss_commands_read.rl"
	{ str_start = p; }
	break;
	case 21:
#line 168 "src/txt/readstat_spss_commands_read.rl"
	{ str_len = p - str_start; }
	break;
	case 22:
#line 186 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_STRING; }
	break;
	case 23:
#line 189 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_STRING; }
	break;
	case 24:
#line 190 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_DOUBLE; }
	break;
	case 25:
#line 191 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_DOUBLE; }
	break;
	case 26:
#line 192 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_STRING; }
	break;
	case 27:
#line 213 "src/txt/readstat_spss_commands_read.rl"
	{ var_row = integer - 1; }
	break;
	case 28:
#line 214 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_DOUBLE; }
	break;
	case 29:
#line 215 "src/txt/readstat_spss_commands_read.rl"
	{ var_type = READSTAT_TYPE_DOUBLE; }
	break;
	case 30:
#line 248 "src/txt/readstat_spss_commands_read.rl"
	{ label_type = -1; }
	break;
	case 31:
#line 250 "src/txt/readstat_spss_commands_read.rl"
	{ label_type = LABEL_TYPE_DOUBLE; double_value = -integer; }
	break;
	case 32:
#line 251 "src/txt/readstat_spss_commands_read.rl"
	{ label_type = LABEL_TYPE_DOUBLE; double_value = integer; }
	break;
	case 33:
#line 252 "src/txt/readstat_spss_commands_read.rl"
	{ first_integer = integer; }
	break;
	case 34:
#line 252 "src/txt/readstat_spss_commands_read.rl"
	{ label_type = LABEL_TYPE_RANGE; }
	break;
	case 35:
#line 253 "src/txt/readstat_spss_commands_read.rl"
	{ label_type = LABEL_TYPE_STRING; }
	break;
#line 1957 "src/txt/readstat_spss_commands_read.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _spss_commands_actions + _spss_commands_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 8:
#line 110 "src/txt/readstat_spss_commands_read.rl"
	{
            readstat_schema_entry_t *entry = readstat_schema_find_or_create_entry(schema, varname);
            entry->variable.type = var_type;
            entry->row = var_row;
            entry->col = var_col;
            entry->len = var_len;
        }
	break;
	case 19:
#line 166 "src/txt/readstat_spss_commands_read.rl"
	{ line_no++; line_start = p; }
	break;
#line 1987 "src/txt/readstat_spss_commands_read.c"
		}
	}
	}

	_out: {}
	}

#line 300 "src/txt/readstat_spss_commands_read.rl"

                                       
   /* suppress warnings */
   (void)spss_commands_en_main;
                                       
    if (cs < 611) {
        char error_buf[1024];
        if (p == pe) {
            snprintf(error_buf, sizeof(error_buf), "Error parsing SPSS command file (end-of-file unexpectedly reached)");
        } else {
            snprintf(error_buf, sizeof(error_buf), "Error parsing SPSS command file around line #%d, col #%ld (%c)",
                    line_no + 1, (long)(p - line_start + 1), *p);
        }
        if (parser->handlers.error) {
            parser->handlers.error(error_buf, user_ctx);
        }
        error = READSTAT_ERROR_PARSE;
        goto cleanup;
    }

    error = submit_columns(parser, schema, user_ctx);

cleanup:
    parser->io->close(parser->io->io_ctx);
    free(bytes);
    if (error != READSTAT_OK) {
        if (outError)
            *outError = error;
        readstat_schema_free(schema);
        schema = NULL;
    }

    return schema;
}
